/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;

@SearchQueryParameter.SearchParameterDefinition(name="identifier", definition="http://hl7.org/fhir/SearchParameter/Endpoint-identifier", type=Enumerations.SearchParamType.TOKEN, documentation="Identifies this endpoint across multiple systems")
public class EndpointIdentifier
extends AbstractIdentifierParameter<Endpoint> {
    public static final String RESOURCE_COLUMN = "endpoint";

    public EndpointIdentifier() {
        super(RESOURCE_COLUMN);
    }

    @Override
    public boolean matches(Resource resource) {
        if (!this.isDefined()) {
            throw this.notDefined();
        }
        if (!(resource instanceof Endpoint)) {
            return false;
        }
        Endpoint e = (Endpoint)resource;
        return this.identifierMatches(e.getIdentifier());
    }
}

