/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search;

public class SearchQuerySortParameter {
    private final String sql;
    private final String parameterName;
    private final SortDirection direction;

    public SearchQuerySortParameter(String sql, String parameterName, SortDirection direction) {
        this.sql = sql;
        this.parameterName = parameterName;
        this.direction = direction;
    }

    public String getSql() {
        return this.sql;
    }

    public SortDirection getDirection() {
        return this.direction;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getBundleUriQueryParameterValuePart() {
        return this.getDirection().getUrlModifier() + this.getParameterName();
    }

    public static enum SortDirection {
        ASC("", ""),
        DESC(" DESC", "-");

        private final String sqlModifier;
        private final String urlModifier;

        private SortDirection(String sqlModifier, String urlModifier) {
            this.sqlModifier = sqlModifier;
            this.urlModifier = urlModifier;
        }

        public String getSqlModifierWithSpacePrefix() {
            return this.sqlModifier;
        }

        public String getUrlModifier() {
            return this.urlModifier;
        }

        public static SortDirection fromString(String sortParameter) {
            if ('-' == sortParameter.charAt(0)) {
                return DESC;
            }
            return ASC;
        }
    }
}

