/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search;

import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.DbSearchQuery;
import dev.dsf.fhir.search.Matcher;
import dev.dsf.fhir.search.PageAndCount;
import dev.dsf.fhir.search.SearchQueryIdentityFilter;
import dev.dsf.fhir.search.SearchQueryIncludeParameter;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.SearchQueryRevIncludeParameterFactory;
import jakarta.ws.rs.core.UriBuilder;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQuery<R extends Resource>
implements DbSearchQuery,
Matcher {
    public static final String PARAMETER_SORT = "_sort";
    public static final String PARAMETER_INCLUDE = "_include";
    public static final String PARAMETER_REVINCLUDE = "_revinclude";
    public static final String PARAMETER_PAGE = "_page";
    public static final String PARAMETER_COUNT = "_count";
    public static final String PARAMETER_FORMAT = "_format";
    public static final String PARAMETER_PRETTY = "_pretty";
    public static final String PARAMETER_SUMMARY = "_summary";
    public static final String[] STANDARD_PARAMETERS = new String[]{"_sort", "_include", "_revinclude", "_page", "_count", "_format", "_pretty", "_summary"};
    private static final Logger logger = LoggerFactory.getLogger(SearchQuery.class);
    private final Class<R> resourceType;
    private final String resourceColumn;
    private final String resourceTable;
    private final SearchQueryIdentityFilter userFilter;
    private final PageAndCount pageAndCount;
    private final List<SearchQueryParameter<R>> searchParameters = new ArrayList<SearchQueryParameter<R>>();
    private final List<SearchQueryRevIncludeParameterFactory> revIncludeParameterFactories = new ArrayList<SearchQueryRevIncludeParameterFactory>();
    private String filterQuery;
    private String sortSql;
    private String includeSql;
    private String revIncludeSql;
    private List<SearchQueryParameter<R>> sortParameters = Collections.emptyList();
    private List<SearchQueryIncludeParameter> includeParameters = Collections.emptyList();
    private List<SearchQueryIncludeParameter> revIncludeParameters = Collections.emptyList();

    SearchQuery(Class<R> resourceType, String resourceTable, String resourceColumn, SearchQueryIdentityFilter userFilter, int page, int count, List<? extends SearchQueryParameter<R>> searchParameters, List<? extends SearchQueryRevIncludeParameterFactory> revIncludeParameters) {
        this.resourceType = resourceType;
        this.resourceTable = resourceTable;
        this.resourceColumn = resourceColumn;
        this.userFilter = userFilter;
        this.pageAndCount = new PageAndCount(page, count);
        this.searchParameters.addAll(searchParameters);
        this.revIncludeParameterFactories.addAll(revIncludeParameters);
    }

    public SearchQuery<R> configureParameters(Map<String, List<String>> queryParameters) {
        this.searchParameters.forEach(p -> p.configure(queryParameters));
        List revIncludeParameterValues = queryParameters.getOrDefault(PARAMETER_REVINCLUDE, Collections.emptyList());
        this.revIncludeParameterFactories.forEach(p -> p.configure(revIncludeParameterValues));
        this.includeSql = this.createIncludeSql(queryParameters.get(PARAMETER_INCLUDE));
        this.revIncludeSql = this.createRevIncludeSql();
        this.filterQuery = this.createFilterQuery();
        this.sortSql = this.createSortSql(this.getFirst(queryParameters, PARAMETER_SORT));
        return this;
    }

    private String createFilterQuery() {
        Stream<String> elements = this.searchParameters.stream().filter(SearchQueryParameter::isDefined).map(SearchQueryParameter::getFilterQuery);
        if (this.userFilter != null && !this.userFilter.getFilterQuery().isEmpty()) {
            elements = Stream.concat(Stream.of(this.userFilter.getFilterQuery()), elements);
        }
        return elements.collect(Collectors.joining(" AND "));
    }

    public List<SearchQueryParameterError> getUnsupportedQueryParameters(Map<String, List<String>> queryParameters) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>(queryParameters);
        this.searchParameters.stream().flatMap(p -> p.getBaseAndModifiedParameterNames()).forEach(parameters::remove);
        Arrays.asList(STANDARD_PARAMETERS).forEach(parameters::remove);
        ArrayList<SearchQueryParameterError> errors = new ArrayList<SearchQueryParameterError>(this.getDuplicateStandardParameters(queryParameters));
        parameters.keySet().stream().map(name -> new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_PARAMETER, (String)name, null)).forEach(errors::add);
        this.searchParameters.stream().flatMap(p -> p.getErrors().stream()).forEach(errors::add);
        this.revIncludeParameterFactories.stream().flatMap(p -> p.getErrors().stream()).forEach(errors::add);
        List<String> includeParameterValues = queryParameters.getOrDefault(PARAMETER_INCLUDE, Collections.emptyList());
        this.includeParameters.stream().map(SearchQueryIncludeParameter::getBundleUriQueryParameterValues).forEach(v -> includeParameterValues.remove(v));
        if (!includeParameterValues.isEmpty()) {
            errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_PARAMETER, PARAMETER_INCLUDE, includeParameterValues));
        }
        ArrayList<String> revIncludeParameterValues = new ArrayList<String>(queryParameters.getOrDefault(PARAMETER_REVINCLUDE, Collections.emptyList()));
        this.revIncludeParameters.stream().map(SearchQueryIncludeParameter::getBundleUriQueryParameterValues).forEach(v -> revIncludeParameterValues.remove(v));
        if (!revIncludeParameterValues.isEmpty()) {
            errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_PARAMETER, PARAMETER_REVINCLUDE, revIncludeParameterValues));
        }
        if (!errors.isEmpty()) {
            logger.warn("Query parameters with error: {}", errors);
        }
        return errors;
    }

    private List<SearchQueryParameterError> getDuplicateStandardParameters(Map<String, List<String>> queryParameters) {
        ArrayList<SearchQueryParameterError> errors = new ArrayList<SearchQueryParameterError>();
        for (String parameter : STANDARD_PARAMETERS) {
            List<String> values = queryParameters.get(parameter);
            if (values == null || values.size() <= 1 || (PARAMETER_INCLUDE.equals(parameter) || PARAMETER_REVINCLUDE.equals(parameter)) && !this.hasDuplicates(values)) continue;
            errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, parameter, values));
        }
        return errors;
    }

    private boolean hasDuplicates(List<String> values) {
        return values.size() != new HashSet<String>(values).size();
    }

    private String getFirst(Map<String, List<String>> queryParameters, String key) {
        if (queryParameters.containsKey(key) && !queryParameters.get(key).isEmpty()) {
            return queryParameters.get(key).get(0);
        }
        return null;
    }

    private String createSortSql(String sortParameterValue) {
        if (sortParameterValue == null) {
            return "";
        }
        this.sortParameters = this.searchParameters.stream().filter(sp -> sp.getSortParameter().isPresent()).collect(Collectors.toList());
        if (this.sortParameters.isEmpty()) {
            return "";
        }
        return this.sortParameters.stream().map(sp -> sp.getSortParameter().get().getSql()).collect(Collectors.joining(", ", " ORDER BY ", ""));
    }

    private String createIncludeSql(List<String> includeParameterValues) {
        if (includeParameterValues == null || includeParameterValues.isEmpty()) {
            return "";
        }
        this.includeParameters = this.searchParameters.stream().flatMap(sp -> sp.getIncludeParameters().stream()).collect(Collectors.toList());
        if (this.includeParameters.isEmpty()) {
            return "";
        }
        return this.includeParameters.stream().map(SearchQueryIncludeParameter::getSql).collect(Collectors.joining(", ", ", ", ""));
    }

    private String createRevIncludeSql() {
        if (this.revIncludeParameterFactories == null || this.revIncludeParameterFactories.isEmpty()) {
            return "";
        }
        this.revIncludeParameters = this.revIncludeParameterFactories.stream().flatMap(f -> f.getRevIncludeParameters().stream()).collect(Collectors.toList());
        if (this.revIncludeParameters.isEmpty()) {
            return "";
        }
        return this.revIncludeParameters.stream().map(SearchQueryIncludeParameter::getSql).collect(Collectors.joining(", ", ", ", ""));
    }

    @Override
    public String getCountSql() {
        String countQueryMain = "SELECT count(*) FROM current_" + this.resourceTable;
        return countQueryMain + (String)(!this.filterQuery.isEmpty() ? " WHERE " + this.filterQuery : "");
    }

    @Override
    public String getSearchSql() {
        String searchQueryMain = "SELECT " + this.resourceColumn + this.includeSql + this.revIncludeSql + " FROM current_" + this.resourceTable;
        return searchQueryMain + (String)(!this.filterQuery.isEmpty() ? " WHERE " + this.filterQuery : "") + this.sortSql + this.pageAndCount.getSql();
    }

    @Override
    public void modifyStatement(PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        try {
            List filtered = this.searchParameters.stream().filter(SearchQueryParameter::isDefined).collect(Collectors.toList());
            int index = 0;
            if (this.userFilter != null) {
                while (index < this.userFilter.getSqlParameterCount()) {
                    int i = ++index;
                    this.userFilter.modifyStatement(i, i, statement);
                }
            }
            for (SearchQueryParameter q : filtered) {
                for (int i = 0; i < q.getSqlParameterCount(); ++i) {
                    q.modifyStatement(++index, i + 1, statement, arrayCreator);
                }
            }
        }
        catch (SQLException e) {
            logger.warn("Error while modifying prepared statement '{}': {}", (Object)statement.toString(), (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public PageAndCount getPageAndCount() {
        return this.pageAndCount;
    }

    public UriBuilder configureBundleUri(UriBuilder bundleUri) {
        Objects.requireNonNull(bundleUri, "bundleUri");
        this.searchParameters.stream().filter(SearchQueryParameter::isDefined).forEach(p -> p.modifyBundleUri(bundleUri));
        if (!this.sortParameters.isEmpty()) {
            bundleUri.replaceQueryParam(PARAMETER_SORT, new Object[]{this.sortParameter()});
        }
        if (!this.includeParameters.isEmpty()) {
            bundleUri.replaceQueryParam(PARAMETER_INCLUDE, this.includeParameters());
        }
        if (!this.revIncludeParameterFactories.isEmpty()) {
            bundleUri.replaceQueryParam(PARAMETER_REVINCLUDE, this.revIncludeParameters());
        }
        return bundleUri;
    }

    private String sortParameter() {
        return this.sortParameters.stream().map(p -> p.getSortParameter().get().getBundleUriQueryParameterValuePart()).collect(Collectors.joining(","));
    }

    private Object[] includeParameters() {
        return this.includeParameters.stream().map(SearchQueryIncludeParameter::getBundleUriQueryParameterValues).toArray();
    }

    private Object[] revIncludeParameters() {
        return this.revIncludeParameters.stream().map(SearchQueryIncludeParameter::getBundleUriQueryParameterValues).toArray();
    }

    public Class<R> getResourceType() {
        return this.resourceType;
    }

    @Override
    public void resloveReferencesForMatching(Resource resource, DaoProvider daoProvider) throws SQLException {
        if (resource == null) {
            return;
        }
        if (!this.getResourceType().isInstance(resource)) {
            return;
        }
        List<SQLException> exceptions = this.searchParameters.stream().filter(SearchQueryParameter::isDefined).map(p -> {
            try {
                p.resolveReferencesForMatching(resource, daoProvider);
                return null;
            }
            catch (SQLException e) {
                return e;
            }
        }).filter(e -> e != null).collect(Collectors.toList());
        if (!exceptions.isEmpty()) {
            SQLException sqlException = new SQLException("Error while resoling references");
            exceptions.forEach(sqlException::addSuppressed);
            throw sqlException;
        }
    }

    @Override
    public boolean matches(Resource resource) {
        if (resource == null) {
            return false;
        }
        if (!this.getResourceType().isInstance(resource)) {
            return false;
        }
        return this.searchParameters.stream().filter(SearchQueryParameter::isDefined).map(p -> p.matches(resource)).allMatch(b -> b);
    }

    @Override
    public void modifyIncludeResource(Resource resource, int columnIndex, Connection connection) throws SQLException {
        int includeParameterCount = this.includeParameters.size();
        int revIncludeParameterCount = this.revIncludeParameters.size();
        if (includeParameterCount > 0 && columnIndex - 1 <= includeParameterCount) {
            this.includeParameters.get(columnIndex - 2).modifyIncludeResource(resource, connection);
        } else if (this.revIncludeParameters.size() > 0 && columnIndex - 1 - includeParameterCount <= revIncludeParameterCount) {
            this.revIncludeParameters.get(columnIndex - 2 - includeParameterCount).modifyIncludeResource(resource, connection);
        } else {
            logger.warn("Unexpected column-index {}, column-index - 1 larger than include ({}) + revinclude ({}) parameter count {}", new Object[]{columnIndex, includeParameterCount, revIncludeParameterCount, includeParameterCount + revIncludeParameterCount});
            throw new IllegalStateException("Unexpected column-index " + columnIndex + ", column-index - 1 larger than include (" + includeParameterCount + ") + revinclude (" + revIncludeParameterCount + ") parameter count " + (includeParameterCount + revIncludeParameterCount));
        }
    }

    public static class SearchQueryBuilder<R extends Resource> {
        private final Class<R> resourceType;
        private final String resourceTable;
        private final String resourceColumn;
        private final int page;
        private final int count;
        private final List<SearchQueryParameter<R>> searchParameters = new ArrayList<SearchQueryParameter<R>>();
        private final List<SearchQueryRevIncludeParameterFactory> revIncludeParameters = new ArrayList<SearchQueryRevIncludeParameterFactory>();
        private SearchQueryIdentityFilter userFilter;

        public static <R extends Resource> SearchQueryBuilder<R> create(Class<R> resourceType, String resourceTable, String resourceColumn, int page, int count) {
            return new SearchQueryBuilder<R>(resourceType, resourceTable, resourceColumn, page, count);
        }

        private SearchQueryBuilder(Class<R> resourceType, String resourceTable, String resourceColumn, int page, int count) {
            this.resourceType = resourceType;
            this.resourceTable = resourceTable;
            this.resourceColumn = resourceColumn;
            this.page = page;
            this.count = count;
        }

        public SearchQueryBuilder<R> with(SearchQueryIdentityFilter userFilter) {
            this.userFilter = userFilter;
            return this;
        }

        public SearchQueryBuilder<R> with(SearchQueryParameter<R> searchParameters) {
            this.searchParameters.add(searchParameters);
            return this;
        }

        public SearchQueryBuilder<R> with(SearchQueryParameter<R> ... searchParameters) {
            return this.with(Arrays.asList(searchParameters));
        }

        public SearchQueryBuilder<R> with(List<SearchQueryParameter<R>> searchParameters) {
            this.searchParameters.addAll(searchParameters);
            return this;
        }

        public SearchQueryBuilder<R> withRevInclude(SearchQueryRevIncludeParameterFactory searchParameters) {
            this.revIncludeParameters.add(searchParameters);
            return this;
        }

        public SearchQueryBuilder<R> withRevInclude(SearchQueryRevIncludeParameterFactory ... searchParameters) {
            return this.withRevInclude(Arrays.asList(searchParameters));
        }

        public SearchQueryBuilder<R> withRevInclude(List<SearchQueryRevIncludeParameterFactory> searchParameters) {
            this.revIncludeParameters.addAll(searchParameters);
            return this;
        }

        public SearchQuery<R> build() {
            return new SearchQuery<R>(this.resourceType, this.resourceTable, this.resourceColumn, this.userFilter, this.page, this.count, this.searchParameters, this.revIncludeParameters);
        }
    }
}

