/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search;

public class PageAndCount {
    private final int page;
    private final int count;

    public PageAndCount(int page, int count) {
        this.page = page;
        this.count = count;
    }

    public String getSql() {
        return " LIMIT " + this.count + (String)(this.page > 1 ? " OFFSET " + (this.page - 1) * this.count : "");
    }

    public boolean isCountOnly(int total) {
        return this.page < 1 || this.count < 1 || this.getPageStart() > total;
    }

    public int getPage() {
        return this.page;
    }

    public int getCount() {
        return this.count;
    }

    public int getPageStart() {
        if (this.page < 1 || this.count < 1) {
            return 0;
        }
        return Math.min(1, this.page - 1) * this.count + 1;
    }

    public int getPageEnd() {
        if (this.page < 1 || this.count < 1) {
            return 0;
        }
        return this.getPageStart() - 1 + this.count;
    }

    public boolean isLastPage(int total) {
        return this.page >= this.getLastPage(total);
    }

    public int getLastPage(int total) {
        return (int)Math.ceil((double)total / (double)this.count);
    }
}

