/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.history.filter;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.history.filter.ActivityDefinitionHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.BinaryHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.BundleHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.CodeSystemHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.DocumentReferenceHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.EndpointHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.GroupHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.HealthcareServiceHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.HistoryIdentityFilter;
import dev.dsf.fhir.history.filter.HistoryIdentityFilterFactory;
import dev.dsf.fhir.history.filter.LibraryHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.LocationHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.MeasureHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.MeasureReportHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.NamingSystemHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.OrganizationAffiliationHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.OrganizationHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.PatientHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.PractitionerHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.PractitionerRoleHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.ProvenanceHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.QuestionnaireHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.QuestionnaireResponseHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.ResearchStudyHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.StructureDefinitionHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.SubscriptionHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.TaskHistoryIdentityFilter;
import dev.dsf.fhir.history.filter.ValueSetHistoryIdentityFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.ValueSet;

public class HistoryIdentityFilterFactoryImpl
implements HistoryIdentityFilterFactory {
    private final Map<Class<? extends Resource>, Function<Identity, HistoryIdentityFilter>> filtersByResource = new HashMap<Class<? extends Resource>, Function<Identity, HistoryIdentityFilter>>();

    public HistoryIdentityFilterFactoryImpl() {
        this.filtersByResource.put(ActivityDefinition.class, ActivityDefinitionHistoryIdentityFilter::new);
        this.filtersByResource.put(Binary.class, BinaryHistoryIdentityFilter::new);
        this.filtersByResource.put(Bundle.class, BundleHistoryIdentityFilter::new);
        this.filtersByResource.put(CodeSystem.class, CodeSystemHistoryIdentityFilter::new);
        this.filtersByResource.put(DocumentReference.class, DocumentReferenceHistoryIdentityFilter::new);
        this.filtersByResource.put(Endpoint.class, EndpointHistoryIdentityFilter::new);
        this.filtersByResource.put(Group.class, GroupHistoryIdentityFilter::new);
        this.filtersByResource.put(HealthcareService.class, HealthcareServiceHistoryIdentityFilter::new);
        this.filtersByResource.put(Library.class, LibraryHistoryIdentityFilter::new);
        this.filtersByResource.put(Location.class, LocationHistoryIdentityFilter::new);
        this.filtersByResource.put(Measure.class, MeasureHistoryIdentityFilter::new);
        this.filtersByResource.put(MeasureReport.class, MeasureReportHistoryIdentityFilter::new);
        this.filtersByResource.put(NamingSystem.class, NamingSystemHistoryIdentityFilter::new);
        this.filtersByResource.put(OrganizationAffiliation.class, OrganizationAffiliationHistoryIdentityFilter::new);
        this.filtersByResource.put(Organization.class, OrganizationHistoryIdentityFilter::new);
        this.filtersByResource.put(Patient.class, PatientHistoryIdentityFilter::new);
        this.filtersByResource.put(Practitioner.class, PractitionerHistoryIdentityFilter::new);
        this.filtersByResource.put(PractitionerRole.class, PractitionerRoleHistoryIdentityFilter::new);
        this.filtersByResource.put(Provenance.class, ProvenanceHistoryIdentityFilter::new);
        this.filtersByResource.put(Questionnaire.class, QuestionnaireHistoryIdentityFilter::new);
        this.filtersByResource.put(QuestionnaireResponse.class, QuestionnaireResponseHistoryIdentityFilter::new);
        this.filtersByResource.put(ResearchStudy.class, ResearchStudyHistoryIdentityFilter::new);
        this.filtersByResource.put(StructureDefinition.class, StructureDefinitionHistoryIdentityFilter::new);
        this.filtersByResource.put(Subscription.class, SubscriptionHistoryIdentityFilter::new);
        this.filtersByResource.put(Task.class, TaskHistoryIdentityFilter::new);
        this.filtersByResource.put(ValueSet.class, ValueSetHistoryIdentityFilter::new);
    }

    @Override
    public HistoryIdentityFilter getIdentityFilter(Identity identity, Class<? extends Resource> resourceType) {
        Function<Identity, HistoryIdentityFilter> factory = this.filtersByResource.get(resourceType);
        if (factory == null) {
            throw new IllegalArgumentException(HistoryIdentityFilter.class.getSimpleName() + " for " + resourceType.getClass().getName() + " not found");
        }
        return factory.apply(identity);
    }

    @Override
    public List<HistoryIdentityFilter> getIdentityFilters(Identity identity) {
        return this.filtersByResource.values().stream().map(f -> (HistoryIdentityFilter)f.apply(identity)).collect(Collectors.toList());
    }
}

