/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.history;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractDateTimeParameter;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Resource;

public class SinceParameter
extends AbstractDateTimeParameter<DomainResource> {
    public SinceParameter() {
        super("_since", "last_updated");
    }

    @Override
    protected void checkParameters(List<String> parameters) {
        List<AbstractDateTimeParameter.DateTimeValueAndTypeAndSearchType> superValuesAndTypes = super.getValuesAndTypes();
        if (superValuesAndTypes.size() > 1) {
            this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, this.parameterName, parameters, "More than one " + this.parameterName + " values"));
        }
        if (superValuesAndTypes.size() == 1) {
            AbstractDateTimeParameter.DateTimeValueAndTypeAndSearchType vT = superValuesAndTypes.get(0);
            if (!AbstractDateTimeParameter.DateTimeSearchType.EQ.equals((Object)vT.searchType) || !AbstractDateTimeParameter.DateTimeType.ZONED_DATE_TIME.equals((Object)vT.type)) {
                this.addError(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, parameters, "Not instant"));
            }
        }
    }

    @Override
    public List<AbstractDateTimeParameter.DateTimeValueAndTypeAndSearchType> getValuesAndTypes() {
        List<AbstractDateTimeParameter.DateTimeValueAndTypeAndSearchType> superValuesAndTypes = super.getValuesAndTypes();
        if (superValuesAndTypes.size() == 1) {
            AbstractDateTimeParameter.DateTimeValueAndTypeAndSearchType vT = superValuesAndTypes.get(0);
            if (AbstractDateTimeParameter.DateTimeSearchType.EQ.equals((Object)vT.searchType) && AbstractDateTimeParameter.DateTimeType.ZONED_DATE_TIME.equals((Object)vT.type)) {
                return Collections.singletonList(new AbstractDateTimeParameter.DateTimeValueAndTypeAndSearchType(vT.value, vT.type, AbstractDateTimeParameter.DateTimeSearchType.GE));
            }
        }
        return superValuesAndTypes;
    }

    @Override
    public boolean matches(Resource resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        throw new UnsupportedOperationException();
    }
}

