/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.exception;

import ca.uhn.fhir.parser.DataFormatException;
import dev.dsf.fhir.help.ResponseGenerator;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.Objects;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

@Provider
public class DataFormatExceptionHandler
implements ExceptionMapper<DataFormatException>,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(DataFormatExceptionHandler.class);
    private final ResponseGenerator responseGenerator;

    public DataFormatExceptionHandler(ResponseGenerator responseGenerator) {
        this.responseGenerator = responseGenerator;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.responseGenerator, "responseGenerator");
    }

    public Response toResponse(DataFormatException exception) {
        logger.warn("Error while parsing resource: {}, returning OperationOutcome with status 403 Forbidden", (Object)exception.getMessage());
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.STRUCTURE, "Unable to parse resource");
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)outcome).build();
    }
}

