/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.jdbc;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.fhir.dao.jdbc.AbstractPreparedStatementFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.UUID;
import org.hl7.fhir.r4.model.Resource;

class PreparedStatementFactoryDefault<R extends Resource>
extends AbstractPreparedStatementFactory<R> {
    PreparedStatementFactoryDefault(FhirContext fhirContext, Class<R> resourceType, String resourceTable, String resourceIdColumn, String resourceColumn) {
        super(fhirContext, resourceType, PreparedStatementFactoryDefault.createSql(resourceTable, resourceIdColumn, resourceColumn), PreparedStatementFactoryDefault.readByIdSql(resourceTable, resourceIdColumn, resourceColumn), PreparedStatementFactoryDefault.readByIdAndVersionSql(resourceTable, resourceIdColumn, resourceColumn), PreparedStatementFactoryDefault.updateNewRowSql(resourceTable, resourceIdColumn, resourceColumn), PreparedStatementFactoryDefault.updateSameRowSql(resourceTable, resourceIdColumn, resourceColumn));
    }

    private static String createSql(String resourceTable, String resourceIdColumn, String resourceColumn) {
        return "INSERT INTO " + resourceTable + " (" + resourceIdColumn + ", " + resourceColumn + ") VALUES (?, ?)";
    }

    private static String readByIdSql(String resourceTable, String resourceIdColumn, String resourceColumn) {
        return "SELECT deleted, version, " + resourceColumn + " FROM " + resourceTable + " WHERE " + resourceIdColumn + " = ? ORDER BY version DESC LIMIT 1";
    }

    private static String readByIdAndVersionSql(String resourceTable, String resourceIdColumn, String resourceColumn) {
        return "SELECT deleted, version," + resourceColumn + " FROM " + resourceTable + " WHERE " + resourceIdColumn + " = ? AND (version = ? OR version = ?) ORDER BY version DESC LIMIT 1";
    }

    private static String updateNewRowSql(String resourceTable, String resourceIdColumn, String resourceColumn) {
        return "INSERT INTO " + resourceTable + " (" + resourceIdColumn + ", version, " + resourceColumn + ") VALUES (?, ?, ?)";
    }

    private static String updateSameRowSql(String resourceTable, String resourceIdColumn, String resourceColumn) {
        return "UPDATE " + resourceTable + " SET " + resourceColumn + " = ? WHERE " + resourceIdColumn + " = ? AND version = ?";
    }

    @Override
    public void configureCreateStatement(PreparedStatement statement, R resource, UUID uuid) throws SQLException {
        statement.setObject(1, this.uuidToPgObject(uuid));
        statement.setObject(2, this.resourceToPgObject(resource));
    }

    @Override
    public void configureReadByIdStatement(PreparedStatement statement, UUID uuid) throws SQLException {
        statement.setObject(1, this.uuidToPgObject(uuid));
    }

    @Override
    public LocalDateTime getReadByIdDeleted(ResultSet result) throws SQLException {
        Timestamp deleted = result.getTimestamp(1);
        return deleted == null ? null : deleted.toLocalDateTime();
    }

    @Override
    public long getReadByIdVersion(ResultSet result) throws SQLException {
        return result.getLong(2);
    }

    @Override
    public R getReadByIdResource(ResultSet result) throws SQLException {
        String json = result.getString(3);
        return this.jsonToResource(json);
    }

    @Override
    public void configureReadByIdAndVersionStatement(PreparedStatement statement, UUID uuid, long version) throws SQLException {
        statement.setObject(1, this.uuidToPgObject(uuid));
        statement.setLong(2, version);
        statement.setLong(3, version - 1L);
    }

    @Override
    public LocalDateTime getReadByIdVersionDeleted(ResultSet result) throws SQLException {
        Timestamp deleted = result.getTimestamp(1);
        return deleted == null ? null : deleted.toLocalDateTime();
    }

    @Override
    public long getReadByIdVersionVersion(ResultSet result) throws SQLException {
        return result.getLong(2);
    }

    @Override
    public R getReadByIdAndVersionResource(ResultSet result) throws SQLException {
        String json = result.getString(3);
        return this.jsonToResource(json);
    }

    @Override
    public void configureUpdateNewRowSqlStatement(PreparedStatement statement, UUID uuid, long version, R resource) throws SQLException {
        statement.setObject(1, this.uuidToPgObject(uuid));
        statement.setLong(2, version);
        statement.setObject(3, this.resourceToPgObject(resource));
    }

    @Override
    public void configureUpdateSameRowSqlStatement(PreparedStatement statement, UUID uuid, long version, R resource) throws SQLException {
        statement.setObject(1, this.resourceToPgObject(resource));
        statement.setObject(2, this.uuidToPgObject(uuid));
        statement.setLong(3, version);
    }
}

