/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.jdbc;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.fhir.dao.NamingSystemDao;
import dev.dsf.fhir.dao.jdbc.AbstractResourceDaoJdbc;
import dev.dsf.fhir.search.filter.NamingSystemIdentityFilter;
import dev.dsf.fhir.search.parameters.NamingSystemDate;
import dev.dsf.fhir.search.parameters.NamingSystemName;
import dev.dsf.fhir.search.parameters.NamingSystemStatus;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.hl7.fhir.r4.model.NamingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingSystemDaoJdbc
extends AbstractResourceDaoJdbc<NamingSystem>
implements NamingSystemDao {
    private static final Logger logger = LoggerFactory.getLogger(NamingSystemDaoJdbc.class);

    public NamingSystemDaoJdbc(DataSource dataSource, DataSource permanentDeleteDataSource, FhirContext fhirContext) {
        super(dataSource, permanentDeleteDataSource, fhirContext, NamingSystem.class, "naming_systems", "naming_system", "naming_system_id", NamingSystemIdentityFilter::new, NamingSystemDaoJdbc.with(NamingSystemDate::new, NamingSystemName::new, NamingSystemStatus::new), NamingSystemDaoJdbc.with(new Supplier[0]));
    }

    @Override
    protected NamingSystem copy(NamingSystem resource) {
        return resource.copy();
    }

    @Override
    public Optional<NamingSystem> readByName(String name) throws SQLException {
        try (Connection connection = this.getDataSource().getConnection();){
            Optional<NamingSystem> optional = this.readByNameWithTransaction(connection, name);
            return optional;
        }
    }

    @Override
    public Optional<NamingSystem> readByNameWithTransaction(Connection connection, String name) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        if (name == null || name.isBlank()) {
            return Optional.empty();
        }
        try (PreparedStatement statement = connection.prepareStatement("SELECT naming_system FROM current_naming_systems WHERE naming_system->>'name' = ?");){
            Optional<NamingSystem> optional;
            block17: {
                ResultSet result;
                block15: {
                    Optional<NamingSystem> optional2;
                    block16: {
                        statement.setString(1, name);
                        logger.trace("Executing query '{}'", (Object)statement);
                        result = statement.executeQuery();
                        try {
                            if (!result.next()) break block15;
                            optional2 = Optional.of((NamingSystem)this.getResource(result, 1));
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (result == null) break block17;
                result.close();
            }
            return optional;
        }
    }

    @Override
    public boolean existsWithUniqueIdUriEntry(Connection connection, String uniqueIdValue) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        if (uniqueIdValue == null || uniqueIdValue.isBlank()) {
            return false;
        }
        String namingSystem = "{\"uniqueId\":[{\"type\":\"uri\",\"value\":\"" + uniqueIdValue + "\"}]}";
        try (PreparedStatement statement = connection.prepareStatement("SELECT count(*) FROM current_naming_systems WHERE naming_system->>'status' IN ('draft', 'active') AND naming_system @> ?::jsonb");){
            boolean bl;
            block13: {
                statement.setString(1, namingSystem);
                logger.trace("Executing query '{}'", (Object)statement);
                ResultSet result = statement.executeQuery();
                try {
                    boolean found = result.next() && result.getInt(1) > 0;
                    logger.debug("NamingSystem with uniqueId entry (uri/value({})) {}found", (Object)uniqueIdValue, (Object)(found ? "" : "not "));
                    bl = found;
                    if (result == null) break block13;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return bl;
        }
    }

    @Override
    public boolean existsWithUniqueIdUriEntryResolvable(Connection connection, String uniqueIdValue) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        if (uniqueIdValue == null || uniqueIdValue.isBlank()) {
            return false;
        }
        String namingSystem = "{\"uniqueId\":[{\"modifierExtension\":[{\"url\":\"http://dsf.dev/fhir/StructureDefinition/extension-check-logical-reference\",\"valueBoolean\":true}],\"value\":\"" + uniqueIdValue + "\"}]}";
        try (PreparedStatement statement = connection.prepareStatement("SELECT count(*) FROM current_naming_systems WHERE naming_system->>'status' IN ('draft', 'active') AND naming_system @> ?::jsonb");){
            boolean bl;
            block13: {
                statement.setString(1, namingSystem);
                logger.trace("Executing query '{}'", (Object)statement);
                ResultSet result = statement.executeQuery();
                try {
                    boolean found = result.next() && result.getInt(1) > 0;
                    logger.debug("NamingSystem with uniqueId entry (uri/value({})) and check-logical-reference true {}found", (Object)uniqueIdValue, (Object)(found ? "" : "not "));
                    bl = found;
                    if (result == null) break block13;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return bl;
        }
    }
}

