/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.command.AbstractCommandWithResource;
import dev.dsf.fhir.dao.command.AuthorizationHelper;
import dev.dsf.fhir.dao.command.Command;
import dev.dsf.fhir.dao.command.ValidationHelper;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.prefer.PreferReturnType;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.service.ResourceReference;
import dev.dsf.fhir.validation.SnapshotGenerator;
import jakarta.ws.rs.WebApplicationException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Map;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckReferencesCommand<R extends Resource, D extends ResourceDao<R>>
extends AbstractCommandWithResource<R, D>
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(CheckReferencesCommand.class);
    private final Bundle.HTTPVerb verb;

    public CheckReferencesCommand(int index, Identity identity, PreferReturnType returnType, Bundle bundle, Bundle.BundleEntryComponent entry, String serverBase, AuthorizationHelper authorizationHelper, R resource, Bundle.HTTPVerb verb, D dao, ExceptionHandler exceptionHandler, ParameterConverter parameterConverter, ResponseGenerator responseGenerator, ReferenceExtractor referenceExtractor, ReferenceResolver referenceResolver) {
        super(4, index, identity, returnType, bundle, entry, serverBase, authorizationHelper, resource, dao, exceptionHandler, parameterConverter, responseGenerator, referenceExtractor, referenceResolver);
        this.verb = verb;
    }

    @Override
    public void execute(Map<String, IdType> idTranslationTable, Connection connection, ValidationHelper validationHelper, SnapshotGenerator snapshotGenerator) throws SQLException, WebApplicationException {
        this.referencesHelper.checkReferences(idTranslationTable, connection, this::checkReferenceAfterUpdate);
    }

    private boolean checkReferenceAfterUpdate(ResourceReference ref) {
        if (this.resource instanceof Task && Bundle.HTTPVerb.PUT.equals((Object)this.verb)) {
            Task task = (Task)this.resource;
            if (EnumSet.of(Task.TaskStatus.COMPLETED, Task.TaskStatus.FAILED).contains(task.getStatus())) {
                ResourceReference.ReferenceType refType = ref.getType(this.serverBase);
                if ("Task.input".equals(ref.getLocation()) && ResourceReference.ReferenceType.LITERAL_EXTERNAL.equals((Object)refType)) {
                    logger.warn("Skipping check of {} reference '{}' at {} in resource with {}, version {}", new Object[]{refType, ref.getReference().getReference(), "Task.input", this.resource.getIdElement().getIdPart(), this.resource.getIdElement().getVersionIdPartAsLong() + 1L});
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String getResourceTypeName() {
        throw new UnsupportedOperationException();
    }
}

