/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.client;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.common.config.ProxyConfig;
import dev.dsf.fhir.client.ClientProvider;
import dev.dsf.fhir.client.FhirWebserviceClient;
import dev.dsf.fhir.client.FhirWebserviceClientJersey;
import dev.dsf.fhir.dao.EndpointDao;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.service.ReferenceCleaner;
import java.security.KeyStore;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ClientProviderImpl
implements ClientProvider,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ClientProviderImpl.class);
    private final KeyStore webserviceTrustStore;
    private final KeyStore webserviceKeyStore;
    private final char[] webserviceKeyStorePassword;
    private final int remoteReadTimeout;
    private final int remoteConnectTimeout;
    private ProxyConfig proxyConfig;
    private final boolean logRequests;
    private final FhirContext fhirContext;
    private final ReferenceCleaner referenceCleaner;
    private final EndpointDao endpointDao;
    private final ExceptionHandler exceptionHandler;

    public ClientProviderImpl(KeyStore webserviceTrustStore, KeyStore webserviceKeyStore, char[] webserviceKeyStorePassword, int remoteReadTimeout, int remoteConnectTimeout, ProxyConfig proxyConfig, boolean logRequests, FhirContext fhirContext, ReferenceCleaner referenceCleaner, EndpointDao endpointDao, ExceptionHandler exceptionHandler) {
        this.webserviceTrustStore = webserviceTrustStore;
        this.webserviceKeyStore = webserviceKeyStore;
        this.webserviceKeyStorePassword = webserviceKeyStorePassword;
        this.remoteReadTimeout = remoteReadTimeout;
        this.remoteConnectTimeout = remoteConnectTimeout;
        this.proxyConfig = proxyConfig;
        this.logRequests = logRequests;
        this.fhirContext = fhirContext;
        this.referenceCleaner = referenceCleaner;
        this.endpointDao = endpointDao;
        this.exceptionHandler = exceptionHandler;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.webserviceTrustStore, "webserviceTrustStore");
        Objects.requireNonNull(this.webserviceKeyStore, "webserviceKeyStore");
        Objects.requireNonNull(this.webserviceKeyStorePassword, "webserviceKeyStorePassword");
        Objects.requireNonNull(this.proxyConfig, "proxyConfig");
        Objects.requireNonNull(this.fhirContext, "fhirContext");
        Objects.requireNonNull(this.referenceCleaner, "referenceCleaner");
        Objects.requireNonNull(this.endpointDao, "endpointDao");
        Objects.requireNonNull(this.exceptionHandler, "exceptionHandler");
    }

    @Override
    public Optional<FhirWebserviceClient> getClient(String serverBase) {
        if (this.endpointExists(serverBase)) {
            String proxyUrl = this.proxyConfig.isEnabled(serverBase) ? this.proxyConfig.getUrl() : null;
            String proxyUsername = this.proxyConfig.isEnabled(serverBase) ? this.proxyConfig.getUsername() : null;
            char[] proxyPassword = this.proxyConfig.isEnabled(serverBase) ? this.proxyConfig.getPassword() : null;
            FhirWebserviceClientJersey client = new FhirWebserviceClientJersey(serverBase, this.webserviceTrustStore, this.webserviceKeyStore, this.webserviceKeyStorePassword, proxyUrl, proxyUsername, proxyPassword, this.remoteConnectTimeout, this.remoteReadTimeout, this.logRequests, null, this.fhirContext, this.referenceCleaner);
            return Optional.of(client);
        }
        return Optional.empty();
    }

    @Override
    public boolean endpointExists(String serverBase) {
        boolean endpointExists = this.exceptionHandler.handleSqlException(() -> this.endpointDao.existsActiveNotDeletedByAddress(serverBase));
        if (!endpointExists) {
            logger.warn("No active, not deleted Endpoint with address {} found", (Object)serverBase);
        }
        return endpointExists;
    }
}

