/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AbstractAuthorizationRule;
import dev.dsf.fhir.authorization.process.ProcessAuthorizationHelper;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.TaskDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.service.ResourceReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAuthorizationRule
extends AbstractAuthorizationRule<Task, TaskDao> {
    private static final Logger logger = LoggerFactory.getLogger(TaskAuthorizationRule.class);
    private static final String CODE_SYSTEM_BPMN_MESSAGE = "http://dsf.dev/fhir/CodeSystem/bpmn-message";
    private static final String CODE_SYSTEM_BPMN_MESSAGE_MESSAGE_NAME = "message-name";
    private static final String CODE_SYSTEM_BPMN_MESSAGE_BUSINESS_KEY = "business-key";
    private static final String INSTANTIATES_CANONICAL_PATTERN_STRING = "(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9]{1,63}|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$";
    private static final Pattern INSTANTIATES_CANONICAL_PATTERN = Pattern.compile("(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9]{1,63}|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$");
    private final ProcessAuthorizationHelper processAuthorizationHelper;

    public TaskAuthorizationRule(DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter, ProcessAuthorizationHelper processAuthorizationHelper) {
        super(Task.class, daoProvider, serverBase, referenceResolver, organizationProvider, readAccessHelper, parameterConverter);
        this.processAuthorizationHelper = processAuthorizationHelper;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Objects.requireNonNull(this.processAuthorizationHelper, "processAuthorizationHelper");
    }

    @Override
    public Optional<String> reasonCreateAllowed(Connection connection, Identity identity, Task newResource) {
        if (identity.hasDsfRole((DsfRole)FhirServerRole.CREATE)) {
            Optional<String> errors = this.newResourceOk(connection, identity, newResource);
            if (errors.isEmpty()) {
                if (this.taskAllowed(connection, identity, newResource)) {
                    logger.info("Create of Task authorized for identity '{}'", (Object)identity.getName());
                    return Optional.of("local or remote user, task.status draft or requested, task.requester current users organization, task.restriction.recipient local organization, process with instantiatesCanonical and message-name allowed for current user, task matches profile");
                }
                logger.warn("Create of Task unauthorized, process with instantiatesCanonical, message-name, requester or recipient not allowed for current user", (Object)identity.getName());
                return Optional.empty();
            }
            logger.warn("Create of Task unauthorized, " + errors.get());
            return Optional.empty();
        }
        logger.warn("Create of Task unauthorized for identity '{}', no role {}", (Object)this.getResourceTypeName(), (Object)FhirServerRole.CREATE);
        return Optional.empty();
    }

    private Optional<String> newResourceOk(Connection connection, Identity identity, Task newResource) {
        ArrayList<String> errors = new ArrayList<String>();
        if (newResource.hasStatus()) {
            if (!EnumSet.of(Task.TaskStatus.DRAFT, Task.TaskStatus.REQUESTED).contains(newResource.getStatus())) {
                errors.add("task.status not draft or requested");
            }
        } else {
            errors.add("task.status missing");
        }
        if (newResource.hasRequester()) {
            if (!this.isCurrentIdentityPartOfReferencedOrganization(connection, identity, "task.requester", newResource.getRequester())) {
                errors.add("task.requester user not part of referenced organization");
            }
        } else {
            errors.add("task.requester missing");
        }
        if (newResource.hasRestriction()) {
            if (newResource.getRestriction().getRecipient().size() == 1) {
                ResourceReference reference = new ResourceReference("task.restriction.recipient", newResource.getRestriction().getRecipientFirstRep(), new Class[]{Organization.class});
                Optional<Resource> recipient = this.referenceResolver.resolveReference(identity, reference, connection);
                if (recipient.isPresent()) {
                    if (recipient.get() instanceof Organization) {
                        if (!this.isLocalOrganization((Organization)recipient.get())) {
                            errors.add("task.restriction.recipient not local organization");
                        }
                    } else {
                        errors.add("task.restriction.recipient not a organization");
                    }
                } else {
                    errors.add("task.restriction.recipient could not be resolved");
                }
            } else {
                errors.add("task.restriction.recipient missing or more than one");
            }
        } else {
            errors.add("task.restriction missing");
        }
        if (newResource.hasInstantiatesCanonical()) {
            if (!INSTANTIATES_CANONICAL_PATTERN.matcher(newResource.getInstantiatesCanonical()).matches()) {
                errors.add("task.instantiatesCanonical not matching (?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9]{1,63}|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$ pattern");
            }
        } else {
            errors.add("task.instantiatesCanonical missing");
        }
        if (newResource.hasInput()) {
            if (this.getMessageNames(newResource).count() != 1L) {
                errors.add("task.input with system http://dsf.dev/fhir/CodeSystem/bpmn-message and code message-name with string value not empty missing or more than one");
            }
        } else {
            errors.add("task.input empty");
        }
        if (newResource.hasOutput()) {
            errors.add("task.output not empty");
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    private Stream<String> getMessageNames(Task newResource) {
        return newResource.getInput().stream().filter(Task.ParameterComponent::hasType).filter(i -> i.getType().hasCoding()).filter(i -> i.getType().getCoding().stream().filter(Coding::hasSystem).filter(Coding::hasCode).anyMatch(c -> CODE_SYSTEM_BPMN_MESSAGE.equals(c.getSystem()) && CODE_SYSTEM_BPMN_MESSAGE_MESSAGE_NAME.equals(c.getCode()))).filter(Task.ParameterComponent::hasValue).filter(i -> i.getValue() instanceof StringType).map(Task.ParameterComponent::getValue).map(v -> (StringType)v).map(t -> t.getValueAsString()).filter(s -> !s.isBlank());
    }

    private boolean taskAllowed(Connection connection, Identity requester, Task newResource) {
        Optional<Identity> recipientOpt = this.organizationProvider.getLocalOrganizationAsIdentity();
        if (recipientOpt.isEmpty()) {
            logger.warn("Local organization does not exist");
            return false;
        }
        Matcher matcher = INSTANTIATES_CANONICAL_PATTERN.matcher(newResource.getInstantiatesCanonical());
        if (matcher.matches()) {
            String processUrl = matcher.group("processUrl");
            String processVersion = matcher.group("processVersion");
            try {
                Optional<ActivityDefinition> activityDefinitionOpt = this.daoProvider.getActivityDefinitionDao().readByProcessUrlVersionAndStatusDraftOrActiveWithTransaction(connection, processUrl, processVersion);
                if (activityDefinitionOpt.isEmpty()) {
                    logger.warn("No ActivityDefinition with process-url '{}' and process-version '{}'", (Object)processUrl, (Object)processVersion);
                    return false;
                }
                ActivityDefinition activityDefinition = activityDefinitionOpt.get();
                Identity recipient = recipientOpt.get();
                List taskProfiles = newResource.getMeta().getProfile().stream().filter(PrimitiveType::hasValue).map(PrimitiveType::getValueAsString).collect(Collectors.toList());
                String messageName = this.getMessageNames(newResource).findFirst().get();
                boolean okForRecipient = this.processAuthorizationHelper.getRecipients(activityDefinition, processUrl, processVersion, messageName, taskProfiles).anyMatch(r -> r.isRecipientAuthorized(recipient, this.getAffiliations(connection, this.organizationProvider.getLocalOrganizationIdentifierValue())));
                boolean okForRequester = this.processAuthorizationHelper.getRequesters(activityDefinition, processUrl, processVersion, messageName, taskProfiles).anyMatch(r -> r.isRequesterAuthorized(requester, this.getAffiliations(connection, requester.getOrganizationIdentifierValue().orElse(null))));
                if (!okForRecipient) {
                    logger.warn("Task not allowed for recipient");
                }
                if (!okForRequester) {
                    logger.warn("Task not allowed for requester");
                }
                return okForRecipient && okForRequester;
            }
            catch (SQLException e) {
                logger.warn("Error while reading ActivityDefinitions", (Throwable)e);
                return false;
            }
        }
        logger.warn("task.instantiatesCanonical not matching {} pattern", (Object)INSTANTIATES_CANONICAL_PATTERN_STRING);
        return false;
    }

    @Override
    public Optional<String> reasonReadAllowed(Connection connection, Identity identity, Task existingResource) {
        String resourceId = existingResource.getIdElement().getIdPart();
        long resourceVersion = existingResource.getIdElement().getVersionIdPartAsLong();
        if (identity.hasDsfRole((DsfRole)FhirServerRole.READ)) {
            if (this.isCurrentIdentityPartOfReferencedOrganization(connection, identity, "task.requester", existingResource.getRequester())) {
                logger.info("Read of Task authorized, task.requester reference could be resolved and user '{}' is part of referenced organization", (Object)identity.getName());
                return Optional.of("task.requester resolved and user part of referenced organization");
            }
            if (identity.isLocalIdentity() && this.isCurrentIdentityPartOfReferencedOrganization(connection, identity, "task.restriction.recipient", existingResource.getRestriction().getRecipientFirstRep())) {
                logger.info("Read of Task authorized, task.restriction.recipient reference could be resolved and user '{}' is part of referenced organization", (Object)identity.getName());
                return Optional.of("task.restriction.recipient resolved and local user part of referenced organization");
            }
            logger.warn("Read of Task unauthorized, task.requester or task.restriction.recipient references could not be resolved or user '{}' not part of referenced organizations", (Object)identity.getName());
            return Optional.empty();
        }
        logger.warn("Read of Task/{}/_history/{} unauthorized for identity '{}', no role {}", new Object[]{resourceId.toString(), resourceVersion, identity.getName(), FhirServerRole.READ});
        return Optional.empty();
    }

    @Override
    public Optional<String> reasonUpdateAllowed(Connection connection, Identity identity, Task oldResource, Task newResource) {
        String resourceId = oldResource.getIdElement().getIdPart();
        long resourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
        if (identity.hasDsfRole((DsfRole)FhirServerRole.UPDATE)) {
            if (Task.TaskStatus.DRAFT.equals((Object)oldResource.getStatus()) && this.isCurrentIdentityPartOfReferencedOrganization(connection, identity, "task.requester", oldResource.getRequester())) {
                Optional<String> errors = this.newResourceOk(connection, identity, newResource);
                if (errors.isEmpty()) {
                    logger.info("Update of Task authorized for local or remote user '{}'", (Object)identity.getName());
                    return Optional.of("local or remote user, task.status draft or requested, task.requester current users organization, task.restriction.recipient local organization");
                }
                logger.warn("Create of Task unauthorized, " + errors.get());
                return Optional.empty();
            }
            if (identity.isLocalIdentity() && EnumSet.of(Task.TaskStatus.REQUESTED, Task.TaskStatus.INPROGRESS).contains(oldResource.getStatus()) && this.isCurrentIdentityPartOfReferencedOrganization(connection, identity, "task.restriction.recipient", oldResource.getRestriction().getRecipientFirstRep())) {
                Optional<String> same = this.reasonNotSame(oldResource, newResource);
                if (same.isEmpty()) {
                    if (Task.TaskStatus.REQUESTED.equals((Object)oldResource.getStatus()) && Task.TaskStatus.INPROGRESS.equals((Object)newResource.getStatus())) {
                        if (!newResource.hasOutput()) {
                            logger.info("local user (user is part of task.restriction.recipient organization), task.status inprogress, properties task.instantiatesCanonical, task.requester, task.restriction, task.input not changed");
                            return Optional.of("local user (user part of task.restriction.recipient), task.status inprogress, properties task.instantiatesCanonical, task.requester, task.restriction, task.input not changed");
                        }
                        logger.warn("Update of Task unauthorized, task.output not expected");
                        return Optional.empty();
                    }
                    if (Task.TaskStatus.INPROGRESS.equals((Object)oldResource.getStatus()) && (Task.TaskStatus.COMPLETED.equals((Object)newResource.getStatus()) || Task.TaskStatus.FAILED.equals((Object)newResource.getStatus()))) {
                        logger.info("local user (user is part of task.restriction.recipient organization), task.status completed or failed, properties task.instantiatesCanonical, task.requester, task.restriction, task.input not changed");
                        return Optional.of("local user (user part of task.restriction.recipient), task.status completed or failed, properties task.instantiatesCanonical, task.requester, task.restriction, task.input not changed");
                    }
                    logger.warn("Update of Task unauthorized, task.status change {} -> {} not allowed", (Object)oldResource.getStatus(), (Object)newResource.getStatus());
                    return Optional.empty();
                }
                logger.warn("Update of Task unauthorized, task properties {} changed", (Object)same.get());
                return Optional.empty();
            }
            logger.warn("Update of Task unauthorized, expected task.status draft and current user part of task.requester or task.status requester or inprogress and current local user part of task.restriction.recipient");
            return Optional.empty();
        }
        logger.warn("Update of Task/{}/_history/{} unauthorized for identity '{}', no role {}", new Object[]{resourceId.toString(), resourceVersion, identity.getName(), FhirServerRole.UPDATE});
        return Optional.empty();
    }

    private Optional<String> reasonNotSame(Task oldResource, Task newResource) {
        ArrayList<Object> errors = new ArrayList<Object>();
        if (!oldResource.getRequester().equalsDeep((Base)newResource.getRequester())) {
            errors.add("task.requester");
        }
        if (!oldResource.getRestriction().equalsDeep((Base)newResource.getRestriction())) {
            errors.add("task.restriction");
        }
        if (!oldResource.getInstantiatesCanonical().equals(newResource.getInstantiatesCanonical())) {
            errors.add("task.instantiatesCanonical");
        }
        List oldResourceInputs = oldResource.getInput();
        List<Task.ParameterComponent> newResourceInputs = newResource.getInput();
        if (Task.TaskStatus.REQUESTED.equals((Object)oldResource.getStatus()) && oldResourceInputs.stream().noneMatch(this.isBusinessKey()) && Task.TaskStatus.INPROGRESS.equals((Object)newResource.getStatus()) && newResourceInputs.stream().anyMatch(this.isBusinessKey())) {
            newResourceInputs = newResourceInputs.stream().filter(this.isBusinessKey().negate()).toList();
        }
        if (oldResourceInputs.size() != newResourceInputs.size()) {
            errors.add("task.input");
        } else {
            for (int i = 0; i < oldResourceInputs.size(); ++i) {
                if (((Task.ParameterComponent)oldResourceInputs.get(i)).equalsDeep((Base)newResourceInputs.get(i))) continue;
                errors.add("task.input[" + i + "]");
                break;
            }
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        logger.debug("Old Task: {}", (Object)FhirContext.forR4().newJsonParser().setStripVersionsFromReferences(Boolean.valueOf(false)).encodeResourceToString((IBaseResource)oldResource));
        logger.debug("New Task: {}", (Object)FhirContext.forR4().newJsonParser().setStripVersionsFromReferences(Boolean.valueOf(false)).encodeResourceToString((IBaseResource)newResource));
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    private Predicate<Task.ParameterComponent> isBusinessKey() {
        return i -> i.getType().getCoding().stream().anyMatch(c -> CODE_SYSTEM_BPMN_MESSAGE.equals(c.getSystem()) && CODE_SYSTEM_BPMN_MESSAGE_BUSINESS_KEY.equals(c.getCode()));
    }

    @Override
    public Optional<String> reasonDeleteAllowed(Connection connection, Identity identity, Task oldResource) {
        String resourceId = oldResource.getIdElement().getIdPart();
        long resourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
        if (identity.hasDsfRole((DsfRole)FhirServerRole.DELETE)) {
            if (Task.TaskStatus.DRAFT.equals((Object)oldResource.getStatus()) && this.isCurrentIdentityPartOfReferencedOrganization(connection, identity, "task.requester", oldResource.getRequester())) {
                logger.info("Delete of Task authorized for user '{}', task.status draft, task.requester resolved and user part of referenced organization", (Object)identity.getName());
                return Optional.of("task.status draft, task.requester resolved and user part of referenced organization");
            }
            if (identity.isLocalIdentity() && Task.TaskStatus.DRAFT.equals((Object)oldResource.getStatus()) && this.isCurrentIdentityPartOfReferencedOrganization(connection, identity, "task.restriction.recipient", oldResource.getRestriction().getRecipientFirstRep())) {
                logger.info("Delete of Task authorized for local user '{}', task.status draft, task.restriction.recipient resolved and user part of referenced organization", (Object)identity.getName());
                return Optional.of("local user, task.status draft, task.restriction.recipient resolved and user part of referenced organization");
            }
            logger.warn("Delete of Task unauthorized, task.status not draft, task.requester not current user or task.restriction.recipient not local user");
            return Optional.empty();
        }
        logger.warn("Delete of Task/{}/_history/{} unauthorized for identity '{}', no role {}", new Object[]{resourceId.toString(), resourceVersion, identity.getName(), FhirServerRole.DELETE});
        return Optional.empty();
    }
}

