/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AbstractAuthorizationRule;
import dev.dsf.fhir.authorization.AuthorizationRule;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.ReadAccessDao;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.service.ReferenceResolver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractMetaTagAuthorizationRule<R extends Resource, D extends ResourceDao<R>>
extends AbstractAuthorizationRule<R, D>
implements AuthorizationRule<R>,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetaTagAuthorizationRule.class);
    private final ReadAccessDao readAccessDao;

    public AbstractMetaTagAuthorizationRule(Class<R> resourceType, DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter) {
        super(resourceType, daoProvider, serverBase, referenceResolver, organizationProvider, readAccessHelper, parameterConverter);
        this.readAccessDao = daoProvider.getReadAccessDao();
    }

    protected final boolean hasValidReadAccessTag(Connection connection, Resource resource) {
        return this.readAccessHelper.isValid(resource, organizationIdentifier -> this.organizationWithIdentifierExists(connection, (Identifier)organizationIdentifier), role -> this.roleExists(connection, (Coding)role));
    }

    @Override
    public final Optional<String> reasonCreateAllowed(Connection connection, Identity identity, R newResource) {
        if (identity.isLocalIdentity() && identity.hasDsfRole((DsfRole)FhirServerRole.CREATE)) {
            Optional<String> errors = this.newResourceOkForCreate(connection, identity, newResource);
            if (errors.isEmpty()) {
                if (!this.resourceExists(connection, newResource)) {
                    logger.info("Create of {} authorized for identity '{}'", (Object)this.getResourceTypeName(), (Object)identity.getName());
                    return Optional.of("Identity is local identity and has role " + FhirServerRole.CREATE);
                }
                logger.warn("Create of {} unauthorized, unique resource already exists", (Object)this.getResourceTypeName());
                return Optional.empty();
            }
            logger.warn("Create of {} unauthorized, {}", (Object)this.getResourceTypeName(), (Object)errors.get());
            return Optional.empty();
        }
        logger.warn("Create of {} unauthorized for identity '{}', not a local identity or no role {}", (Object)this.getResourceTypeName(), (Object)FhirServerRole.CREATE);
        return Optional.empty();
    }

    protected abstract boolean resourceExists(Connection var1, R var2);

    protected abstract Optional<String> newResourceOkForCreate(Connection var1, Identity var2, R var3);

    @Override
    public final Optional<String> reasonReadAllowed(Connection connection, Identity identity, R existingResource) {
        UUID resourceId = this.parameterConverter.toUuid(this.getResourceTypeName(), existingResource.getIdElement().getIdPart());
        long resourceVersion = existingResource.getIdElement().getVersionIdPartAsLong();
        if (identity.hasDsfRole((DsfRole)FhirServerRole.READ)) {
            try {
                UUID organizationId = this.parameterConverter.toUuid("Organization", identity.getOrganization().getIdElement().getIdPart());
                List<String> accessTypes = this.readAccessDao.getAccessTypes(connection, resourceId, resourceVersion, identity.isLocalIdentity(), organizationId);
                if (accessTypes.isEmpty()) {
                    logger.warn("Read of {}/{}/_history/{} unauthorized for identity '{}', no matching access tags", new Object[]{this.getResourceTypeName(), resourceId.toString(), resourceVersion, identity.getName(), FhirServerRole.READ});
                    return Optional.empty();
                }
                String tags = accessTypes.stream().collect(Collectors.joining(", ", "{", "}"));
                logger.info("Read of {}/{}/_history/{} authorized for identity '{}', matching access {} {}", new Object[]{this.getResourceTypeName(), resourceId.toString(), resourceVersion, identity.getName(), accessTypes.size() == 1 ? "tag" : "tags", tags});
                return Optional.of("Identity has role " + FhirServerRole.READ + ", matching access " + (accessTypes.size() == 1 ? "tag" : "tags") + " " + tags);
            }
            catch (SQLException e) {
                logger.warn("Error while checking read access", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        logger.warn("Read of {}/{}/_history/{} unauthorized for identity '{}', no role {}", new Object[]{this.getResourceTypeName(), resourceId.toString(), resourceVersion, identity.getName(), FhirServerRole.READ});
        return Optional.empty();
    }

    protected abstract Optional<String> newResourceOkForUpdate(Connection var1, Identity var2, R var3);

    @Override
    public final Optional<String> reasonUpdateAllowed(Connection connection, Identity identity, R oldResource, R newResource) {
        String resourceId = oldResource.getIdElement().getIdPart();
        long resourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
        if (identity.isLocalIdentity() && identity.hasDsfRole((DsfRole)FhirServerRole.UPDATE)) {
            Optional<String> errors = this.newResourceOkForUpdate(connection, identity, newResource);
            if (errors.isEmpty()) {
                if (this.modificationsOk(connection, oldResource, newResource)) {
                    logger.info("Update of {}/{}/_history/{} authorized for identity '{}'", new Object[]{this.getResourceTypeName(), resourceId.toString(), resourceVersion, identity.getName()});
                    return Optional.of("Identity is local identity and has role " + FhirServerRole.UPDATE);
                }
                logger.warn("Update of {}/{}/_history/{} unauthorized, modification not allowed", new Object[]{this.getResourceTypeName(), resourceId.toString(), resourceVersion});
                return Optional.empty();
            }
            logger.warn("Update of {}/{}/_history/{} unauthorized, {}", new Object[]{this.getResourceTypeName(), resourceId.toString(), resourceVersion, errors.get()});
            return Optional.empty();
        }
        logger.warn("Update of {}/{}/_history/{} unauthorized for identity '{}', not a local identity or no role {}", new Object[]{this.getResourceTypeName(), resourceId.toString(), resourceVersion, identity.getName(), FhirServerRole.DELETE});
        return Optional.empty();
    }

    protected abstract boolean modificationsOk(Connection var1, R var2, R var3);

    @Override
    public final Optional<String> reasonDeleteAllowed(Connection connection, Identity identity, R oldResource) {
        String resourceId = oldResource.getIdElement().getIdPart();
        long resourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
        if (identity.isLocalIdentity() && identity.hasDsfRole((DsfRole)FhirServerRole.DELETE)) {
            logger.info("Delete of {}/{}/_history/{} authorized for identity '{}'", new Object[]{this.getResourceTypeName(), resourceId, resourceVersion, identity.getName()});
            return Optional.of("Identity is local identity and has role " + FhirServerRole.DELETE);
        }
        logger.warn("Delete of {}/{}/_history/{} unauthorized for identity '{}', not a local identity or no role {}", new Object[]{this.getResourceTypeName(), resourceId, resourceVersion, identity.getName(), FhirServerRole.DELETE});
        return Optional.empty();
    }
}

