/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AuthorizationRule;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.CodeSystemDao;
import dev.dsf.fhir.dao.OrganizationDao;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQuery;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.service.ResourceReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractAuthorizationRule<R extends Resource, D extends ResourceDao<R>>
implements AuthorizationRule<R>,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAuthorizationRule.class);
    protected static final String ORGANIZATION_IDENTIFIER_SYSTEM = "http://dsf.dev/sid/organization-identifier";
    protected final Class<R> resourceType;
    protected final DaoProvider daoProvider;
    protected final String serverBase;
    protected final ReferenceResolver referenceResolver;
    protected final OrganizationProvider organizationProvider;
    protected final ReadAccessHelper readAccessHelper;
    protected final ParameterConverter parameterConverter;

    public AbstractAuthorizationRule(Class<R> resourceType, DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter) {
        this.resourceType = resourceType;
        this.daoProvider = daoProvider;
        this.serverBase = serverBase;
        this.referenceResolver = referenceResolver;
        this.organizationProvider = organizationProvider;
        this.readAccessHelper = readAccessHelper;
        this.parameterConverter = parameterConverter;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.resourceType, "resourceType");
        Objects.requireNonNull(this.daoProvider, "daoProvider");
        Objects.requireNonNull(this.serverBase, "serverBase");
        Objects.requireNonNull(this.referenceResolver, "referenceResolver");
        Objects.requireNonNull(this.organizationProvider, "organizationProvider");
        Objects.requireNonNull(this.readAccessHelper, "readAccessHelper");
        Objects.requireNonNull(this.parameterConverter, "parameterConverter");
    }

    @Override
    public Class<R> getResourceType() {
        return this.resourceType;
    }

    protected String getResourceTypeName() {
        return this.getResourceType().getAnnotation(ResourceDef.class).name();
    }

    protected final D getDao() {
        return (D)this.daoProvider.getDao(this.resourceType).orElseThrow();
    }

    @Override
    public final Optional<String> reasonCreateAllowed(Identity identity, R newResource) {
        Optional<String> optional;
        block8: {
            Connection connection = this.daoProvider.newReadOnlyAutoCommitTransaction();
            try {
                optional = this.reasonCreateAllowed(connection, identity, newResource);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.warn("Error while accessing database", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            connection.close();
        }
        return optional;
    }

    @Override
    public final Optional<String> reasonReadAllowed(Identity identity, R existingResource) {
        Optional<String> optional;
        block8: {
            Connection connection = this.daoProvider.newReadOnlyAutoCommitTransaction();
            try {
                optional = this.reasonReadAllowed(connection, identity, existingResource);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.warn("Error while accessing database", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            connection.close();
        }
        return optional;
    }

    protected List<OrganizationAffiliation> getAffiliations(Connection connection, String organizationIdentifierValue) {
        if (organizationIdentifierValue == null) {
            return Collections.emptyList();
        }
        try {
            return this.daoProvider.getOrganizationAffiliationDao().readActiveNotDeletedByMemberOrganizationIdentifierIncludingOrganizationIdentifiersWithTransaction(connection, organizationIdentifierValue);
        }
        catch (SQLException e) {
            logger.warn("Error while accessing database", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public final Optional<String> reasonUpdateAllowed(Identity identity, R oldResource, R newResource) {
        Optional<String> optional;
        block8: {
            Connection connection = this.daoProvider.newReadOnlyAutoCommitTransaction();
            try {
                optional = this.reasonUpdateAllowed(connection, identity, oldResource, newResource);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.warn("Error while accessing database", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            connection.close();
        }
        return optional;
    }

    @Override
    public final Optional<String> reasonDeleteAllowed(Identity identity, R oldResource) {
        Optional<String> optional;
        block8: {
            Connection connection = this.daoProvider.newReadOnlyAutoCommitTransaction();
            try {
                optional = this.reasonDeleteAllowed(connection, identity, oldResource);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.warn("Error while accessing database", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            connection.close();
        }
        return optional;
    }

    protected final boolean organizationWithIdentifierExists(Connection connection, Identifier organizationIdentifier) {
        String iSystem = organizationIdentifier.getSystem();
        String iValue = organizationIdentifier.getValue();
        Map<String, List<String>> queryParameters = Map.of("identifier", Collections.singletonList(iSystem + "|" + iValue));
        OrganizationDao dao = this.daoProvider.getOrganizationDao();
        SearchQuery query = dao.createSearchQueryWithoutUserFilter(0, 0).configureParameters(queryParameters);
        List<SearchQueryParameterError> uQp = query.getUnsupportedQueryParameters(queryParameters);
        if (!uQp.isEmpty()) {
            logger.warn("Unsupported query parameters {} while searching for Organization", uQp);
            return false;
        }
        try {
            PartialResult result = dao.searchWithTransaction(connection, query);
            return result.getTotal() >= 1;
        }
        catch (SQLException e) {
            logger.warn("Error while searching for Organization with identifier", (Throwable)e);
            return false;
        }
    }

    protected final boolean roleExists(Connection connection, Coding coding) {
        String cSystem = coding.getSystem();
        String cVersion = coding.getVersion();
        String cCode = coding.getCode();
        Map<String, List<String>> queryParameters = Map.of("url", Collections.singletonList(cSystem + (String)(coding.hasVersion() ? "|" + cVersion : "")));
        CodeSystemDao dao = this.daoProvider.getCodeSystemDao();
        SearchQuery query = dao.createSearchQueryWithoutUserFilter(1, 1).configureParameters(queryParameters);
        List<SearchQueryParameterError> uQp = query.getUnsupportedQueryParameters(queryParameters);
        if (!uQp.isEmpty()) {
            logger.warn("Unsupported query parameters {} while searching for CodeSystem", uQp);
            return false;
        }
        try {
            PartialResult result = dao.searchWithTransaction(connection, query);
            return result.getTotal() >= 1 && this.hasCode((CodeSystem)result.getPartialResult().get(0), cCode);
        }
        catch (SQLException e) {
            logger.warn("Error while searching for Organization with identifier", (Throwable)e);
            return false;
        }
    }

    private boolean hasCode(CodeSystem codeSystem, String cCode) {
        return codeSystem.getConcept().stream().filter(CodeSystem.ConceptDefinitionComponent::hasCode).map(CodeSystem.ConceptDefinitionComponent::getCode).anyMatch(c -> c.equals(cCode));
    }

    protected final boolean isCurrentIdentityPartOfReferencedOrganizations(Connection connection, Identity identity, String referenceLocation, Collection<? extends Reference> references) {
        return this.isCurrentIdentityPartOfReferencedOrganizations(connection, identity, referenceLocation, references.stream());
    }

    protected final boolean isCurrentIdentityPartOfReferencedOrganizations(Connection connection, Identity identity, String referenceLocation, Stream<? extends Reference> references) {
        return references.anyMatch(r -> this.isCurrentIdentityPartOfReferencedOrganization(connection, identity, referenceLocation, (Reference)r));
    }

    protected final boolean isCurrentIdentityPartOfReferencedOrganization(Connection connection, Identity identity, String referenceLocation, Reference reference) {
        if (reference == null) {
            logger.warn("Null reference while checking if user part of referenced organization");
            return false;
        }
        ResourceReference resReference = new ResourceReference(referenceLocation, reference, new Class[]{Organization.class});
        ResourceReference.ReferenceType type = resReference.getType(this.serverBase);
        if (!EnumSet.of(ResourceReference.ReferenceType.LITERAL_INTERNAL, ResourceReference.ReferenceType.LOGICAL).contains(type)) {
            logger.warn("Reference of type {} not supported while checking if user part of referenced organization", (Object)type);
            return false;
        }
        Optional<Resource> resource = this.referenceResolver.resolveReference(identity, resReference, connection);
        if (resource.isPresent() && resource.get() instanceof Organization) {
            boolean sameOrganization = identity.getOrganization().getIdElement().getIdPart().equals(resource.get().getIdElement().getIdPart());
            if (!sameOrganization) {
                logger.warn("Current user not part of organization {} while checking if user part of referenced organization", (Object)resource.get().getIdElement().getValue());
            }
            return sameOrganization;
        }
        logger.warn("Reference to organization could not be resolved while checking if user part of referenced organization");
        return false;
    }

    protected final boolean isLocalOrganization(Organization organization) {
        if (organization == null) {
            return false;
        }
        if (!organization.hasIdElement()) {
            return false;
        }
        return this.organizationProvider.getLocalOrganization().map(localOrg -> localOrg.getIdElement().equals((Object)organization.getIdElement())).orElse(false);
    }

    @SafeVarargs
    protected final Optional<ResourceReference> createIfLiteralInternalOrLogicalReference(String referenceLocation, Reference reference, Class<? extends Resource> ... referenceTypes) {
        ResourceReference r = new ResourceReference(referenceLocation, reference, (Class[])referenceTypes);
        ResourceReference.ReferenceType type = r.getType(this.serverBase);
        if (EnumSet.of(ResourceReference.ReferenceType.LITERAL_INTERNAL, ResourceReference.ReferenceType.LOGICAL).contains(type)) {
            return Optional.of(r);
        }
        return Optional.empty();
    }

    protected final Optional<Resource> resolveReference(Connection connection, Identity identity, Optional<ResourceReference> reference) {
        return reference.flatMap(ref -> this.referenceResolver.resolveReference(identity, (ResourceReference)ref, connection));
    }

    @Override
    public Optional<String> reasonPermanentDeleteAllowed(Identity identity, R oldResource) {
        Optional<String> optional;
        block8: {
            Connection connection = this.daoProvider.newReadOnlyAutoCommitTransaction();
            try {
                optional = this.reasonPermanentDeleteAllowed(connection, identity, oldResource);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.warn("Error while accessing database", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            connection.close();
        }
        return optional;
    }

    @Override
    public final Optional<String> reasonSearchAllowed(Identity identity) {
        if (identity.hasDsfRole((DsfRole)FhirServerRole.SEARCH)) {
            logger.info("Search of {} authorized for identity '{}'", (Object)this.getResourceTypeName(), (Object)identity.getName());
            return Optional.of("Identity has role " + FhirServerRole.SEARCH);
        }
        logger.warn("Search of {} unauthorized for identity '{}', no role {}", new Object[]{this.getResourceTypeName(), identity.getName(), FhirServerRole.SEARCH});
        return Optional.empty();
    }

    @Override
    public final Optional<String> reasonHistoryAllowed(Identity identity) {
        if (identity.hasDsfRole((DsfRole)FhirServerRole.HISTORY)) {
            logger.info("History of {} authorized for identity '{}'", (Object)this.getResourceTypeName(), (Object)identity.getName());
            return Optional.of("Identity has role " + FhirServerRole.HISTORY);
        }
        logger.warn("History of {} unauthorized for identity '{}', no role {}", new Object[]{this.getResourceTypeName(), identity.getName(), FhirServerRole.HISTORY});
        return Optional.empty();
    }

    @Override
    public Optional<String> reasonPermanentDeleteAllowed(Connection connection, Identity identity, R oldResource) {
        String resourceId = oldResource.getIdElement().getIdPart();
        long resourceVersion = oldResource.getIdElement().getVersionIdPartAsLong();
        if (identity.isLocalIdentity() && identity.hasDsfRole((DsfRole)FhirServerRole.PERMANENT_DELETE) && this.reasonDeleteAllowed(connection, identity, oldResource).isPresent()) {
            logger.info("Permanent delete of {}/{}/_history/{} authorized for identity '{}'", new Object[]{this.getResourceTypeName(), resourceId, resourceVersion, identity.getName()});
            return Optional.of("Identity is local identity and has role " + FhirServerRole.PERMANENT_DELETE);
        }
        logger.warn("Permanent delete of {}/{}/_history/{} unauthorized for identity '{}', not a local identity or no role {}", new Object[]{this.getResourceTypeName(), resourceId, resourceVersion, identity.getName(), FhirServerRole.PERMANENT_DELETE});
        return Optional.empty();
    }
}

