/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir;

import dev.dsf.common.jetty.JettyServer;
import dev.dsf.common.jetty.Log4jInitializer;
import dev.dsf.fhir.config.FhirDbMigratorConfig;
import dev.dsf.fhir.config.FhirHttpsJettyConfig;
import dev.dsf.tools.db.DbMigrator;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public final class FhirJettyServerHttps {
    private FhirJettyServerHttps() {
    }

    public static void main(String[] args) {
        try (AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{FhirDbMigratorConfig.class});){
            DbMigrator migrator = (DbMigrator)context.getBean(DbMigrator.class);
            DbMigrator.retryOnConnectException((int)3, () -> ((DbMigrator)migrator).migrate());
        }
        context = new AnnotationConfigApplicationContext(new Class[]{FhirHttpsJettyConfig.class});
        try {
            JettyServer server = (JettyServer)context.getBean(JettyServer.class);
            server.start();
        }
        finally {
            context.close();
        }
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Log4jInitializer.initializeLog4j();
    }
}

