/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir;

import dev.dsf.common.jetty.JettyConfig;
import dev.dsf.common.jetty.JettyServer;
import dev.dsf.fhir.FhirDbMigratorConfig;
import dev.dsf.tools.db.DbMigrator;
import dev.dsf.tools.db.DbMigratorConfig;
import java.util.stream.Stream;
import org.eclipse.jetty.websocket.jakarta.client.JakartaWebSocketShutdownContainer;
import org.eclipse.jetty.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.glassfish.jersey.servlet.init.JerseyServletContainerInitializer;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.web.SpringServletContainerInitializer;

public final class FhirServer
extends JettyServer {
    public FhirServer(JettyConfig jettyConfig) {
        super("fhir-server", jettyConfig, Stream.of(JakartaWebSocketShutdownContainer.class, JakartaWebSocketServletContainerInitializer.class, JerseyServletContainerInitializer.class, SpringServletContainerInitializer.class));
    }

    public void beforeStart() {
        try (AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{FhirDbMigratorConfig.class});){
            DbMigratorConfig config = (DbMigratorConfig)context.getBean(DbMigratorConfig.class);
            DbMigrator dbMigrator = new DbMigrator(config);
            DbMigrator.retryOnConnectException((int)3, () -> ((DbMigrator)dbMigrator).migrate());
        }
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

