/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir;

import dev.dsf.common.documentation.Documentation;
import dev.dsf.tools.db.DbMigratorConfig;
import dev.dsf.tools.docker.secrets.DockerSecretsPropertySourceFactory;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@PropertySource(value={"file:conf/config.properties"}, encoding="UTF-8", ignoreResourceNotFound=true)
public class FhirDbMigratorConfig
implements DbMigratorConfig {
    private static final String DB_LIQUIBASE_USER = "db.liquibase_user";
    private static final String DB_SERVER_USERS_GROUP = "db.server_users_group";
    private static final String DB_SERVER_USER = "db.server_user";
    private static final String DB_SERVER_USER_PASSWORD = "db.server_user_password";
    private static final String DB_SERVER_PERMANENT_DELETE_USERS_GROUP = "db.server_permanent_delete_users_group";
    private static final String DB_SERVER_PERMANENT_DELETE_USER = "db.server_permanent_delete_user";
    private static final String DB_SERVER_PERMANENT_DELETE_USER_PASSWORD = "db.server_permanent_delete_user_password";
    @Value(value="${dev.dsf.fhir.db.url}")
    private String dbUrl;
    @Documentation(description="The user name to access the database from the DSF FHIR server to execute database migrations")
    @Value(value="${dev.dsf.fhir.db.liquibase.username:liquibase_user}")
    private String dbLiquibaseUsername;
    @Documentation(required=true, description="The password to access the database from the DSF FHIR server to execute database migrations", recommendation="Use docker secret file to configure by using *${env_variable}_FILE*", example="/run/secrets/db_liquibase.password")
    @Value(value="${dev.dsf.fhir.db.liquibase.password}")
    private char[] dbLiquibasePassword;
    @Documentation(description="The name of the user group to access the database from the DSF FHIR server")
    @Value(value="${dev.dsf.fhir.db.user.group:fhir_users}")
    private String dbUsersGroup;
    @Value(value="${dev.dsf.fhir.db.user.username:fhir_server_user}")
    private String dbUsername;
    @Value(value="${dev.dsf.fhir.db.user.password}")
    private char[] dbPassword;
    @Documentation(description="The name of the user group to access the database from the DSF FHIR server for permanent deletes")
    @Value(value="${dev.dsf.fhir.db.user.permanent.delete.group:fhir_permanent_delete_users}")
    private String dbPermanentDeleteUsersGroup;
    @Value(value="${dev.dsf.fhir.db.user.permanent.delete.username:fhir_server_permanent_delete_user}")
    private String dbPermanentDeleteUsername;
    @Value(value="${dev.dsf.fhir.db.user.permanent.delete.password}")
    private char[] dbPermanentDeletePassword;

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer(ConfigurableEnvironment environment) {
        new DockerSecretsPropertySourceFactory(environment).readDockerSecretsAndAddPropertiesToEnvironment();
        return new PropertySourcesPlaceholderConfigurer();
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbLiquibaseUsername() {
        return this.dbLiquibaseUsername;
    }

    public char[] getDbLiquibasePassword() {
        return this.dbLiquibasePassword;
    }

    public Map<String, String> getChangeLogParameters() {
        return Map.of(DB_LIQUIBASE_USER, this.dbLiquibaseUsername, DB_SERVER_USERS_GROUP, this.dbUsersGroup, DB_SERVER_USER, this.dbUsername, DB_SERVER_USER_PASSWORD, this.toString(this.dbPassword), DB_SERVER_PERMANENT_DELETE_USERS_GROUP, this.dbPermanentDeleteUsersGroup, DB_SERVER_PERMANENT_DELETE_USER, this.dbPermanentDeleteUsername, DB_SERVER_PERMANENT_DELETE_USER_PASSWORD, this.toString(this.dbPermanentDeletePassword));
    }

    private String toString(char[] password) {
        return password == null ? null : String.valueOf(password);
    }
}

