/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;

public class ResourceReference {
    private static final Pattern TEMP_ID_PATTERN = Pattern.compile("urn:uuid:.+");
    private static final Pattern ID_PATTERN = Pattern.compile("(?<base>(http|https):\\/\\/([A-Za-z0-9\\-\\\\\\.\\:\\%\\$]*\\/)+)?(?<resource>Account|ActivityDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|EffectEvidenceSynthesis|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|InsurancePlan|Invoice|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProduct|MedicinalProductAuthorization|MedicinalProductContraindication|MedicinalProductIndication|MedicinalProductIngredient|MedicinalProductInteraction|MedicinalProductManufactured|MedicinalProductPackaged|MedicinalProductPharmaceutical|MedicinalProductUndesirableEffect|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionOrder|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RelatedPerson|RequestGroup|ResearchDefinition|ResearchElementDefinition|ResearchStudy|ResearchSubject|RiskAssessment|RiskEvidenceSynthesis|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription)\\/(?<id>[A-Za-z0-9\\-\\.]{1,64})(?:\\/_history\\/(?<version>[A-Za-z0-9\\-\\.]{1,64}))?");
    private static final Pattern CONDITIONAL_REF_PATTERN = Pattern.compile("(?<resource>Account|ActivityDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|EffectEvidenceSynthesis|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|InsurancePlan|Invoice|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProduct|MedicinalProductAuthorization|MedicinalProductContraindication|MedicinalProductIndication|MedicinalProductIngredient|MedicinalProductInteraction|MedicinalProductManufactured|MedicinalProductPackaged|MedicinalProductPharmaceutical|MedicinalProductUndesirableEffect|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionOrder|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RelatedPerson|RequestGroup|ResearchDefinition|ResearchElementDefinition|ResearchStudy|ResearchSubject|RiskAssessment|RiskEvidenceSynthesis|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription)(?<query>\\?.*)");
    private final String location;
    private final Reference reference;
    private final RelatedArtifact relatedArtifact;
    private final Attachment attachment;
    private final List<Class<? extends Resource>> referenceTypes = new ArrayList<Class<? extends Resource>>();

    @SafeVarargs
    public ResourceReference(String location, Reference reference, Class<? extends Resource> ... referenceTypes) {
        this(location, reference, null, null, Arrays.asList(referenceTypes));
    }

    public ResourceReference(String location, RelatedArtifact relatedArtifact) {
        this(location, null, relatedArtifact, null, Collections.emptyList());
    }

    public ResourceReference(String location, Attachment attachment) {
        this(location, null, null, attachment, Collections.emptyList());
    }

    private ResourceReference(String location, Reference reference, RelatedArtifact relatedArtifact, Attachment attachment, Collection<Class<? extends Resource>> referenceTypes) {
        this.location = location;
        if (reference == null && relatedArtifact == null && attachment == null) {
            throw new IllegalArgumentException("Either reference, relatedArtifact or attachment expected");
        }
        this.reference = reference;
        this.relatedArtifact = relatedArtifact;
        this.attachment = attachment;
        if (referenceTypes != null) {
            this.referenceTypes.addAll(referenceTypes);
        }
    }

    public boolean hasReference() {
        return this.reference != null;
    }

    public Reference getReference() {
        return this.reference;
    }

    public boolean hasRelatedArtifact() {
        return this.relatedArtifact != null;
    }

    public RelatedArtifact getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public boolean hasAttachment() {
        return this.attachment != null;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public String getValue() {
        if (this.hasReference()) {
            return this.reference.getReference();
        }
        if (this.hasRelatedArtifact()) {
            return this.relatedArtifact.getUrl();
        }
        if (this.hasAttachment()) {
            return this.attachment.getUrl();
        }
        throw new IllegalArgumentException("reference, related artefact or attachment not set");
    }

    public List<Class<? extends Resource>> getReferenceTypes() {
        return Collections.unmodifiableList(this.referenceTypes);
    }

    public boolean supportsType(Class<? extends Resource> type) {
        return this.referenceTypes.isEmpty() || this.referenceTypes.contains(type);
    }

    public ReferenceType getType(String localServerBase) {
        Objects.requireNonNull(localServerBase, "localServerBase");
        if (this.relatedArtifact != null) {
            if (this.relatedArtifact.hasUrl()) {
                Matcher tempIdRefMatcher = TEMP_ID_PATTERN.matcher(this.relatedArtifact.getUrl());
                if (tempIdRefMatcher.matches()) {
                    return ReferenceType.RELATED_ARTEFACT_TEMPORARY_URL;
                }
                Matcher idRefMatcher = ID_PATTERN.matcher(this.relatedArtifact.getUrl());
                if (idRefMatcher.matches()) {
                    IdType id = new IdType(this.relatedArtifact.getUrl());
                    if (!id.isAbsolute() || localServerBase.equals(id.getBaseUrl())) {
                        return ReferenceType.RELATED_ARTEFACT_LITERAL_INTERNAL_URL;
                    }
                    return ReferenceType.RELATED_ARTEFACT_LITERAL_EXTERNAL_URL;
                }
                Matcher conditionalRefMatcher = CONDITIONAL_REF_PATTERN.matcher(this.relatedArtifact.getUrl());
                if (conditionalRefMatcher.matches()) {
                    return ReferenceType.RELATED_ARTEFACT_CONDITIONAL_URL;
                }
            }
            return ReferenceType.RELATED_ARTEFACT_UNKNOWN_URL;
        }
        if (this.attachment != null) {
            if (this.attachment.hasUrl()) {
                Matcher tempIdRefMatcher = TEMP_ID_PATTERN.matcher(this.attachment.getUrl());
                if (tempIdRefMatcher.matches()) {
                    return ReferenceType.ATTACHMENT_TEMPORARY_URL;
                }
                Matcher idRefMatcher = ID_PATTERN.matcher(this.attachment.getUrl());
                if (idRefMatcher.matches()) {
                    IdType id = new IdType(this.attachment.getUrl());
                    if (!id.isAbsolute() || localServerBase.equals(id.getBaseUrl())) {
                        return ReferenceType.ATTACHMENT_LITERAL_INTERNAL_URL;
                    }
                    return ReferenceType.ATTACHMENT_LITERAL_EXTERNAL_URL;
                }
                Matcher conditionalRefMatcher = CONDITIONAL_REF_PATTERN.matcher(this.attachment.getUrl());
                if (conditionalRefMatcher.matches()) {
                    return ReferenceType.ATTACHMENT_CONDITIONAL_URL;
                }
            }
            return ReferenceType.ATTACHMENT_UNKNOWN_URL;
        }
        if (this.reference != null) {
            if (this.reference.hasReference()) {
                Matcher tempIdRefMatcher = TEMP_ID_PATTERN.matcher(this.reference.getReference());
                if (tempIdRefMatcher.matches()) {
                    return ReferenceType.TEMPORARY;
                }
                Matcher idRefMatcher = ID_PATTERN.matcher(this.reference.getReference());
                if (idRefMatcher.matches()) {
                    IdType id = new IdType(this.reference.getReference());
                    if (!id.isAbsolute() || localServerBase.equals(id.getBaseUrl())) {
                        return ReferenceType.LITERAL_INTERNAL;
                    }
                    return ReferenceType.LITERAL_EXTERNAL;
                }
                Matcher conditionalRefMatcher = CONDITIONAL_REF_PATTERN.matcher(this.reference.getReference());
                if (conditionalRefMatcher.matches()) {
                    return ReferenceType.CONDITIONAL;
                }
            } else if (this.reference.hasType() && this.reference.hasIdentifier() && this.reference.getIdentifier().hasSystem() && this.reference.getIdentifier().hasValue()) {
                return ReferenceType.LOGICAL;
            }
            return ReferenceType.UNKNOWN;
        }
        throw new IllegalStateException("Either reference or relatedArtifact expected");
    }

    public String getLocation() {
        return this.location;
    }

    public String getServerBase(String localServerBase) {
        Objects.requireNonNull(localServerBase, "localServerBase");
        if (EnumSet.of(ReferenceType.LITERAL_EXTERNAL, ReferenceType.RELATED_ARTEFACT_LITERAL_EXTERNAL_URL, ReferenceType.ATTACHMENT_LITERAL_EXTERNAL_URL).contains((Object)this.getType(localServerBase))) {
            return new IdType(this.getValue()).getBaseUrl();
        }
        return "";
    }

    public static enum ReferenceType {
        TEMPORARY,
        LITERAL_INTERNAL,
        LITERAL_EXTERNAL,
        LOGICAL,
        CONDITIONAL,
        UNKNOWN,
        RELATED_ARTEFACT_TEMPORARY_URL,
        RELATED_ARTEFACT_CONDITIONAL_URL,
        RELATED_ARTEFACT_LITERAL_INTERNAL_URL,
        RELATED_ARTEFACT_LITERAL_EXTERNAL_URL,
        RELATED_ARTEFACT_UNKNOWN_URL,
        ATTACHMENT_TEMPORARY_URL,
        ATTACHMENT_CONDITIONAL_URL,
        ATTACHMENT_LITERAL_INTERNAL_URL,
        ATTACHMENT_LITERAL_EXTERNAL_URL,
        ATTACHMENT_UNKNOWN_URL;

    }
}

