/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import dev.dsf.fhir.adapter.AbstractAdapter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;

@Provider
@Consumes(value={"application/fhir+xml", "application/xml+fhir", "application/xml", "text/xml", "application/fhir+json", "application/json+fhir", "application/json"})
@Produces(value={"application/fhir+xml", "application/xml+fhir", "application/xml", "text/xml", "application/fhir+json", "application/json+fhir", "application/json"})
public class FhirAdapter
extends AbstractAdapter
implements MessageBodyReader<BaseResource>,
MessageBodyWriter<BaseResource> {
    private final FhirContext fhirContext;

    public FhirAdapter(FhirContext fhirContext) {
        this.fhirContext = fhirContext;
    }

    private IParser getParser(MediaType mediaType) {
        return switch (mediaType.getType() + "/" + mediaType.getSubtype()) {
            case "application/fhir+xml", "application/xml+fhir", "application/xml", "text/xml" -> this.getParser(mediaType, () -> ((FhirContext)this.fhirContext).newXmlParser());
            case "application/fhir+json", "application/json+fhir", "application/json" -> this.getParser(mediaType, () -> ((FhirContext)this.fhirContext).newJsonParser());
            default -> throw new IllegalStateException("MediaType " + mediaType.toString() + " not supported");
        };
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type != null && BaseResource.class.isAssignableFrom(type);
    }

    public void writeTo(BaseResource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.getParser(mediaType).encodeResourceToWriter((IBaseResource)t, (Writer)new OutputStreamWriter(entityStream));
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type != null && BaseResource.class.isAssignableFrom(type);
    }

    public BaseResource readFrom(Class<BaseResource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.fixResource((BaseResource)this.getParser(mediaType).parseResource(type, (Reader)new InputStreamReader(entityStream)));
    }

    private BaseResource fixResource(BaseResource resource) {
        if (resource instanceof Bundle) {
            Bundle b = (Bundle)resource;
            return this.fixBundle(b);
        }
        if (resource instanceof Binary) {
            Binary b = (Binary)resource;
            return this.fixBinary(b);
        }
        return resource;
    }

    private BaseResource fixBundle(Bundle resource) {
        if (resource.hasIdElement() && resource.getIdElement().hasIdPart() && !resource.getIdElement().hasVersionIdPart() && resource.hasMeta() && resource.getMeta().hasVersionId()) {
            IdType fixedId = new IdType(resource.getResourceType().name(), resource.getIdElement().getIdPart(), resource.getMeta().getVersionId());
            resource.setIdElement(fixedId);
        }
        resource.getEntry().stream().filter(e -> e.hasResource() && e.getResource() instanceof Bundle).map(e -> (Bundle)e.getResource()).forEach(this::fixResource);
        return resource;
    }

    private BaseResource fixBinary(Binary resource) {
        if (resource.hasIdElement() && resource.getIdElement().hasIdPart() && !resource.getIdElement().hasVersionIdPart() && resource.hasMeta() && resource.getMeta().hasVersionId()) {
            IdType fixedId = new IdType(resource.getResourceType().name(), resource.getIdElement().getIdPart(), resource.getMeta().getVersionId());
            resource.setIdElement(fixedId);
        }
        return resource;
    }
}

