/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import ca.uhn.fhir.parser.IParser;
import jakarta.ws.rs.core.MediaType;
import java.util.Set;
import java.util.function.Supplier;

public abstract class AbstractAdapter {
    public static final String PRETTY = "pretty";
    public static final String SUMMARY = "summary";

    protected IParser getParser(MediaType mediaType, Supplier<IParser> parserFactor) {
        IParser p = parserFactor.get();
        p.setStripVersionsFromReferences(Boolean.valueOf(false));
        p.setOverrideResourceIdWithBundleEntryFullUrl(Boolean.valueOf(false));
        if (mediaType != null) {
            if ("true".equals(mediaType.getParameters().getOrDefault(PRETTY, "false"))) {
                p.setPrettyPrint(true);
            }
            switch (mediaType.getParameters().getOrDefault(SUMMARY, "false")) {
                case "true": {
                    p.setSummaryMode(true);
                    break;
                }
                case "text": {
                    p.setEncodeElements(Set.of("*.text", "*.id", "*.meta", "*.(mandatory)"));
                    break;
                }
                case "data": {
                    p.setSuppressNarratives(true);
                }
            }
        }
        return p;
    }
}

