/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.service;

import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ResourceReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.ClaimResponse;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.ObservationDefinition;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.SpecimenDefinition;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceExtractorImpl
implements ReferenceExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceExtractorImpl.class);

    @SafeVarargs
    private Function<Reference, ResourceReference> toResourceReferenceFromReference(String referenceLocation, Class<? extends Resource> ... referenceTypes) {
        return ref -> new ResourceReference(referenceLocation, (Reference)ref, referenceTypes);
    }

    private Function<RelatedArtifact, ResourceReference> toResourceReferenceFromRelatedArtifact(String relatedArtifactLocation) {
        return rel -> new ResourceReference(relatedArtifactLocation, (RelatedArtifact)rel);
    }

    private Function<Attachment, ResourceReference> toResourceReferenceFromAttachment(String attachmentLocation) {
        return rel -> new ResourceReference(attachmentLocation, (Attachment)rel);
    }

    @SafeVarargs
    private <R extends Resource> Stream<ResourceReference> getReference(R resource, Predicate<R> hasReference, Function<R, Reference> getReference, String referenceLocation, Class<? extends DomainResource> ... referenceTypes) {
        return hasReference.test(resource) ? Stream.of(getReference.apply(resource)).map(this.toResourceReferenceFromReference(referenceLocation, referenceTypes)) : Stream.empty();
    }

    @SafeVarargs
    private <R extends Resource> Stream<ResourceReference> getReferences(R resource, Predicate<R> hasReference, Function<R, List<Reference>> getReference, String referenceLocation, Class<? extends Resource> ... referenceTypes) {
        return hasReference.test(resource) ? Stream.of(getReference.apply(resource)).flatMap(Collection::stream).map(this.toResourceReferenceFromReference(referenceLocation, referenceTypes)) : Stream.empty();
    }

    @SafeVarargs
    private <R extends Resource, E extends BackboneElement> Stream<ResourceReference> getBackboneElementsReference(R resource, Predicate<R> hasBackboneElements, Function<R, List<E>> getBackboneElements, Predicate<E> hasReference, Function<E, Reference> getReference, String referenceLocation, Class<? extends Resource> ... referenceTypes) {
        if (hasBackboneElements.test(resource)) {
            List<E> backboneElements = getBackboneElements.apply(resource);
            return backboneElements.stream().map(e -> this.getReference(e, hasReference, getReference, referenceLocation, referenceTypes)).flatMap(Function.identity());
        }
        return Stream.empty();
    }

    private <R extends Resource, E extends BackboneElement> Stream<ResourceReference> getBackboneElementsAttachment(R resource, Predicate<R> hasBackboneElements, Function<R, List<E>> getBackboneElements, Predicate<E> hasAttachment, Function<E, Attachment> getAttachment, String attachmentLocation) {
        if (hasBackboneElements.test(resource)) {
            List<E> backboneElements = getBackboneElements.apply(resource);
            return backboneElements.stream().map(e -> this.getAttachment(e, hasAttachment, getAttachment, attachmentLocation)).flatMap(Function.identity());
        }
        return Stream.empty();
    }

    @SafeVarargs
    private <E extends BackboneElement> Stream<ResourceReference> getReference(E backboneElement, Predicate<E> hasReference, Function<E, Reference> getReference, String referenceLocation, Class<? extends Resource> ... referenceTypes) {
        return hasReference.test(backboneElement) ? Stream.of(getReference.apply(backboneElement)).map(this.toResourceReferenceFromReference(referenceLocation, referenceTypes)) : Stream.empty();
    }

    private <E extends BackboneElement> Stream<ResourceReference> getAttachment(E backboneElement, Predicate<E> hasAttachment, Function<E, Attachment> getAttachment, String attachmentLocation) {
        return hasAttachment.test(backboneElement) ? Stream.of(getAttachment.apply(backboneElement)).map(this.toResourceReferenceFromAttachment(attachmentLocation)) : Stream.empty();
    }

    @SafeVarargs
    private <R extends DomainResource, E extends BackboneElement> Stream<ResourceReference> getBackboneElementReferences(R resource, Predicate<R> hasBackboneElement, Function<R, E> getBackboneElement, Predicate<E> hasReference, Function<E, List<Reference>> getReference, String referenceLocation, Class<? extends DomainResource> ... referenceTypes) {
        if (hasBackboneElement.test(resource)) {
            BackboneElement backboneElement = (BackboneElement)getBackboneElement.apply(resource);
            return this.getReferences(backboneElement, hasReference, getReference, referenceLocation, referenceTypes);
        }
        return Stream.empty();
    }

    @SafeVarargs
    private <R extends DomainResource, E extends BackboneElement> Stream<ResourceReference> getBackboneElementReference(R resource, Predicate<R> hasBackboneElement, Function<R, E> getBackboneElement, Predicate<E> hasReference, Function<E, Reference> getReference, String referenceLocation, Class<? extends DomainResource> ... referenceTypes) {
        if (hasBackboneElement.test(resource)) {
            BackboneElement backboneElement = (BackboneElement)getBackboneElement.apply(resource);
            return this.getReference(backboneElement, hasReference, getReference, referenceLocation, referenceTypes);
        }
        return Stream.empty();
    }

    @SafeVarargs
    private <R extends DomainResource, E1 extends BackboneElement, E2 extends BackboneElement> Stream<ResourceReference> getBackboneElements2Reference(R resource, Predicate<R> hasBackboneElements1, Function<R, List<E1>> getBackboneElements1, Predicate<E1> hasBackboneElements2, Function<E1, List<E2>> getBackboneElements2, Predicate<E2> hasReference, Function<E2, Reference> getReference, String referenceLocation, Class<? extends DomainResource> ... referenceTypes) {
        if (hasBackboneElements1.test(resource)) {
            List<E1> backboneElements1 = getBackboneElements1.apply(resource);
            return backboneElements1.stream().filter(e1 -> hasBackboneElements2.test(e1)).flatMap(e1 -> ((List)getBackboneElements2.apply(e1)).stream()).map(e2 -> this.getReference(e2, hasReference, getReference, referenceLocation, referenceTypes)).flatMap(Function.identity());
        }
        return Stream.empty();
    }

    @SafeVarargs
    private <R extends DomainResource, E1 extends BackboneElement, E2 extends BackboneElement, E3 extends BackboneElement, E4 extends BackboneElement> Stream<ResourceReference> getBackboneElements4Reference(R resource, Predicate<R> hasBackboneElements1, Function<R, List<E1>> getBackboneElements1, Predicate<E1> hasBackboneElements2, Function<E1, List<E2>> getBackboneElements2, Predicate<E2> hasBackboneElements3, Function<E2, List<E3>> getBackboneElements3, Predicate<E3> hasBackboneElements4, Function<E3, List<E4>> getBackboneElements4, Predicate<E4> hasReference, Function<E4, Reference> getReference, String referenceLocation, Class<? extends DomainResource> ... referenceTypes) {
        if (hasBackboneElements1.test(resource)) {
            List<E1> backboneElements1 = getBackboneElements1.apply(resource);
            return backboneElements1.stream().filter(e1 -> hasBackboneElements2.test(e1)).flatMap(e1 -> ((List)getBackboneElements2.apply(e1)).stream()).filter(e2 -> hasBackboneElements3.test(e2)).flatMap(e2 -> ((List)getBackboneElements3.apply(e2)).stream()).filter(e3 -> hasBackboneElements4.test(e3)).flatMap(e3 -> ((List)getBackboneElements4.apply(e3)).stream()).map(e4 -> this.getReference(e4, hasReference, getReference, referenceLocation, referenceTypes)).flatMap(Function.identity());
        }
        return Stream.empty();
    }

    @SafeVarargs
    private <E extends BackboneElement> Stream<ResourceReference> getReferences(E backboneElement, Predicate<E> hasReference, Function<E, List<Reference>> getReference, String referenceLocation, Class<? extends DomainResource> ... referenceTypes) {
        return hasReference.test(backboneElement) ? Stream.of(getReference.apply(backboneElement)).flatMap(Collection::stream).map(this.toResourceReferenceFromReference(referenceLocation, referenceTypes)) : Stream.empty();
    }

    private Stream<ResourceReference> getExtensionReferences(DomainResource resource) {
        Stream<ResourceReference> extensions = resource.getExtension().stream().filter(e -> e.getValue() instanceof Reference).map(e -> (Reference)e.getValue()).map(this.toResourceReferenceFromReference(resource.getResourceType().name() + ".extension", new Class[0]));
        Stream extensionExtensions = resource.getExtension().stream().flatMap(e -> this.getExtensionReferences(resource.getResourceType().name() + ".extension", (Extension)e));
        return Stream.concat(extensions, extensionExtensions);
    }

    private Stream<ResourceReference> getExtensionReferences(String baseElementName, BackboneElement resource) {
        Stream<ResourceReference> extensions = resource.getExtension().stream().filter(e -> e.getValue() instanceof Reference).map(e -> (Reference)e.getValue()).map(this.toResourceReferenceFromReference(baseElementName + ".extension", new Class[0]));
        Stream extensionExtensions = resource.getExtension().stream().flatMap(e -> this.getExtensionReferences(baseElementName + ".extension", (Extension)e));
        return Stream.concat(extensions, extensionExtensions);
    }

    private Stream<ResourceReference> getExtensionReferences(String baseElementName, Extension resource) {
        Stream<ResourceReference> extensions = resource.getExtension().stream().filter(e -> e.getValue() instanceof Reference).map(e -> (Reference)e.getValue()).map(this.toResourceReferenceFromReference(baseElementName + ".extension", new Class[0]));
        Stream extensionExtensions = resource.getExtension().stream().flatMap(e -> this.getExtensionReferences(baseElementName + ".extension", (Extension)e));
        return Stream.concat(extensions, extensionExtensions);
    }

    private <R extends Resource> Stream<ResourceReference> getRelatedArtifacts(R resource, Predicate<R> hasRelatedArtifact, Function<R, List<RelatedArtifact>> getRelatedArtifact, String relatedArtifactLocation) {
        return hasRelatedArtifact.test(resource) ? Stream.of(getRelatedArtifact.apply(resource)).flatMap(Collection::stream).map(this.toResourceReferenceFromRelatedArtifact(relatedArtifactLocation)) : Stream.empty();
    }

    private <R extends Resource> Stream<ResourceReference> getAttachments(R resource, Predicate<R> hasAttachment, Function<R, List<Attachment>> getAttachment, String attachmentLocation) {
        return hasAttachment.test(resource) ? Stream.of(getAttachment.apply(resource)).flatMap(Collection::stream).map(this.toResourceReferenceFromAttachment(attachmentLocation)) : Stream.empty();
    }

    @SafeVarargs
    private Stream<ResourceReference> concat(Stream<ResourceReference> ... streams) {
        if (streams.length == 0) {
            return Stream.empty();
        }
        if (streams.length == 1) {
            return streams[0];
        }
        if (streams.length == 2) {
            return Stream.concat(streams[0], streams[1]);
        }
        return Arrays.stream(streams).flatMap(Function.identity());
    }

    @Override
    public Stream<ResourceReference> getReferences(Resource resource) {
        if (resource == null) {
            return Stream.empty();
        }
        if (resource instanceof ActivityDefinition) {
            ActivityDefinition ad = (ActivityDefinition)resource;
            return this.getReferences(ad);
        }
        if (resource instanceof Binary) {
            Binary b = (Binary)resource;
            return this.getReferences(b);
        }
        if (resource instanceof CodeSystem) {
            CodeSystem cs = (CodeSystem)resource;
            return this.getReferences(cs);
        }
        if (resource instanceof DocumentReference) {
            DocumentReference dr = (DocumentReference)resource;
            return this.getReferences(dr);
        }
        if (resource instanceof Endpoint) {
            Endpoint e = (Endpoint)resource;
            return this.getReferences(e);
        }
        if (resource instanceof Group) {
            Group g = (Group)resource;
            return this.getReferences(g);
        }
        if (resource instanceof HealthcareService) {
            HealthcareService hs = (HealthcareService)resource;
            return this.getReferences(hs);
        }
        if (resource instanceof Library) {
            Library l = (Library)resource;
            return this.getReferences(l);
        }
        if (resource instanceof Location) {
            Location l = (Location)resource;
            return this.getReferences(l);
        }
        if (resource instanceof Measure) {
            Measure m = (Measure)resource;
            return this.getReferences(m);
        }
        if (resource instanceof MeasureReport) {
            MeasureReport mr = (MeasureReport)resource;
            return this.getReferences(mr);
        }
        if (resource instanceof NamingSystem) {
            NamingSystem ns = (NamingSystem)resource;
            return this.getReferences(ns);
        }
        if (resource instanceof OperationOutcome) {
            OperationOutcome oo = (OperationOutcome)resource;
            return this.getReferences(oo);
        }
        if (resource instanceof Organization) {
            Organization o = (Organization)resource;
            return this.getReferences(o);
        }
        if (resource instanceof OrganizationAffiliation) {
            OrganizationAffiliation oa = (OrganizationAffiliation)resource;
            return this.getReferences(oa);
        }
        if (resource instanceof Patient) {
            Patient p = (Patient)resource;
            return this.getReferences(p);
        }
        if (resource instanceof Practitioner) {
            Practitioner p = (Practitioner)resource;
            return this.getReferences(p);
        }
        if (resource instanceof PractitionerRole) {
            PractitionerRole pr = (PractitionerRole)resource;
            return this.getReferences(pr);
        }
        if (resource instanceof Provenance) {
            Provenance p = (Provenance)resource;
            return this.getReferences(p);
        }
        if (resource instanceof Questionnaire) {
            Questionnaire q = (Questionnaire)resource;
            return this.getReferences(q);
        }
        if (resource instanceof QuestionnaireResponse) {
            QuestionnaireResponse qr = (QuestionnaireResponse)resource;
            return this.getReferences(qr);
        }
        if (resource instanceof ResearchStudy) {
            ResearchStudy rs = (ResearchStudy)resource;
            return this.getReferences(rs);
        }
        if (resource instanceof StructureDefinition) {
            StructureDefinition sd = (StructureDefinition)resource;
            return this.getReferences(sd);
        }
        if (resource instanceof Subscription) {
            Subscription s = (Subscription)resource;
            return this.getReferences(s);
        }
        if (resource instanceof Task) {
            Task t = (Task)resource;
            return this.getReferences(t);
        }
        if (resource instanceof ValueSet) {
            ValueSet vs = (ValueSet)resource;
            return this.getReferences(vs);
        }
        if (resource instanceof DomainResource) {
            logger.debug("DomainResource of type {} not supported, returning extension references only", (Object)resource.getClass().getName());
            return this.getExtensionReferences((DomainResource)resource);
        }
        logger.debug("Resource of type {} not supported, returning no references", (Object)resource.getClass().getName());
        return Stream.empty();
    }

    @Override
    public Stream<ResourceReference> getReferences(ActivityDefinition resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> subjectReference = this.getReference(resource, ActivityDefinition::hasSubjectReference, ActivityDefinition::getSubjectReference, "ActivityDefinition.subjectReference", Group.class);
        Stream<ResourceReference> location = this.getReference(resource, ActivityDefinition::hasLocation, ActivityDefinition::getLocation, "ActivityDefinition.location", Location.class);
        Stream<ResourceReference> productReference = this.getReference((BackboneElement)resource, ActivityDefinition::hasProductReference, ActivityDefinition::getProductReference, "ActivityDefinition.productReference", (Class<? extends Resource>)Medication.class, (Class<? extends Resource>)Substance.class);
        Stream<ResourceReference> specimenRequirement = this.getReferences(resource, ActivityDefinition::hasSpecimenRequirement, ActivityDefinition::getSpecimenRequirement, "ActivityDefinition.specimenRequirement", SpecimenDefinition.class);
        Stream<ResourceReference> observationRequirement = this.getReferences(resource, ActivityDefinition::hasObservationRequirement, ActivityDefinition::getObservationRequirement, "ActivityDefinition.observationRequirement", ObservationDefinition.class);
        Stream<ResourceReference> observationResultRequirement = this.getReferences(resource, ActivityDefinition::hasObservationResultRequirement, ActivityDefinition::getObservationResultRequirement, "ActivityDefinition.observationResultRequirement", ObservationDefinition.class);
        Stream<ResourceReference> relatedArtifacts = this.getRelatedArtifacts(resource, ActivityDefinition::hasRelatedArtifact, ActivityDefinition::getRelatedArtifact, "ActivityDefinition.relatedArtifact");
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(subjectReference, location, productReference, specimenRequirement, observationRequirement, observationResultRequirement, relatedArtifacts, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(Binary resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> securityContext = this.getReference(resource, Binary::hasSecurityContext, Binary::getSecurityContext, "Binary.securityContext", new Class[0]);
        return securityContext;
    }

    @Override
    public Stream<ResourceReference> getReferences(CodeSystem resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return extensionReferences;
    }

    @Override
    public Stream<ResourceReference> getReferences(DocumentReference resource) {
        if (resource == null) {
            return null;
        }
        Stream<ResourceReference> subject = this.getReference((BackboneElement)resource, DocumentReference::hasSubject, DocumentReference::getSubject, "DocumentReference.subject", (Class<? extends Resource>)Patient.class, (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)Group.class, (Class<? extends Resource>)Device.class);
        Stream<ResourceReference> author = this.getReferences((BackboneElement)resource, DocumentReference::hasAuthor, DocumentReference::getAuthor, "DocumentReference.author", (Class<? extends DomainResource>)Practitioner.class, (Class<? extends DomainResource>)PractitionerRole.class, (Class<? extends DomainResource>)Organization.class, (Class<? extends DomainResource>)Device.class, (Class<? extends DomainResource>)Patient.class, (Class<? extends DomainResource>)RelatedPerson.class);
        Stream<ResourceReference> authenticator = this.getReference((BackboneElement)resource, DocumentReference::hasAuthenticator, DocumentReference::getAuthenticator, "DocumentReference.authenticator", (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class, (Class<? extends Resource>)Organization.class);
        Stream<ResourceReference> custodian = this.getReference(resource, DocumentReference::hasCustodian, DocumentReference::getCustodian, "DocumentReference.custodian", Organization.class);
        Stream<ResourceReference> relatesToTarget = this.getBackboneElementsReference(resource, DocumentReference::hasRelatesTo, DocumentReference::getRelatesTo, DocumentReference.DocumentReferenceRelatesToComponent::hasTarget, DocumentReference.DocumentReferenceRelatesToComponent::getTarget, "DocumentReference.relatesTo.target", DocumentReference.class);
        Stream<ResourceReference> contextEncounters = this.getBackboneElementReferences((DomainResource)resource, DocumentReference::hasContent, DocumentReference::getContext, DocumentReference.DocumentReferenceContextComponent::hasEncounter, DocumentReference.DocumentReferenceContextComponent::getEncounter, "DocumentReference.context.encounter", (Class<? extends DomainResource>)Encounter.class, (Class<? extends DomainResource>)EpisodeOfCare.class);
        Stream<ResourceReference> contextSourcePatientInfo = this.getBackboneElementReference(resource, DocumentReference::hasContent, DocumentReference::getContext, DocumentReference.DocumentReferenceContextComponent::hasSourcePatientInfo, DocumentReference.DocumentReferenceContextComponent::getSourcePatientInfo, "DocumentReference.context.sourcePatientInfo", Patient.class);
        Stream<ResourceReference> contextRelated = this.getBackboneElementReferences(resource, DocumentReference::hasContent, DocumentReference::getContext, DocumentReference.DocumentReferenceContextComponent::hasRelated, DocumentReference.DocumentReferenceContextComponent::getRelated, "DocumentReference.context.related", new Class[0]);
        Stream<ResourceReference> contentAttachment = this.getBackboneElementsAttachment(resource, DocumentReference::hasContent, DocumentReference::getContent, DocumentReference.DocumentReferenceContentComponent::hasAttachment, DocumentReference.DocumentReferenceContentComponent::getAttachment, "DocumentReference.content.attachment");
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(subject, author, authenticator, custodian, relatesToTarget, contextEncounters, contextSourcePatientInfo, contextRelated, contentAttachment, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(Endpoint resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> managingOrganization = this.getReference(resource, Endpoint::hasManagingOrganization, Endpoint::getManagingOrganization, "Endpoint.managingOrganization", Organization.class);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(managingOrganization, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(Group resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> managingEntity = this.getReference((BackboneElement)resource, Group::hasManagingEntity, Group::getManagingEntity, "Group.managingEntity", (Class<? extends Resource>)Organization.class, (Class<? extends Resource>)RelatedPerson.class, (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class);
        Stream<ResourceReference> memberEntities = this.getBackboneElementsReference((Resource)resource, Group::hasMember, Group::getMember, Group.GroupMemberComponent::hasEntity, Group.GroupMemberComponent::getEntity, "Group.member.entity", (Class<? extends Resource>)Patient.class, (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class, (Class<? extends Resource>)Device.class, (Class<? extends Resource>)Medication.class, (Class<? extends Resource>)Substance.class, (Class<? extends Resource>)Group.class);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(managingEntity, memberEntities, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(HealthcareService resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> providedBy = this.getReference(resource, HealthcareService::hasProvidedBy, HealthcareService::getProvidedBy, "HealthcareService.providedBy", Organization.class);
        Stream<ResourceReference> locations = this.getReferences(resource, HealthcareService::hasLocation, HealthcareService::getLocation, "HealthcareService.location", Location.class);
        Stream<ResourceReference> coverageAreas = this.getReferences(resource, HealthcareService::hasCoverageArea, HealthcareService::getCoverageArea, "HealthcareService.coverageArea", Location.class);
        Stream<ResourceReference> endpoints = this.getReferences(resource, HealthcareService::hasEndpoint, HealthcareService::getEndpoint, "HealthcareService.endpoint", Endpoint.class);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(providedBy, locations, coverageAreas, endpoints, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(Library resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> subject = this.getReference(resource, Library::hasSubjectReference, Library::getSubjectReference, "Library.subject", Group.class);
        Stream<ResourceReference> relatedArtifact = this.getRelatedArtifacts(resource, Library::hasRelatedArtifact, Library::getRelatedArtifact, "Library.relatedArtifact");
        Stream<ResourceReference> content = this.getAttachments(resource, Library::hasContent, Library::getContent, "Library.content");
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(subject, relatedArtifact, content, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(Location resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> managingOrganization = this.getReference(resource, Location::hasManagingOrganization, Location::getManagingOrganization, "Location.managingOrganization", Organization.class);
        Stream<ResourceReference> partOf = this.getReference(resource, Location::hasPartOf, Location::getPartOf, "Location.partOf", Location.class);
        Stream<ResourceReference> endpoints = this.getReferences(resource, Location::hasEndpoint, Location::getEndpoint, "Location.endpoint", Endpoint.class);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(managingOrganization, partOf, endpoints, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(Measure resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> subject = this.getReference(resource, Measure::hasSubjectReference, Measure::getSubjectReference, "Measure.subject", Group.class);
        Stream<ResourceReference> relatedArtifacts = this.getRelatedArtifacts(resource, Measure::hasRelatedArtifact, Measure::getRelatedArtifact, "Measure.relatedArtifact");
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(subject, relatedArtifacts, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(MeasureReport resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> subject = this.getReference((BackboneElement)resource, MeasureReport::hasSubject, MeasureReport::getSubject, "MeasureReport.subject", (Class<? extends Resource>)Patient.class, (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class, (Class<? extends Resource>)Location.class, (Class<? extends Resource>)Device.class, (Class<? extends Resource>)RelatedPerson.class, (Class<? extends Resource>)Group.class);
        Stream<ResourceReference> reporter = this.getReference((BackboneElement)resource, MeasureReport::hasReporter, MeasureReport::getReporter, "MeasureReport.reporter", (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class, (Class<? extends Resource>)Location.class, (Class<? extends Resource>)Organization.class);
        Stream<ResourceReference> subjectResults1 = this.getBackboneElements2Reference(resource, MeasureReport::hasGroup, MeasureReport::getGroup, MeasureReport.MeasureReportGroupComponent::hasPopulation, MeasureReport.MeasureReportGroupComponent::getPopulation, MeasureReport.MeasureReportGroupPopulationComponent::hasSubjectResults, MeasureReport.MeasureReportGroupPopulationComponent::getSubjectResults, "MeasureReport.group.population.subjectResults", ListResource.class);
        Stream<ResourceReference> subjectResults2 = this.getBackboneElements4Reference(resource, MeasureReport::hasGroup, MeasureReport::getGroup, MeasureReport.MeasureReportGroupComponent::hasStratifier, MeasureReport.MeasureReportGroupComponent::getStratifier, MeasureReport.MeasureReportGroupStratifierComponent::hasStratum, MeasureReport.MeasureReportGroupStratifierComponent::getStratum, MeasureReport.StratifierGroupComponent::hasPopulation, MeasureReport.StratifierGroupComponent::getPopulation, MeasureReport.StratifierGroupPopulationComponent::hasSubjectResults, MeasureReport.StratifierGroupPopulationComponent::getSubjectResults, "Measure.group.stratifier.stratum.population.subjectResults", ListResource.class);
        Stream<ResourceReference> evaluatedResource = this.getReferences(resource, MeasureReport::hasEvaluatedResource, MeasureReport::getEvaluatedResource, "Measure.evaluatedResource", new Class[0]);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(subject, reporter, subjectResults1, subjectResults2, evaluatedResource, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(NamingSystem resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return extensionReferences;
    }

    @Override
    public Stream<ResourceReference> getReferences(OperationOutcome resource) {
        if (resource == null) {
            return Stream.empty();
        }
        return this.getExtensionReferences((DomainResource)resource);
    }

    @Override
    public Stream<ResourceReference> getReferences(Organization resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> partOf = this.getReference(resource, Organization::hasPartOf, Organization::getPartOf, "Organization.partOf", Organization.class);
        Stream<ResourceReference> endpoints = this.getReferences(resource, Organization::hasEndpoint, Organization::getEndpoint, "Organization.endpoint", Endpoint.class);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(partOf, endpoints, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(OrganizationAffiliation resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> organization = this.getReference(resource, OrganizationAffiliation::hasOrganization, OrganizationAffiliation::getOrganization, "OrganizationAffiliation.organization", Organization.class);
        Stream<ResourceReference> participatingOrganization = this.getReference(resource, OrganizationAffiliation::hasParticipatingOrganization, OrganizationAffiliation::getParticipatingOrganization, "OrganizationAffiliation.participatingOrganization", Organization.class);
        Stream<ResourceReference> network = this.getReferences(resource, OrganizationAffiliation::hasNetwork, OrganizationAffiliation::getNetwork, "OrganizationAffiliation.network", Organization.class);
        Stream<ResourceReference> location = this.getReferences(resource, OrganizationAffiliation::hasLocation, OrganizationAffiliation::getLocation, "OrganizationAffiliation.location", Location.class);
        Stream<ResourceReference> healthcareService = this.getReferences(resource, OrganizationAffiliation::hasHealthcareService, OrganizationAffiliation::getHealthcareService, "OrganizationAffiliation.healthcareService", HealthcareService.class);
        Stream<ResourceReference> endpoint = this.getReferences(resource, OrganizationAffiliation::hasEndpoint, OrganizationAffiliation::getEndpoint, "OrganizationAffiliation.endpoint", Endpoint.class);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(organization, participatingOrganization, network, location, healthcareService, endpoint, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(Patient resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> contactsOrganization = this.getBackboneElementsReference(resource, Patient::hasContact, Patient::getContact, Patient.ContactComponent::hasOrganization, Patient.ContactComponent::getOrganization, "Patient.contact.organization", Organization.class);
        Stream<ResourceReference> generalPractitioners = this.getReferences((BackboneElement)resource, Patient::hasGeneralPractitioner, Patient::getGeneralPractitioner, "Patient.generalPractitioner", (Class<? extends DomainResource>)Organization.class, (Class<? extends DomainResource>)Practitioner.class, (Class<? extends DomainResource>)PractitionerRole.class);
        Stream<ResourceReference> managingOrganization = this.getReference(resource, Patient::hasManagingOrganization, Patient::getManagingOrganization, "Patient.managingOrganization", Organization.class);
        Stream<ResourceReference> linksOther = this.getBackboneElementsReference((Resource)resource, Patient::hasLink, Patient::getLink, Patient.PatientLinkComponent::hasOther, Patient.PatientLinkComponent::getOther, "Patient.link.other", (Class<? extends Resource>)Patient.class, (Class<? extends Resource>)RelatedPerson.class);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(contactsOrganization, generalPractitioners, managingOrganization, linksOther, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(Practitioner resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> qualificationsIssuer = this.getBackboneElementsReference(resource, Practitioner::hasQualification, Practitioner::getQualification, Practitioner.PractitionerQualificationComponent::hasIssuer, Practitioner.PractitionerQualificationComponent::getIssuer, "Practitioner.qualification.issuer", Organization.class);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(qualificationsIssuer, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(PractitionerRole resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> practitioner = this.getReference(resource, PractitionerRole::hasPractitioner, PractitionerRole::getPractitioner, "PractitionerRole.practitioner", Practitioner.class);
        Stream<ResourceReference> organization = this.getReference(resource, PractitionerRole::hasOrganization, PractitionerRole::getOrganization, "PractitionerRole.organization", Organization.class);
        Stream<ResourceReference> locations = this.getReferences(resource, PractitionerRole::hasLocation, PractitionerRole::getLocation, "PractitionerRole.location", Location.class);
        Stream<ResourceReference> healthcareServices = this.getReferences(resource, PractitionerRole::hasHealthcareService, PractitionerRole::getHealthcareService, "PractitionerRole.healthcareService", HealthcareService.class);
        Stream<ResourceReference> endpoints = this.getReferences(resource, PractitionerRole::hasEndpoint, PractitionerRole::getEndpoint, "PractitionerRole.endpoint", Endpoint.class);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(practitioner, organization, locations, healthcareServices, endpoints, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(Provenance resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> targets = this.getReferences(resource, Provenance::hasTarget, Provenance::getTarget, "Provenance.target", new Class[0]);
        Stream<ResourceReference> location = this.getReference(resource, Provenance::hasLocation, Provenance::getLocation, "Provenance.location", Location.class);
        Stream<ResourceReference> agentsWho = this.getBackboneElementsReference((Resource)resource, Provenance::hasAgent, Provenance::getAgent, Provenance.ProvenanceAgentComponent::hasWho, Provenance.ProvenanceAgentComponent::getWho, "Provenance.agent.who", (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class, (Class<? extends Resource>)RelatedPerson.class, (Class<? extends Resource>)Patient.class, (Class<? extends Resource>)Device.class, (Class<? extends Resource>)Organization.class);
        Stream<ResourceReference> agentsOnBehalfOf = this.getBackboneElementsReference((Resource)resource, Provenance::hasAgent, Provenance::getAgent, Provenance.ProvenanceAgentComponent::hasOnBehalfOf, Provenance.ProvenanceAgentComponent::getOnBehalfOf, "Provenance.agent.onBehalfOf", (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class, (Class<? extends Resource>)RelatedPerson.class, (Class<? extends Resource>)Patient.class, (Class<? extends Resource>)Device.class, (Class<? extends Resource>)Organization.class);
        Stream<ResourceReference> entitiesWhat = this.getBackboneElementsReference(resource, Provenance::hasEntity, Provenance::getEntity, Provenance.ProvenanceEntityComponent::hasWhat, Provenance.ProvenanceEntityComponent::getWhat, "Provenance.entity.what", new Class[0]);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(targets, location, agentsWho, agentsOnBehalfOf, entitiesWhat, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(Questionnaire resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> enableWhen = this.getBackboneElements2Reference(resource, Questionnaire::hasItem, Questionnaire::getItem, Questionnaire.QuestionnaireItemComponent::hasEnableWhen, Questionnaire.QuestionnaireItemComponent::getEnableWhen, Questionnaire.QuestionnaireItemEnableWhenComponent::hasAnswerReference, Questionnaire.QuestionnaireItemEnableWhenComponent::getAnswerReference, "Questionnaire.item.enableWhen.answerReference", new Class[0]);
        Stream<ResourceReference> answerOption = this.getBackboneElements2Reference(resource, Questionnaire::hasItem, Questionnaire::getItem, Questionnaire.QuestionnaireItemComponent::hasAnswerOption, Questionnaire.QuestionnaireItemComponent::getAnswerOption, Questionnaire.QuestionnaireItemAnswerOptionComponent::hasValueReference, Questionnaire.QuestionnaireItemAnswerOptionComponent::getValueReference, "Questionnaire.item.answerOption.valueReference", new Class[0]);
        Stream<ResourceReference> initial = this.getBackboneElements2Reference(resource, Questionnaire::hasItem, Questionnaire::getItem, Questionnaire.QuestionnaireItemComponent::hasInitial, Questionnaire.QuestionnaireItemComponent::getInitial, Questionnaire.QuestionnaireItemInitialComponent::hasValueReference, Questionnaire.QuestionnaireItemInitialComponent::getValueReference, "Questionnaire.item.initial.valueReference", new Class[0]);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(enableWhen, answerOption, initial, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(QuestionnaireResponse resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> author = this.getReference((BackboneElement)resource, QuestionnaireResponse::hasAuthor, QuestionnaireResponse::getAuthor, "QuestionnaireResponse.author", (Class<? extends Resource>)Device.class, (Class<? extends Resource>)Organization.class, (Class<? extends Resource>)Patient.class, (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class, (Class<? extends Resource>)RelatedPerson.class);
        Stream<ResourceReference> basedOn = this.getReferences((BackboneElement)resource, QuestionnaireResponse::hasBasedOn, QuestionnaireResponse::getBasedOn, "QuestionnaireResponse.basedOn", (Class<? extends DomainResource>)CarePlan.class, (Class<? extends DomainResource>)ServiceRequest.class);
        Stream<ResourceReference> encounter = this.getReference(resource, QuestionnaireResponse::hasEncounter, QuestionnaireResponse::getEncounter, "QuestionnaireResponse.encounter", Encounter.class);
        Stream<ResourceReference> partOf = this.getReferences((BackboneElement)resource, QuestionnaireResponse::hasPartOf, QuestionnaireResponse::getPartOf, "QuestionnaireResponse.partOf", (Class<? extends DomainResource>)Observation.class, (Class<? extends DomainResource>)Procedure.class);
        Stream<ResourceReference> source = this.getReference((BackboneElement)resource, QuestionnaireResponse::hasSource, QuestionnaireResponse::getSource, "QuestionnaireResponse.source", (Class<? extends Resource>)Patient.class, (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class, (Class<? extends Resource>)RelatedPerson.class);
        Stream<ResourceReference> subject = this.getReference(resource, QuestionnaireResponse::hasSubject, QuestionnaireResponse::getSubject, "QuestionnaireResponse.subject", new Class[0]);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(author, basedOn, encounter, partOf, source, subject, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(ResearchStudy resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> protocols = this.getReferences(resource, ResearchStudy::hasProtocol, ResearchStudy::getProtocol, "ResearchStudy.protocol", PlanDefinition.class);
        Stream<ResourceReference> partOfs = this.getReferences(resource, ResearchStudy::hasPartOf, ResearchStudy::getPartOf, "ResearchStudy.partOf", ResearchStudy.class);
        Stream<ResourceReference> enrollments = this.getReferences(resource, ResearchStudy::hasEnrollment, ResearchStudy::getEnrollment, "ResearchStudy.enrollment", Group.class);
        Stream<ResourceReference> sponsor = this.getReference(resource, ResearchStudy::hasSponsor, ResearchStudy::getSponsor, "ResearchStudy.sponsor", Organization.class);
        Stream<ResourceReference> principalInvestigator = this.getReference((BackboneElement)resource, ResearchStudy::hasPrincipalInvestigator, ResearchStudy::getPrincipalInvestigator, "ResearchStudy.principalInvestigator", (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class);
        Stream<ResourceReference> sites = this.getReferences(resource, ResearchStudy::hasSite, ResearchStudy::getSite, "ResearchStudy.site", Location.class);
        Stream<ResourceReference> relatedArtifacts = this.getRelatedArtifacts(resource, ResearchStudy::hasRelatedArtifact, ResearchStudy::getRelatedArtifact, "ResearchStudy.relatedArtifact");
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(protocols, partOfs, enrollments, sponsor, principalInvestigator, sites, relatedArtifacts, extensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(StructureDefinition resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return extensionReferences;
    }

    @Override
    public Stream<ResourceReference> getReferences(Subscription resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return extensionReferences;
    }

    @Override
    public Stream<ResourceReference> getReferences(Task resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> basedOns = this.getReferences(resource, Task::hasBasedOn, Task::getBasedOn, "Task.basedOn", new Class[0]);
        Stream<ResourceReference> partOfs = this.getReferences(resource, Task::hasPartOf, Task::getPartOf, "Task.partOf", Task.class);
        Stream<ResourceReference> focus = this.getReference(resource, Task::hasFocus, Task::getFocus, "Task.focus", new Class[0]);
        Stream<ResourceReference> forRef = this.getReference(resource, Task::hasFor, Task::getFor, "Task.for", new Class[0]);
        Stream<ResourceReference> encounter = this.getReference(resource, Task::hasEncounter, Task::getEncounter, "Task.encounter", Encounter.class);
        Stream<ResourceReference> requester = this.getReference((BackboneElement)resource, Task::hasRequester, Task::getRequester, "Task.requester", (Class<? extends Resource>)Device.class, (Class<? extends Resource>)Organization.class, (Class<? extends Resource>)Patient.class, (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class, (Class<? extends Resource>)RelatedPerson.class);
        Stream<ResourceReference> owner = this.getReference((BackboneElement)resource, Task::hasOwner, Task::getOwner, "Task.owner", (Class<? extends Resource>)Practitioner.class, (Class<? extends Resource>)PractitionerRole.class, (Class<? extends Resource>)Organization.class, (Class<? extends Resource>)CareTeam.class, (Class<? extends Resource>)HealthcareService.class, (Class<? extends Resource>)Patient.class, (Class<? extends Resource>)Device.class, (Class<? extends Resource>)RelatedPerson.class);
        Stream<ResourceReference> location = this.getReference(resource, Task::hasLocation, Task::getLocation, "Task.location", Location.class);
        Stream<ResourceReference> reasonReference = this.getReference(resource, Task::hasReasonReference, Task::getReasonReference, "Task.reasonReference", new Class[0]);
        Stream<ResourceReference> insurance = this.getReferences((BackboneElement)resource, Task::hasInsurance, Task::getInsurance, "Task.insurance", (Class<? extends DomainResource>)Coverage.class, (Class<? extends DomainResource>)ClaimResponse.class);
        Stream<ResourceReference> relevanteHistories = this.getReferences(resource, Task::hasRelevantHistory, Task::getRelevantHistory, "Task.relevantHistory", Provenance.class);
        Stream<ResourceReference> restrictionRecipiets = this.getBackboneElementReferences((DomainResource)resource, Task::hasRestriction, Task::getRestriction, Task.TaskRestrictionComponent::hasRecipient, Task.TaskRestrictionComponent::getRecipient, "Task.restriction.recipient", (Class<? extends DomainResource>)Patient.class, (Class<? extends DomainResource>)Practitioner.class, (Class<? extends DomainResource>)PractitionerRole.class, (Class<? extends DomainResource>)RelatedPerson.class, (Class<? extends DomainResource>)Group.class, (Class<? extends DomainResource>)Organization.class);
        Stream<ResourceReference> inputReferences = this.getInputReferences(resource);
        Stream<ResourceReference> outputReferences = this.getOutputReferences(resource);
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return this.concat(basedOns, partOfs, focus, forRef, encounter, requester, owner, location, reasonReference, insurance, relevanteHistories, restrictionRecipiets, inputReferences, outputReferences, extensionReferences);
    }

    private Stream<ResourceReference> getInputReferences(Task resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> inputReferences = resource.getInput().stream().filter(in -> in.getValue() instanceof Reference).map(in -> (Reference)in.getValue()).map(this.toResourceReferenceFromReference(resource.getResourceType().name() + ".input", new Class[0]));
        Stream inputExtensionReferences = resource.getInput().stream().flatMap(in -> this.getExtensionReferences(resource.getResourceType().name() + ".input", (BackboneElement)in));
        return Stream.concat(inputReferences, inputExtensionReferences);
    }

    private Stream<ResourceReference> getOutputReferences(Task resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> outputReferences = resource.getOutput().stream().filter(out -> out.getValue() instanceof Reference).map(in -> (Reference)in.getValue()).map(this.toResourceReferenceFromReference(resource.getResourceType().name() + ".output", new Class[0]));
        Stream outputExtensionReferences = resource.getOutput().stream().flatMap(out -> this.getExtensionReferences(resource.getResourceType().name() + ".output", (BackboneElement)out));
        return Stream.concat(outputReferences, outputExtensionReferences);
    }

    @Override
    public Stream<ResourceReference> getReferences(ValueSet resource) {
        if (resource == null) {
            return Stream.empty();
        }
        Stream<ResourceReference> extensionReferences = this.getExtensionReferences((DomainResource)resource);
        return extensionReferences;
    }
}

