/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.parser.IParser;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.adapter.AbstractAdapter;
import dev.dsf.fhir.adapter.HtmlGenerator;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Resource;

@Provider
@Produces(value={"text/html"})
public class HtmlFhirAdapter
extends AbstractAdapter
implements MessageBodyWriter<BaseResource> {
    private static final String RESOURCE_NAMES = "Account|ActivityDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|DomainResource|EffectEvidenceSynthesis|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|InsurancePlan|Invoice|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProduct|MedicinalProductAuthorization|MedicinalProductContraindication|MedicinalProductIndication|MedicinalProductIngredient|MedicinalProductInteraction|MedicinalProductManufactured|MedicinalProductPackaged|MedicinalProductPharmaceutical|MedicinalProductUndesirableEffect|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionOrder|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|Parameters|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RelatedPerson|RequestGroup|ResearchDefinition|ResearchElementDefinition|ResearchStudy|ResearchSubject|Resource|RiskAssessment|RiskEvidenceSynthesis|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|Substance|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SubstanceSpecification|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription";
    private static final String UUID = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}";
    private static final Pattern URL_PATTERN = Pattern.compile("(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_.|]");
    private static final Pattern XML_REFERENCE_UUID_PATTERN = Pattern.compile("&lt;reference value=\"((Account|ActivityDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|DomainResource|EffectEvidenceSynthesis|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|InsurancePlan|Invoice|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProduct|MedicinalProductAuthorization|MedicinalProductContraindication|MedicinalProductIndication|MedicinalProductIngredient|MedicinalProductInteraction|MedicinalProductManufactured|MedicinalProductPackaged|MedicinalProductPharmaceutical|MedicinalProductUndesirableEffect|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionOrder|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|Parameters|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RelatedPerson|RequestGroup|ResearchDefinition|ResearchElementDefinition|ResearchStudy|ResearchSubject|Resource|RiskAssessment|RiskEvidenceSynthesis|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|Substance|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SubstanceSpecification|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription)/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\"/&gt;");
    private static final Pattern JSON_REFERENCE_UUID_PATTERN = Pattern.compile("\"reference\": \"((Account|ActivityDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|DomainResource|EffectEvidenceSynthesis|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|InsurancePlan|Invoice|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProduct|MedicinalProductAuthorization|MedicinalProductContraindication|MedicinalProductIndication|MedicinalProductIngredient|MedicinalProductInteraction|MedicinalProductManufactured|MedicinalProductPackaged|MedicinalProductPharmaceutical|MedicinalProductUndesirableEffect|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionOrder|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|Parameters|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RelatedPerson|RequestGroup|ResearchDefinition|ResearchElementDefinition|ResearchStudy|ResearchSubject|Resource|RiskAssessment|RiskEvidenceSynthesis|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|Substance|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SubstanceSpecification|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription)/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\",");
    private static final Pattern XML_ID_UUID_AND_VERSION_PATTERN = Pattern.compile("&lt;id value=\"([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\"/&gt;\\n([ ]*)&lt;meta&gt;\\n([ ]*)&lt;versionId value=\"([0-9]+)\"/&gt;");
    private static final Pattern JSON_ID_UUID_AND_VERSION_PATTERN = Pattern.compile("\"id\": \"([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\",\\n([ ]*)\"meta\": \\{\\n([ ]*)\"versionId\": \"([0-9]+)\",");
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private final FhirContext fhirContext;
    private final Supplier<String> serverBaseProvider;
    private final Map<Class<? extends BaseResource>, HtmlGenerator<? extends BaseResource>> htmlGeneratorsByType;
    @Context
    private volatile UriInfo uriInfo;
    @Context
    private volatile SecurityContext securityContext;

    public HtmlFhirAdapter(FhirContext fhirContext, Supplier<String> serverBaseProvider, Collection<? extends HtmlGenerator<?>> htmlGenerators) {
        this.fhirContext = fhirContext;
        this.serverBaseProvider = serverBaseProvider;
        this.htmlGeneratorsByType = htmlGenerators != null ? htmlGenerators.stream().collect(Collectors.toMap(HtmlGenerator::getResourceType, Function.identity())) : Collections.emptyMap();
    }

    protected FhirContext getFhirContext() {
        return this.fhirContext;
    }

    @Override
    protected IParser getParser(MediaType mediaType, Supplier<IParser> parser) {
        IParser p = super.getParser(mediaType, parser);
        p.setPrettyPrint(true);
        return p;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type != null && BaseResource.class.isAssignableFrom(type);
    }

    public void writeTo(BaseResource resource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String basePath = this.uriInfo.getBaseUri().getRawPath();
        OutputStreamWriter out = new OutputStreamWriter(entityStream);
        out.write("<!DOCTYPE html>\n<html>\n<head>\n<link rel=\"icon\" type=\"image/svg+xml\" href=\"${basePath}static/favicon.svg\">\n<link rel=\"icon\" type=\"image/png\" href=\"${basePath}static/favicon_32x32.png\" sizes=\"32x32\">\n<link rel=\"icon\" type=\"image/png\" href=\"${basePath}static/favicon_96x96.png\" sizes=\"96x96\">\n<meta name=\"theme-color\" content=\"#326F95\">\n<script src=\"${basePath}static/prettify.js\"></script>\n<script src=\"${basePath}static/tabs.js\"></script>\n<script src=\"${basePath}static/bookmarks.js\"></script>\n<script src=\"${basePath}static/help.js\"></script>\n<script src=\"${basePath}static/form.js\"></script>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"${basePath}static/prettify.css\">\n<link rel=\"stylesheet\" type=\"text/css\" href=\"${basePath}static/dsf.css\">\n<link rel=\"stylesheet\" type=\"text/css\" href=\"${basePath}static/form.css\">\n".replace("${basePath}", basePath));
        out.write("<title>DSF" + (this.uriInfo.getPath() == null || this.uriInfo.getPath().isEmpty() ? "" : ": ") + this.uriInfo.getPath() + "</title>\n");
        out.write("</head>\n");
        out.write("<body onload=\"prettyPrint();openInitialTab(" + String.valueOf(this.isHtmlEnabled(type)) + ");checkBookmarked();\">\n");
        out.write("<div id=\"icons\">\n");
        Principal userPrincipal = this.securityContext.getUserPrincipal();
        if (userPrincipal instanceof Identity) {
            Identity identity = (Identity)userPrincipal;
            out.write("<span id=\"hello-user\">");
            out.write("Hello, ");
            out.write(identity.getDisplayName());
            out.write("</span>\n");
        }
        if ("OPENID".equals(this.securityContext.getAuthenticationScheme())) {
            out.write("<a href=\"${basePath}logout\">\n<svg class=\"icon\" id=\"logout-icon\" viewBox=\"0 0 24 24\">\n<title>Logout</title>\n<path d=\"M5 21q-.825 0-1.413-.587Q3 19.825 3 19V5q0-.825.587-1.413Q4.175 3 5 3h7v2H5v14h7v2Zm11-4-1.375-1.45 2.55-2.55H9v-2h8.175l-2.55-2.55L16 7l5 5Z\"/>\n</svg></a>\n".replace("${basePath}", basePath));
        }
        out.write("<svg class=\"icon\" id=\"help-icon\" viewBox=\"0 0 24 24\" onclick=\"showHelp();\">\n<title>Show Help</title>\n<path d=\"M11.07,12.85c0.77-1.39,2.25-2.21,3.11-3.44c0.91-1.29,0.4-3.7-2.18-3.7c-1.69,0-2.52,1.28-2.87,2.34L6.54,6.96 C7.25,4.83,9.18,3,11.99,3c2.35,0,3.96,1.07,4.78,2.41c0.7,1.15,1.11,3.3,0.03,4.9c-1.2,1.77-2.35,2.31-2.97,3.45 c-0.25,0.46-0.35,0.76-0.35,2.24h-2.89C10.58,15.22,10.46,13.95,11.07,12.85z M14,20c0,1.1-0.9,2-2,2s-2-0.9-2-2c0-1.1,0.9-2,2-2 S14,18.9,14,20z\"/>\n</svg>\n<a href=\"\" download=\"\" id=\"download-link\" title=\"\">\n<svg class=\"icon\" id=\"download\" viewBox=\"0 0 24 24\">\n<path d=\"M18,15v3H6v-3H4v3c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-3H18z M17,11l-1.41-1.41L13,12.17V4h-2v8.17L8.41,9.59L7,11l5,5 L17,11z\"/>\n</svg></a>\n<svg class=\"icon\" id=\"bookmark-add\" viewBox=\"0 0 24 24\" onclick=\"addCurrentBookmark();\">\n<title>Add Bookmark</title>\n<path d=\"M17,11v6.97l-5-2.14l-5,2.14V5h6V3H7C5.9,3,5,3.9,5,5v16l7-3l7,3V11H17z M21,7h-2v2h-2V7h-2V5h2V3h2v2h2V7z\"/>\n</svg>\n<svg class=\"icon\" id=\"bookmark-remove\" viewBox=\"0 0 24 24\" onclick=\"removeCurrentBookmark();\" style=\"display:none;\">\n<title>Remove Bookmark</title>\n<path d=\"M17,11v6.97l-5-2.14l-5,2.14V5h6V3H7C5.9,3,5,3.9,5,5v16l7-3l7,3V11H17z M21,7h-6V5h6V7z\"/>\n</svg>\n<svg class=\"icon\" id=\"bookmark-list\" viewBox=\"0 0 24 24\" onclick=\"showBookmarks();\">\n<title>Show Bookmarks</title>\n<path d=\"M9,1H19A2,2 0 0,1 21,3V19L19,18.13V3H7A2,2 0 0,1 9,1M15,20V7H5V20L10,17.82L15,20M15,5C16.11,5 17,5.9 17,7V23L10,20L3,23V7A2,2 0 0,1 5,5H15Z\"/>\n</svg>\n</div>\n<div id=\"help\" style=\"display:none;\">\n<h3 id=\"help-title\">Query Parameters</h3>\n<svg class=\"icon\" id=\"help-close\" viewBox=\"0 0 24 24\" onclick=\"closeHelp();\">\n<title>Close Help</title>\n<path fill=\"currentColor\" d=\"M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z\"/>\n</svg>\n<div id=\"help-list\"></div>\n</div>\n<div id=\"bookmarks\" style=\"display:none;\">\n<h3 id=\"bookmarks-title\">Bookmarks</h3>\n<svg class=\"icon\" id=\"bookmark-list-close\" viewBox=\"0 0 24 24\" onclick=\"closeBookmarks();\">\n<title>Close Bookmarks</title>\n<path fill=\"currentColor\" d=\"M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z\"/>\n</svg>\n<div id=\"bookmarks-list\"></div>\n</div>\n<table id=\"header\">\n<tr>\n<td>\n<image src=\"${basePath}static/logo.svg\">\n</td>\n<td id=\"url\">\n<h1>\n".replace("${basePath}", basePath));
        out.write(this.getUrlHeading(resource));
        out.write("</h1>\n</td>\n</tr>\n</table>\n<div class=\"tab\">\n");
        if (this.isHtmlEnabled(type)) {
            out.write("<button id=\"html-button\" class=\"tablinks\" onclick=\"openTab('html')\">html</button>\n");
        }
        out.write("<button id=\"json-button\" class=\"tablinks\" onclick=\"openTab('json')\">json</button>\n<button id=\"xml-button\" class=\"tablinks\" onclick=\"openTab('xml')\">xml</button>\n</div>\n");
        this.writeXml(mediaType, basePath, resource, out);
        this.writeJson(mediaType, basePath, resource, out);
        if (this.isHtmlEnabled(type)) {
            this.writeHtml(type, basePath, resource, out);
        }
        out.write("</html>");
        out.flush();
    }

    private String getUrlHeading(BaseResource resource) throws MalformedURLException {
        URI uri = this.getResourceUrl(resource).map(this::toURI).orElse(this.uriInfo.getRequestUri());
        String[] pathSegments = uri.getPath().split("/");
        Object u = this.serverBaseProvider.get();
        StringBuilder heading = new StringBuilder("<a href=\"" + (String)u + "/\" title=\"Open " + (String)u + "\">" + (String)u + "</a>");
        for (int i = 2; i < pathSegments.length; ++i) {
            u = (String)u + "/" + pathSegments[i];
            heading.append("<a href=\"" + (String)u + "\" title=\"Open " + (String)u + "\">/" + pathSegments[i] + "</a>");
        }
        if (uri.getQuery() != null) {
            u = (String)u + "?" + uri.getQuery();
            heading.append("<a href=\"" + (String)u + "\" title=\"Open " + (String)u + "\">?" + uri.getQuery() + "</a>");
        } else if (this.uriInfo.getQueryParameters().containsKey((Object)"_summary")) {
            u = (String)u + "?_summary=" + (String)this.uriInfo.getQueryParameters().getFirst((Object)"_summary");
            heading.append("<a href=\"" + (String)u + "\" title=\"Open " + (String)u + "\">?_summary=" + (String)this.uriInfo.getQueryParameters().getFirst((Object)"_summary") + "</a>");
        }
        heading.append('\n');
        return heading.toString();
    }

    private URI toURI(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<String> getResourceUrl(BaseResource resource) throws MalformedURLException {
        if (resource instanceof Resource && resource.getIdElement().hasIdPart()) {
            if (!this.uriInfo.getPath().contains("_history")) {
                return Optional.of(String.format("%s/%s/%s", this.serverBaseProvider.get(), resource.getIdElement().getResourceType(), resource.getIdElement().getIdPart()));
            }
            return Optional.of(String.format("%s/%s/%s/_history/%s", this.serverBaseProvider.get(), resource.getIdElement().getResourceType(), resource.getIdElement().getIdPart(), resource.getIdElement().getVersionIdPart()));
        }
        if (resource instanceof Bundle && !resource.getIdElement().hasIdPart()) {
            return ((Bundle)resource).getLink().stream().filter(c -> "self".equals(c.getRelation())).findFirst().map(c -> c.getUrl());
        }
        return Optional.empty();
    }

    private void writeXml(MediaType mediaType, String basePath, BaseResource resource, OutputStreamWriter out) throws IOException {
        IParser parser = this.getParser(mediaType, () -> ((FhirContext)this.fhirContext).newXmlParser());
        out.write("<pre id=\"xml\" class=\"prettyprint linenums lang-xml\" style=\"display:none;\">");
        String content = parser.encodeResourceToString((IBaseResource)resource);
        content = content.replace("&amp;", "&amp;amp;").replace("&apos;", "&amp;apos;").replace("&gt;", "&amp;gt;").replace("&lt;", "&amp;lt;").replace("&quot;", "&amp;quot;");
        content = this.simplifyXml(content);
        content = content.replace("<", "&lt;").replace(">", "&gt;");
        Matcher versionMatcher = XML_ID_UUID_AND_VERSION_PATTERN.matcher(content);
        content = versionMatcher.replaceAll(result -> {
            Optional<String> resourceName = this.getResourceName(resource, result.group(1));
            return resourceName.map(rN -> "&lt;id value=\"<a href=\"" + basePath + rN + "/" + result.group(1) + "\">" + result.group(1) + "</a>\"/&gt;\n" + result.group(2) + "&lt;meta&gt;\n" + result.group(3) + "&lt;versionId value=\"<a href=\"" + basePath + rN + "/" + result.group(1) + "/_history/" + result.group(4) + "\">" + result.group(4) + "</a>\"/&gt;").orElse(result.group(0));
        });
        Matcher urlMatcher = URL_PATTERN.matcher(content);
        content = urlMatcher.replaceAll(result -> "<a href=\"" + result.group().replace("&amp;amp;", "&amp;").replace("&amp;apos;", "&apos;").replace("&amp;gt;", "&gt;").replace("&amp;lt;", "&lt;").replace("&amp;quot;", "&quot;") + "\">" + result.group() + "</a>");
        Matcher referenceUuidMatcher = XML_REFERENCE_UUID_PATTERN.matcher(content);
        content = referenceUuidMatcher.replaceAll(result -> "&lt;reference value=\"<a href=\"/fhir/" + result.group(1) + "\">" + result.group(1) + "</a>\"&gt");
        out.write(content);
        out.write("</pre>\n");
    }

    private Transformer newTransformer() throws TransformerConfigurationException {
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
        return transformer;
    }

    private String simplifyXml(String xml) {
        try {
            Transformer transformer = this.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new StreamSource(new StringReader(xml)), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeJson(MediaType mediaType, String basePath, BaseResource resource, OutputStreamWriter out) throws IOException {
        IParser parser = this.getParser(mediaType, () -> ((FhirContext)this.fhirContext).newJsonParser());
        out.write("<pre id=\"json\" class=\"prettyprint linenums lang-json\" style=\"display:none;\">");
        String content = parser.encodeResourceToString((IBaseResource)resource).replace("<", "&lt;").replace(">", "&gt;");
        Matcher urlMatcher = URL_PATTERN.matcher(content);
        content = urlMatcher.replaceAll(result -> "<a href=\"" + result.group() + "\">" + result.group() + "</a>");
        Matcher referenceUuidMatcher = JSON_REFERENCE_UUID_PATTERN.matcher(content);
        content = referenceUuidMatcher.replaceAll(result -> "\"reference\": \"<a href=\"" + basePath + result.group(1) + "\">" + result.group(1) + "</a>\",");
        Matcher idUuidMatcher = JSON_ID_UUID_AND_VERSION_PATTERN.matcher(content);
        content = idUuidMatcher.replaceAll(result -> {
            Optional<String> resourceName = this.getResourceName(resource, result.group(1));
            return resourceName.map(rN -> "\"id\": \"<a href=\"" + basePath + rN + "/" + result.group(1) + "\">" + result.group(1) + "</a>\",\n" + result.group(2) + "\"meta\": {\n" + result.group(3) + "\"versionId\": \"<a href=\"" + basePath + rN + "/" + result.group(1) + "/_history/" + result.group(4) + "\">" + result.group(4) + "</a>\",").orElse(result.group(0));
        });
        out.write(content);
        out.write("</pre>\n");
    }

    private void writeHtml(Class<?> resourceType, String basePath, BaseResource resource, OutputStreamWriter out) throws IOException {
        out.write("<div id=\"html\" class=\"prettyprint lang-html\" style=\"display:none;\">\n");
        HtmlGenerator<? extends BaseResource> generator = this.htmlGeneratorsByType.get(resourceType);
        generator.writeHtml(basePath, (BaseResource)resource, out);
        out.write("</div>\n");
    }

    private boolean isHtmlEnabled(Class<?> resourceType) {
        return this.htmlGeneratorsByType.containsKey(resourceType);
    }

    private Optional<String> getResourceName(BaseResource resource, String uuid) {
        if (resource instanceof Bundle) {
            if (Objects.equals(uuid, resource.getIdElement().getIdPart())) {
                return Optional.of(resource.getClass().getAnnotation(ResourceDef.class).name());
            }
            return ((Bundle)resource).getEntry().stream().filter(c -> {
                if (c.hasResource()) {
                    return uuid.equals(c.getResource().getIdElement().getIdPart());
                }
                return uuid.equals(new IdType(c.getResponse().getLocation()).getIdPart());
            }).map(c -> {
                if (c.hasResource()) {
                    return c.getResource().getClass().getAnnotation(ResourceDef.class).name();
                }
                return new IdType(c.getResponse().getLocation()).getResourceType();
            }).findFirst();
        }
        if (resource instanceof Resource) {
            return Optional.of(resource.getClass().getAnnotation(ResourceDef.class).name());
        }
        return Optional.empty();
    }
}

