/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.read;

import java.util.List;
import java.util.function.Predicate;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Resource;

public interface ReadAccessHelper {
    public static final String READ_ACCESS_TAG_SYSTEM = "http://dsf.dev/fhir/CodeSystem/read-access-tag";
    public static final String READ_ACCESS_TAG_VALUE_LOCAL = "LOCAL";
    public static final String READ_ACCESS_TAG_VALUE_ORGANIZATION = "ORGANIZATION";
    public static final String READ_ACCESS_TAG_VALUE_ROLE = "ROLE";
    public static final String READ_ACCESS_TAG_VALUE_ALL = "ALL";
    public static final String ORGANIZATION_IDENTIFIER_SYSTEM = "http://dsf.dev/sid/organization-identifier";
    public static final String EXTENSION_READ_ACCESS_ORGANIZATION = "http://dsf.dev/fhir/StructureDefinition/extension-read-access-organization";
    public static final String EXTENSION_READ_ACCESS_PARENT_ORGANIZATION_ROLE = "http://dsf.dev/fhir/StructureDefinition/extension-read-access-parent-organization-role";
    public static final String EXTENSION_READ_ACCESS_PARENT_ORGANIZATION_ROLE_PARENT_ORGANIZATION = "parent-organization";
    public static final String EXTENSION_READ_ACCESS_PARENT_ORGANIZATION_ROLE_ORGANIZATION_ROLE = "organization-role";

    public <R extends Resource> R addLocal(R var1);

    public <R extends Resource> R addOrganization(R var1, String var2);

    public <R extends Resource> R addOrganization(R var1, Organization var2);

    public <R extends Resource> R addRole(R var1, String var2, String var3, String var4);

    public <R extends Resource> R addRole(R var1, OrganizationAffiliation var2);

    public <R extends Resource> R addAll(R var1);

    public boolean hasLocal(Resource var1);

    public boolean hasOrganization(Resource var1, String var2);

    public boolean hasOrganization(Resource var1, Organization var2);

    public boolean hasAnyOrganization(Resource var1);

    public boolean hasRole(Resource var1, String var2, String var3, String var4);

    public boolean hasRole(Resource var1, OrganizationAffiliation var2);

    public boolean hasRole(Resource var1, List<OrganizationAffiliation> var2);

    public boolean hasAnyRole(Resource var1);

    public boolean hasAll(Resource var1);

    public boolean isValid(Resource var1);

    public boolean isValid(Resource var1, Predicate<Identifier> var2, Predicate<Coding> var3);
}

