/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.OrganizationIdentity;
import dev.dsf.common.auth.conf.PractitionerIdentity;
import dev.dsf.fhir.authorization.process.Recipient;
import dev.dsf.fhir.authorization.process.Requester;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Type;

public class All
implements Recipient,
Requester {
    private final boolean localIdentity;
    private final String practitionerRoleSystem;
    private final String practitionerRoleCode;

    public All(boolean localIdentity, String practitionerRoleSystem, String practitionerRoleCode) {
        this.localIdentity = localIdentity;
        this.practitionerRoleSystem = practitionerRoleSystem;
        this.practitionerRoleCode = practitionerRoleCode;
    }

    private boolean needsPractitionerRole() {
        return this.practitionerRoleSystem != null && this.practitionerRoleCode != null;
    }

    @Override
    public boolean isRequesterAuthorized(Identity requester, Stream<OrganizationAffiliation> requesterAffiliations) {
        return this.isAuthorized(requester);
    }

    @Override
    public boolean isRecipientAuthorized(Identity recipient, Stream<OrganizationAffiliation> recipientAffiliations) {
        return this.isAuthorized(recipient);
    }

    private boolean isAuthorized(Identity identity) {
        return identity != null && identity.getOrganization() != null && identity.getOrganization().getActive() && identity.isLocalIdentity() == this.localIdentity && (this.needsPractitionerRole() && this.hasPractitionerRole(this.getPractitionerRoles(identity)) || !this.needsPractitionerRole() && identity instanceof OrganizationIdentity);
    }

    private Set<Coding> getPractitionerRoles(Identity identity) {
        if (identity instanceof PractitionerIdentity) {
            PractitionerIdentity p = (PractitionerIdentity)identity;
            return p.getPractionerRoles();
        }
        return Collections.emptySet();
    }

    private boolean hasPractitionerRole(Set<Coding> practitionerRoles) {
        return practitionerRoles.stream().anyMatch(c -> this.practitionerRoleSystem.equals(c.getSystem()) && this.practitionerRoleCode.equals(c.getCode()));
    }

    @Override
    public Extension toRecipientExtension() {
        return new Extension().setUrl("recipient").setValue((Type)this.toCoding(false));
    }

    @Override
    public Extension toRequesterExtension() {
        return new Extension().setUrl("requester").setValue((Type)this.toCoding(this.needsPractitionerRole()));
    }

    private Coding toCoding(boolean needsPractitionerRole) {
        Coding coding = this.getProcessAuthorizationCode();
        if (needsPractitionerRole) {
            coding.addExtension().setUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-practitioner").setValue((Type)new Coding(this.practitionerRoleSystem, this.practitionerRoleCode, null));
        }
        return coding;
    }

    @Override
    public Coding getProcessAuthorizationCode() {
        if (this.localIdentity) {
            if (this.needsPractitionerRole()) {
                return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "LOCAL_ALL_PRACTITIONER", null);
            }
            return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "LOCAL_ALL", null);
        }
        return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "REMOTE_ALL", null);
    }

    @Override
    public boolean requesterMatches(Extension requesterExtension) {
        return this.matches(requesterExtension, "requester") && this.hasMatchingPractitionerExtension(requesterExtension.getValue().getExtension());
    }

    @Override
    public boolean recipientMatches(Extension recipientExtension) {
        return this.matches(recipientExtension, "recipient");
    }

    private boolean matches(Extension extension, String url) {
        Coding value;
        Type type;
        return extension != null && url.equals(extension.getUrl()) && extension.hasValue() && (type = extension.getValue()) instanceof Coding && this.matches(value = (Coding)type);
    }

    private boolean hasMatchingPractitionerExtension(List<Extension> extensions) {
        return this.needsPractitionerRole() ? extensions.stream().anyMatch(this::practitionerExtensionMatches) : extensions.stream().noneMatch(this::practitionerExtensionMatches);
    }

    private boolean practitionerExtensionMatches(Extension extension) {
        Coding value;
        Type type;
        return "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-practitioner".equals(extension.getUrl()) && extension.hasValue() && (type = extension.getValue()) instanceof Coding && this.practitionerRoleMatches(value = (Coding)type);
    }

    private boolean practitionerRoleMatches(Coding coding) {
        return coding != null && coding.hasSystem() && coding.hasCode() && this.practitionerRoleSystem.equals(coding.getSystem()) && this.practitionerRoleCode.equals(coding.getCode());
    }

    @Override
    public boolean matches(Coding processAuthorizationCode) {
        if (this.localIdentity) {
            if (this.needsPractitionerRole()) {
                return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "LOCAL_ALL_PRACTITIONER".equals(processAuthorizationCode.getCode());
            }
            return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "LOCAL_ALL".equals(processAuthorizationCode.getCode());
        }
        return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "REMOTE_ALL".equals(processAuthorizationCode.getCode());
    }

    public static Optional<Requester> fromRequester(Coding coding, Predicate<Coding> practitionerRoleExists) {
        if (coding != null && coding.hasSystem() && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(coding.getSystem()) && coding.hasCode()) {
            if ("LOCAL_ALL".equals(coding.getCode())) {
                return Optional.of(new All(true, null, null));
            }
            if ("REMOTE_ALL".equals(coding.getCode())) {
                return Optional.of(new All(false, null, null));
            }
            if ("LOCAL_ALL_PRACTITIONER".equals(coding.getCode())) {
                return All.fromPractitionerRequester(coding, practitionerRoleExists);
            }
        }
        return Optional.empty();
    }

    private static Optional<Requester> fromPractitionerRequester(Coding coding, Predicate<Coding> practitionerRoleExists) {
        Coding value;
        Type type;
        Extension practitionerRole;
        List practitionerRoles;
        if (coding != null && coding.hasExtension() && (practitionerRoles = coding.getExtension().stream().filter(Extension::hasUrl).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-practitioner".equals(e.getUrl())).collect(Collectors.toList())).size() == 1 && (practitionerRole = (Extension)practitionerRoles.get(0)).hasValue() && (type = practitionerRole.getValue()) instanceof Coding && (value = (Coding)type).hasSystem() && value.hasCode() && practitionerRoleExists.test(coding)) {
            return Optional.of(new All(true, value.getSystem(), value.getCode()));
        }
        return Optional.empty();
    }

    public static Optional<Recipient> fromRecipient(Coding coding) {
        if (coding != null && coding.hasSystem() && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(coding.getSystem()) && coding.hasCode() && "LOCAL_ALL".equals(coding.getCode())) {
            return Optional.of(new All(true, null, null));
        }
        return Optional.empty();
    }
}

