/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.fhir.authorization.process.Recipient;
import dev.dsf.fhir.authorization.process.Requester;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;

public interface ProcessAuthorizationHelper {
    public static final String PROCESS_AUTHORIZATION_SYSTEM = "http://dsf.dev/fhir/CodeSystem/process-authorization";
    public static final String PROCESS_AUTHORIZATION_VALUE_LOCAL_ORGANIZATION = "LOCAL_ORGANIZATION";
    public static final String PROCESS_AUTHORIZATION_VALUE_LOCAL_ORGANIZATION_PRACTITIONER = "LOCAL_ORGANIZATION_PRACTITIONER";
    public static final String PROCESS_AUTHORIZATION_VALUE_REMOTE_ORGANIZATION = "REMOTE_ORGANIZATION";
    public static final String PROCESS_AUTHORIZATION_VALUE_LOCAL_ROLE = "LOCAL_ROLE";
    public static final String PROCESS_AUTHORIZATION_VALUE_LOCAL_ROLE_PRACTITIONER = "LOCAL_ROLE_PRACTITIONER";
    public static final String PROCESS_AUTHORIZATION_VALUE_REMOTE_ROLE = "REMOTE_ROLE";
    public static final String PROCESS_AUTHORIZATION_VALUE_LOCAL_ALL = "LOCAL_ALL";
    public static final String PROCESS_AUTHORIZATION_VALUE_LOCAL_ALL_PRACTITIONER = "LOCAL_ALL_PRACTITIONER";
    public static final String PROCESS_AUTHORIZATION_VALUE_REMOTE_ALL = "REMOTE_ALL";
    public static final String ORGANIZATION_IDENTIFIER_SYSTEM = "http://dsf.dev/sid/organization-identifier";
    public static final String EXTENSION_PROCESS_AUTHORIZATION = "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_MESSAGE_NAME = "message-name";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_TASK_PROFILE = "task-profile";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_REQUESTER = "requester";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_RECIPIENT = "recipient";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_PRACTITIONER = "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-practitioner";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_ORGANIZATION = "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_ORGANIZATION_PRACTITIONER = "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization-practitioner";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_ORGANIZATION_PRACTITIONER_ORGANIZATION = "organization";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_ORGANIZATION_PRACTITIONER_PRACTITIONER_ROLE = "practitioner-role";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_PARENT_ORGANIZATION_ROLE = "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_PARENT_ORGANIZATION_ROLE_PARENT_ORGANIZATION = "parent-organization";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_PARENT_ORGANIZATION_ROLE_ORGANIZATION_ROLE = "organization-role";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_PARENT_ORGANIZATION_ROLE_PRACTITIONER = "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role-practitioner";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_PARENT_ORGANIZATION_ROLE_PRACTITIONER_PARENT_ORGANIZATION = "parent-organization";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_PARENT_ORGANIZATION_ROLE_PRACTITIONER_ORGANIZATION_ROLE = "organization-role";
    public static final String EXTENSION_PROCESS_AUTHORIZATION_PARENT_ORGANIZATION_ROLE_PRACTITIONER_PRACTITIONER_ROLE = "practitioner-role";

    public ActivityDefinition add(ActivityDefinition var1, String var2, String var3, Requester var4, Recipient var5);

    public ActivityDefinition add(ActivityDefinition var1, String var2, String var3, Collection<? extends Requester> var4, Collection<? extends Recipient> var5);

    public boolean isValid(ActivityDefinition var1, Predicate<CanonicalType> var2, Predicate<Coding> var3, Predicate<Identifier> var4, Predicate<Coding> var5);

    default public Stream<Requester> getRequesters(ActivityDefinition activityDefinition, String processUrl, String processVersion, String messageName, String taskProfile) {
        return this.getRequesters(activityDefinition, processUrl, processVersion, messageName, Collections.singleton(taskProfile));
    }

    public Stream<Requester> getRequesters(ActivityDefinition var1, String var2, String var3, String var4, Collection<String> var5);

    default public Stream<Recipient> getRecipients(ActivityDefinition activityDefinition, String processUrl, String processVersion, String messageName, String taskProfiles) {
        return this.getRecipients(activityDefinition, processUrl, processVersion, messageName, Collections.singleton(taskProfiles));
    }

    public Stream<Recipient> getRecipients(ActivityDefinition var1, String var2, String var3, String var4, Collection<String> var5);
}

