/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.OrganizationIdentity;
import dev.dsf.common.auth.conf.PractitionerIdentity;
import dev.dsf.fhir.authorization.process.Recipient;
import dev.dsf.fhir.authorization.process.Requester;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;

public class Role
implements Recipient,
Requester {
    private final boolean localIdentity;
    private final String parentOrganizationIdentifier;
    private final String organizationRoleSystem;
    private final String organizationRoleCode;
    private final String practitionerRoleSystem;
    private final String practitionerRoleCode;

    public Role(boolean localIdentity, String parentOrganizationIdentifier, String organizatioRoleSystem, String organizationRoleCode, String practitionerRoleSystem, String practitionerRoleCode) {
        Objects.requireNonNull(parentOrganizationIdentifier, "parentOrganizationIdentifier");
        if (parentOrganizationIdentifier.isBlank()) {
            throw new IllegalArgumentException("parentOrganizationIdentifier blank");
        }
        Objects.requireNonNull(organizatioRoleSystem, "organizatioRoleSystem");
        if (organizatioRoleSystem.isBlank()) {
            throw new IllegalArgumentException("organizatioRoleSystem blank");
        }
        Objects.requireNonNull(organizationRoleCode, "organizationRoleCode");
        if (organizationRoleCode.isBlank()) {
            throw new IllegalArgumentException("organizationRoleCode blank");
        }
        this.localIdentity = localIdentity;
        this.parentOrganizationIdentifier = parentOrganizationIdentifier;
        this.organizationRoleSystem = organizatioRoleSystem;
        this.organizationRoleCode = organizationRoleCode;
        this.practitionerRoleSystem = practitionerRoleSystem;
        this.practitionerRoleCode = practitionerRoleCode;
    }

    private boolean needsPractitionerRole() {
        return this.practitionerRoleSystem != null && this.practitionerRoleCode != null;
    }

    @Override
    public boolean isRequesterAuthorized(Identity requester, Stream<OrganizationAffiliation> requesterAffiliations) {
        return this.isAuthorized(requester, requesterAffiliations);
    }

    @Override
    public boolean isRecipientAuthorized(Identity recipient, Stream<OrganizationAffiliation> recipientAffiliations) {
        return this.isAuthorized(recipient, recipientAffiliations);
    }

    private boolean isAuthorized(Identity identity, Stream<OrganizationAffiliation> affiliations) {
        return identity != null && identity.getOrganization() != null && identity.getOrganization().getActive() && identity.isLocalIdentity() == this.localIdentity && affiliations != null && this.hasParentOrganizationMemberRole(identity.getOrganization(), affiliations) && (this.needsPractitionerRole() && this.hasPractitionerRole(this.getPractitionerRoles(identity)) || !this.needsPractitionerRole() && identity instanceof OrganizationIdentity);
    }

    private boolean hasParentOrganizationMemberRole(Organization recipientOrganization, Stream<OrganizationAffiliation> affiliations) {
        return affiliations.filter(OrganizationAffiliation::getActive).filter(OrganizationAffiliation::hasOrganization).filter(a -> a.getOrganization().hasIdentifier()).filter(a -> a.getOrganization().getIdentifier().hasSystem()).filter(a -> a.getOrganization().getIdentifier().hasValue()).filter(a -> "http://dsf.dev/sid/organization-identifier".equals(a.getOrganization().getIdentifier().getSystem())).filter(a -> this.parentOrganizationIdentifier.equals(a.getOrganization().getIdentifier().getValue())).filter(OrganizationAffiliation::hasParticipatingOrganization).filter(a -> a.getParticipatingOrganization().hasIdentifier()).filter(a -> a.getParticipatingOrganization().getIdentifier().hasSystem()).filter(a -> a.getParticipatingOrganization().getIdentifier().hasValue()).filter(a -> {
            Identifier memberIdentifier = a.getParticipatingOrganization().getIdentifier();
            return recipientOrganization.getIdentifier().stream().filter(Identifier::hasSystem).filter(Identifier::hasValue).anyMatch(i -> i.getSystem().equals(memberIdentifier.getSystem()) && i.getValue().equals(memberIdentifier.getValue()));
        }).filter(OrganizationAffiliation::hasCode).flatMap(a -> a.getCode().stream()).filter(CodeableConcept::hasCoding).flatMap(c -> c.getCoding().stream()).filter(Coding::hasSystem).filter(Coding::hasCode).anyMatch(c -> c.getSystem().equals(this.organizationRoleSystem) && c.getCode().equals(this.organizationRoleCode));
    }

    private Set<Coding> getPractitionerRoles(Identity identity) {
        if (identity instanceof PractitionerIdentity) {
            PractitionerIdentity p = (PractitionerIdentity)identity;
            return p.getPractionerRoles();
        }
        return Collections.emptySet();
    }

    private boolean hasPractitionerRole(Set<Coding> practitionerRoles) {
        return practitionerRoles.stream().anyMatch(c -> this.practitionerRoleSystem.equals(c.getSystem()) && this.practitionerRoleCode.equals(c.getCode()));
    }

    @Override
    public Extension toRecipientExtension() {
        return new Extension().setUrl("recipient").setValue((Type)this.toCoding(false));
    }

    @Override
    public Extension toRequesterExtension() {
        return new Extension().setUrl("requester").setValue((Type)this.toCoding(this.needsPractitionerRole()));
    }

    private Coding toCoding(boolean needsPractitionerRole) {
        Identifier parentOrganization = new Reference().getIdentifier().setSystem("http://dsf.dev/sid/organization-identifier").setValue(this.parentOrganizationIdentifier);
        Extension parentOrganizationExt = new Extension("parent-organization", (IBaseDatatype)parentOrganization);
        Coding organizationRole = new Coding(this.organizationRoleSystem, this.organizationRoleCode, null);
        Extension organizationRoleExt = new Extension("organization-role", (IBaseDatatype)organizationRole);
        Coding coding = this.getProcessAuthorizationCode();
        if (needsPractitionerRole) {
            Extension practitionerRoleExt = new Extension("practitioner-role", (IBaseDatatype)new Coding(this.practitionerRoleSystem, this.practitionerRoleCode, null));
            coding.addExtension().setUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role-practitioner").addExtension(parentOrganizationExt).addExtension(organizationRoleExt).addExtension(practitionerRoleExt);
        } else {
            coding.addExtension().setUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role").addExtension(parentOrganizationExt).addExtension(organizationRoleExt);
        }
        return coding;
    }

    @Override
    public Coding getProcessAuthorizationCode() {
        if (this.localIdentity) {
            if (this.needsPractitionerRole()) {
                return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "LOCAL_ROLE_PRACTITIONER", null);
            }
            return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "LOCAL_ROLE", null);
        }
        return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "REMOTE_ROLE", null);
    }

    @Override
    public boolean requesterMatches(Extension requesterExtension) {
        return this.matches(requesterExtension, "requester", this.needsPractitionerRole());
    }

    @Override
    public boolean recipientMatches(Extension recipientExtension) {
        return this.matches(recipientExtension, "recipient", false);
    }

    private boolean matches(Extension extension, String url, boolean needsPractitionerRole) {
        Coding value;
        Type type;
        return extension != null && url.equals(extension.getUrl()) && extension.hasValue() && (type = extension.getValue()) instanceof Coding && this.matches(value = (Coding)type) && value.hasExtension() && this.hasMatchingParentOrganizationRoleExtension(value.getExtension(), needsPractitionerRole);
    }

    private boolean hasMatchingParentOrganizationRoleExtension(List<Extension> extension, boolean needsPractitionerRole) {
        return extension.stream().anyMatch(this.parentOrganizationRoleExtensionMatches(needsPractitionerRole));
    }

    private Predicate<Extension> parentOrganizationRoleExtensionMatches(boolean needsPractitionerRole) {
        if (needsPractitionerRole) {
            return extension -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role-practitioner".equals(extension.getUrl()) && extension.hasExtension() && this.hasMatchingParentOrganizationExtension(extension.getExtension()) && this.hasMatchingOrganizationRoleExtension(extension.getExtension()) && this.hasMatchingPractitionerRoleExtension(extension.getExtension());
        }
        return extension -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role".equals(extension.getUrl()) && extension.hasExtension() && this.hasMatchingParentOrganizationExtension(extension.getExtension()) && this.hasMatchingOrganizationRoleExtension(extension.getExtension());
    }

    private boolean hasMatchingParentOrganizationExtension(List<Extension> extensions) {
        return extensions.stream().anyMatch(this::parentOrganizationExtensionMatches);
    }

    private boolean parentOrganizationExtensionMatches(Extension extension) {
        Identifier value;
        Type type;
        return "parent-organization".equals(extension.getUrl()) && extension.hasValue() && (type = extension.getValue()) instanceof Identifier && this.parentOrganizationIdentifierMatches(value = (Identifier)type);
    }

    private boolean parentOrganizationIdentifierMatches(Identifier identifier) {
        return identifier != null && identifier.hasSystem() && identifier.hasValue() && "http://dsf.dev/sid/organization-identifier".equals(identifier.getSystem()) && this.parentOrganizationIdentifier.equals(identifier.getValue());
    }

    private boolean hasMatchingOrganizationRoleExtension(List<Extension> extensions) {
        return extensions.stream().anyMatch(this::organizationRoleExtensionMatches);
    }

    private boolean organizationRoleExtensionMatches(Extension extension) {
        Coding value;
        Type type;
        return "organization-role".equals(extension.getUrl()) && extension.hasValue() && (type = extension.getValue()) instanceof Coding && this.organizationRoleMatches(value = (Coding)type);
    }

    private boolean organizationRoleMatches(Coding coding) {
        return coding != null && coding.hasSystem() && coding.hasCode() && this.organizationRoleSystem.equals(coding.getSystem()) && this.organizationRoleCode.equals(coding.getCode());
    }

    private boolean hasMatchingPractitionerRoleExtension(List<Extension> extensions) {
        return extensions.stream().anyMatch(this::practitionerRoleExtensionMatches);
    }

    private boolean practitionerRoleExtensionMatches(Extension extension) {
        Coding value;
        Type type;
        return "practitioner-role".equals(extension.getUrl()) && extension.hasValue() && (type = extension.getValue()) instanceof Coding && this.practitionerRoleMatches(value = (Coding)type);
    }

    private boolean practitionerRoleMatches(Coding coding) {
        return coding != null && coding.hasSystem() && coding.hasCode() && this.practitionerRoleSystem.equals(coding.getSystem()) && this.practitionerRoleCode.equals(coding.getCode());
    }

    @Override
    public boolean matches(Coding processAuthorizationCode) {
        if (this.localIdentity) {
            if (this.needsPractitionerRole()) {
                return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "LOCAL_ROLE_PRACTITIONER".equals(processAuthorizationCode.getCode());
            }
            return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "LOCAL_ROLE".equals(processAuthorizationCode.getCode());
        }
        return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "REMOTE_ROLE".equals(processAuthorizationCode.getCode());
    }

    public static Optional<Requester> fromRequester(Coding coding, Predicate<Coding> practitionerRoleExists, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizationRoleExists) {
        if (coding != null && coding.hasSystem() && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(coding.getSystem()) && coding.hasCode()) {
            if ("LOCAL_ROLE".equals(coding.getCode())) {
                return Role.from(true, coding, organizationWithIdentifierExists, organizationRoleExists).map(r -> r);
            }
            if ("REMOTE_ROLE".equals(coding.getCode())) {
                return Role.from(false, coding, organizationWithIdentifierExists, organizationRoleExists).map(r -> r);
            }
            if ("LOCAL_ROLE_PRACTITIONER".equals(coding.getCode())) {
                return Role.fromPractitionerRequester(coding, practitionerRoleExists, organizationWithIdentifierExists, organizationRoleExists);
            }
        }
        return Optional.empty();
    }

    public static Optional<Recipient> fromRecipient(Coding coding, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizationRoleExists) {
        if (coding != null && coding.hasSystem() && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(coding.getSystem()) && coding.hasCode() && "LOCAL_ROLE".equals(coding.getCode())) {
            return Role.from(true, coding, organizationWithIdentifierExists, organizationRoleExists).map(r -> r);
        }
        return Optional.empty();
    }

    private static Optional<Role> from(boolean localIdentity, Coding coding, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizationRoleExists) {
        List parentOrganizationRoles;
        if (coding != null && coding.hasExtension() && (parentOrganizationRoles = coding.getExtension().stream().filter(Extension::hasUrl).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role".equals(e.getUrl())).collect(Collectors.toList())).size() == 1) {
            Extension parentOrganizationRole = (Extension)parentOrganizationRoles.get(0);
            List parentOrganizations = parentOrganizationRole.getExtension().stream().filter(Extension::hasUrl).filter(e -> "parent-organization".equals(e.getUrl())).collect(Collectors.toList());
            List organizationRoles = parentOrganizationRole.getExtension().stream().filter(Extension::hasUrl).filter(e -> "organization-role".equals(e.getUrl())).collect(Collectors.toList());
            if (parentOrganizations.size() == 1 && organizationRoles.size() == 1) {
                Type type;
                Extension parentOrganization = (Extension)parentOrganizations.get(0);
                Extension organizationRole = (Extension)organizationRoles.get(0);
                if (parentOrganization.hasValue() && (type = parentOrganization.getValue()) instanceof Identifier) {
                    Identifier parentOrganizationIdentifier = (Identifier)type;
                    if (organizationRole.hasValue() && (type = organizationRole.getValue()) instanceof Coding) {
                        Coding organizationRoleCoding = (Coding)type;
                        if ("http://dsf.dev/sid/organization-identifier".equals(parentOrganizationIdentifier.getSystem()) && organizationWithIdentifierExists.test(parentOrganizationIdentifier) && organizationRoleExists.test(organizationRoleCoding)) {
                            return Optional.of(new Role(localIdentity, parentOrganizationIdentifier.getValue(), organizationRoleCoding.getSystem(), organizationRoleCoding.getCode(), null, null));
                        }
                    }
                }
            }
        }
        return Optional.empty();
    }

    private static Optional<Requester> fromPractitionerRequester(Coding coding, Predicate<Coding> practitionerRoleExists, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizationRoleExists) {
        List parentOrganizationRolePractitioners;
        if (coding != null && coding.hasExtension() && (parentOrganizationRolePractitioners = coding.getExtension().stream().filter(Extension::hasUrl).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-parent-organization-role-practitioner".equals(e.getUrl())).collect(Collectors.toList())).size() == 1) {
            Extension parentOrganizationRolePractitioner = (Extension)parentOrganizationRolePractitioners.get(0);
            List parentOrganizations = parentOrganizationRolePractitioner.getExtension().stream().filter(Extension::hasUrl).filter(e -> "parent-organization".equals(e.getUrl())).collect(Collectors.toList());
            List organizationRoles = parentOrganizationRolePractitioner.getExtension().stream().filter(Extension::hasUrl).filter(e -> "organization-role".equals(e.getUrl())).collect(Collectors.toList());
            List practitionerRoles = parentOrganizationRolePractitioner.getExtension().stream().filter(Extension::hasUrl).filter(e -> "practitioner-role".equals(e.getUrl())).collect(Collectors.toList());
            if (parentOrganizations.size() == 1 && organizationRoles.size() == 1 && practitionerRoles.size() == 1) {
                Type type;
                Extension parentOrganization = (Extension)parentOrganizations.get(0);
                Extension organizationRole = (Extension)organizationRoles.get(0);
                Extension practitionerRole = (Extension)practitionerRoles.get(0);
                if (parentOrganization.hasValue() && (type = parentOrganization.getValue()) instanceof Identifier) {
                    Identifier parentOrganizationIdentifier = (Identifier)type;
                    if (organizationRole.hasValue() && (type = organizationRole.getValue()) instanceof Coding) {
                        Coding organizationRoleCoding = (Coding)type;
                        if (practitionerRole.hasValue() && (type = practitionerRole.getValue()) instanceof Coding) {
                            Coding practitionerRoleCoding = (Coding)type;
                            if ("http://dsf.dev/sid/organization-identifier".equals(parentOrganizationIdentifier.getSystem()) && organizationWithIdentifierExists.test(parentOrganizationIdentifier) && organizationRoleExists.test(organizationRoleCoding) && practitionerRoleExists.test(practitionerRoleCoding)) {
                                return Optional.of(new Role(true, parentOrganizationIdentifier.getValue(), organizationRoleCoding.getSystem(), organizationRoleCoding.getCode(), practitionerRoleCoding.getSystem(), practitionerRoleCoding.getCode()));
                            }
                        }
                    }
                }
            }
        }
        return Optional.empty();
    }
}

