/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authorization.process.All;
import dev.dsf.fhir.authorization.process.Organization;
import dev.dsf.fhir.authorization.process.Role;
import dev.dsf.fhir.authorization.process.WithAuthorization;
import java.util.Collection;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.OrganizationAffiliation;

public interface Requester
extends WithAuthorization {
    public static Requester localAll() {
        return Requester.all(true, null, null);
    }

    public static Requester localAllPractitioner(String practitionerRoleSystem, String practitionerRoleCode) {
        return Requester.all(true, practitionerRoleSystem, practitionerRoleCode);
    }

    public static Requester remoteAll() {
        return Requester.all(false, null, null);
    }

    public static Requester all(boolean localIdentity, String userRoleSystem, String userRoleCode) {
        return new All(localIdentity, userRoleSystem, userRoleCode);
    }

    public static Requester localOrganization(String organizationIdentifier) {
        return Requester.organization(true, organizationIdentifier, null, null);
    }

    public static Requester localOrganizationPractitioner(String organizationIdentifier, String practitionerRoleSystem, String practitionerRoleCode) {
        return Requester.organization(true, organizationIdentifier, practitionerRoleSystem, practitionerRoleCode);
    }

    public static Requester remoteOrganization(String organizationIdentifier) {
        return Requester.organization(false, organizationIdentifier, null, null);
    }

    public static Requester organization(boolean localIdentity, String organizationIdentifier, String practitionerRoleSystem, String practitionerRoleCode) {
        return new Organization(localIdentity, organizationIdentifier, practitionerRoleSystem, practitionerRoleCode);
    }

    public static Requester localRole(String parentOrganizationIdentifier, String organizatioRoleSystem, String organizatioRoleCode) {
        return Requester.role(true, parentOrganizationIdentifier, organizatioRoleSystem, organizatioRoleCode, null, null);
    }

    public static Requester localRolePractitioner(String parentOrganizationIdentifier, String organizatioRoleSystem, String organizatioRoleCode, String practitionerRoleSystem, String practitionerRoleCode) {
        return Requester.role(true, parentOrganizationIdentifier, organizatioRoleSystem, organizatioRoleCode, practitionerRoleSystem, practitionerRoleCode);
    }

    public static Requester remoteRole(String parentOrganizationIdentifier, String organizatioRoleSystem, String organizatioRoleCode) {
        return Requester.role(false, parentOrganizationIdentifier, organizatioRoleSystem, organizatioRoleCode, null, null);
    }

    public static Requester role(boolean localIdentity, String parentOrganizationIdentifier, String organizatioRoleSystem, String organizatioRoleCode, String practitionerRoleSystem, String practitionerRoleCode) {
        return new Role(localIdentity, parentOrganizationIdentifier, organizatioRoleSystem, organizatioRoleCode, practitionerRoleSystem, practitionerRoleCode);
    }

    public boolean requesterMatches(Extension var1);

    public boolean isRequesterAuthorized(Identity var1, Stream<OrganizationAffiliation> var2);

    default public boolean isRequesterAuthorized(Identity requesterUser, Collection<OrganizationAffiliation> requesterAffiliations) {
        return this.isRequesterAuthorized(requesterUser, requesterAffiliations == null ? null : requesterAffiliations.stream());
    }

    public Extension toRequesterExtension();
}

