/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.fhir.authorization.process.All;
import dev.dsf.fhir.authorization.process.Organization;
import dev.dsf.fhir.authorization.process.ProcessAuthorizationHelper;
import dev.dsf.fhir.authorization.process.Recipient;
import dev.dsf.fhir.authorization.process.Requester;
import dev.dsf.fhir.authorization.process.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class ProcessAuthorizationHelperImpl
implements ProcessAuthorizationHelper {
    @Override
    public ActivityDefinition add(ActivityDefinition activityDefinition, String messageName, String taskProfile, Requester requester, Recipient recipient) {
        Objects.requireNonNull(activityDefinition, "activityDefinition");
        Objects.requireNonNull(messageName, "messageName");
        if (messageName.isBlank()) {
            throw new IllegalArgumentException("messageName blank");
        }
        Objects.requireNonNull(taskProfile, "taskProfile");
        if (taskProfile.isBlank()) {
            throw new IllegalArgumentException("taskProfile blank");
        }
        Objects.requireNonNull(requester, "requester");
        Objects.requireNonNull(recipient, "recipient");
        Extension extension = this.getExtensionByMessageNameAndTaskProfile(activityDefinition, messageName, taskProfile);
        if (!this.hasAuthorization(extension, requester)) {
            extension.addExtension(requester.toRequesterExtension());
        }
        if (!this.hasAuthorization(extension, recipient)) {
            extension.addExtension(recipient.toRecipientExtension());
        }
        return activityDefinition;
    }

    @Override
    public ActivityDefinition add(ActivityDefinition activityDefinition, String messageName, String taskProfile, Collection<? extends Requester> requesters, Collection<? extends Recipient> recipients) {
        Objects.requireNonNull(activityDefinition, "activityDefinition");
        Objects.requireNonNull(messageName, "messageName");
        if (messageName.isBlank()) {
            throw new IllegalArgumentException("messageName blank");
        }
        Objects.requireNonNull(taskProfile, "taskProfile");
        if (taskProfile.isBlank()) {
            throw new IllegalArgumentException("taskProfile blank");
        }
        Objects.requireNonNull(requesters, "requesters");
        if (requesters.isEmpty()) {
            throw new IllegalArgumentException("requesters empty");
        }
        Objects.requireNonNull(recipients, "recipients");
        if (recipients.isEmpty()) {
            throw new IllegalArgumentException("recipients empty");
        }
        Extension extension = this.getExtensionByMessageNameAndTaskProfile(activityDefinition, messageName, taskProfile);
        requesters.stream().filter(r -> !this.hasAuthorization(extension, (Requester)r)).forEach(r -> extension.addExtension(r.toRequesterExtension()));
        recipients.stream().filter(r -> !this.hasAuthorization(extension, (Recipient)r)).forEach(r -> extension.addExtension(r.toRecipientExtension()));
        return activityDefinition;
    }

    private Extension getExtensionByMessageNameAndTaskProfile(ActivityDefinition a, String messageName, String taskProfile) {
        return a.getExtension().stream().filter(Extension::hasUrl).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization".equals(e.getUrl())).filter(Element::hasExtension).filter(e -> this.hasMessageName((Extension)e, messageName) && this.hasTaskProfileExact((Extension)e, taskProfile)).findFirst().orElseGet(() -> {
            Extension e = this.newExtension(messageName, taskProfile);
            a.addExtension(e);
            return e;
        });
    }

    private boolean hasMessageName(Extension processAuthorization, String messageName) {
        return processAuthorization.getExtension().stream().filter(Extension::hasUrl).filter(e -> "message-name".equals(e.getUrl())).filter(Extension::hasValue).filter(e -> e.getValue() instanceof StringType).map(e -> (StringType)e.getValue()).anyMatch(s -> messageName.equals(s.getValueAsString()));
    }

    private boolean hasTaskProfileExact(Extension processAuthorization, String taskProfile) {
        return processAuthorization.getExtension().stream().filter(Extension::hasUrl).filter(e -> "task-profile".equals(e.getUrl())).filter(Extension::hasValue).filter(e -> e.getValue() instanceof CanonicalType).map(e -> (CanonicalType)e.getValue()).anyMatch(c -> taskProfile.equals(c.getValueAsString()));
    }

    private Extension newExtension(String messageName, String taskProfile) {
        Extension e = new Extension("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization");
        e.addExtension(this.newMessageName(messageName));
        e.addExtension(this.newTaskProfile(taskProfile));
        return e;
    }

    private Extension newMessageName(String messageName) {
        return new Extension("message-name").setValue((Type)new StringType(messageName));
    }

    private Extension newTaskProfile(String taskProfile) {
        return new Extension("task-profile").setValue((Type)new CanonicalType(taskProfile));
    }

    private boolean hasAuthorization(Extension processAuthorization, Requester authorization) {
        return processAuthorization.getExtension().stream().anyMatch(authorization::requesterMatches);
    }

    private boolean hasAuthorization(Extension processAuthorization, Recipient authorization) {
        return processAuthorization.getExtension().stream().anyMatch(authorization::recipientMatches);
    }

    @Override
    public boolean isValid(ActivityDefinition activityDefinition, Predicate<CanonicalType> profileExists, Predicate<Coding> practitionerRoleExists, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizationRoleExists) {
        if (activityDefinition == null) {
            return false;
        }
        List<Extension> processAuthorizations = activityDefinition.getExtension().stream().filter(Extension::hasUrl).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization".equals(e.getUrl())).collect(Collectors.toList());
        if (processAuthorizations.isEmpty()) {
            return false;
        }
        return processAuthorizations.stream().map(e -> this.isProcessAuthorizationValid((Extension)e, profileExists, practitionerRoleExists, organizationWithIdentifierExists, organizationRoleExists)).allMatch(v -> v) && this.messageNamesUnique(processAuthorizations);
    }

    private boolean messageNamesUnique(List<Extension> processAuthorizations) {
        return (long)processAuthorizations.size() == processAuthorizations.stream().flatMap(e -> e.getExtension().stream().filter(mn -> "message-name".equals(mn.getUrl())).map(Extension::getValue).map(v -> (StringType)v).map(PrimitiveType::getValueAsString).findFirst().stream()).distinct().count();
    }

    private boolean isProcessAuthorizationValid(Extension processAuthorization, Predicate<CanonicalType> profileExists, Predicate<Coding> practitionerRoleExists, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizationRoleExists) {
        if (processAuthorization == null || !"http://dsf.dev/fhir/StructureDefinition/extension-process-authorization".equals(processAuthorization.getUrl()) || !processAuthorization.hasExtension()) {
            return false;
        }
        ArrayList<Extension> messageNames = new ArrayList<Extension>();
        ArrayList<Extension> taskProfiles = new ArrayList<Extension>();
        ArrayList<Extension> requesters = new ArrayList<Extension>();
        ArrayList<Extension> recipients = new ArrayList<Extension>();
        for (Extension extension : processAuthorization.getExtension()) {
            if (!extension.hasUrl()) continue;
            switch (extension.getUrl()) {
                case "message-name": {
                    messageNames.add(extension);
                    break;
                }
                case "task-profile": {
                    taskProfiles.add(extension);
                    break;
                }
                case "requester": {
                    requesters.add(extension);
                    break;
                }
                case "recipient": {
                    recipients.add(extension);
                }
            }
        }
        if (messageNames.size() != 1 || taskProfiles.size() != 1 || requesters.isEmpty() || recipients.isEmpty()) {
            return false;
        }
        return this.isMessageNameValid((Extension)messageNames.get(0)) && this.isTaskProfileValid((Extension)taskProfiles.get(0), profileExists) && this.isRequestersValid(requesters, practitionerRoleExists, organizationWithIdentifierExists, organizationRoleExists) && this.isRecipientsValid(recipients, organizationWithIdentifierExists, organizationRoleExists);
    }

    private boolean isMessageNameValid(Extension messageName) {
        StringType value;
        Type type;
        if (messageName == null || !"message-name".equals(messageName.getUrl())) {
            return false;
        }
        return messageName.hasValue() && (type = messageName.getValue()) instanceof StringType && !(value = (StringType)type).getValueAsString().isBlank();
    }

    private boolean isTaskProfileValid(Extension taskProfile, Predicate<CanonicalType> profileExists) {
        CanonicalType value;
        Type type;
        if (taskProfile == null || !"task-profile".equals(taskProfile.getUrl())) {
            return false;
        }
        return taskProfile.hasValue() && (type = taskProfile.getValue()) instanceof CanonicalType && profileExists.test(value = (CanonicalType)type);
    }

    private boolean isRequestersValid(List<Extension> requesters, Predicate<Coding> practitionerRoleExists, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizationRoleExists) {
        return requesters.stream().allMatch(r -> this.isRequesterValid((Extension)r, practitionerRoleExists, organizationWithIdentifierExists, organizationRoleExists));
    }

    private boolean isRequesterValid(Extension requester, Predicate<Coding> practitionerRoleExists, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizationRoleExists) {
        Type type;
        if (requester == null || !"requester".equals(requester.getUrl())) {
            return false;
        }
        if (requester.hasValue() && (type = requester.getValue()) instanceof Coding) {
            Coding value = (Coding)type;
            return this.requesterFrom(value, practitionerRoleExists, organizationWithIdentifierExists, organizationRoleExists).isPresent();
        }
        return false;
    }

    private Optional<Requester> requesterFrom(Coding coding, Predicate<Coding> practitionerRoleExists, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizatioRoleExists) {
        switch (coding.getCode()) {
            case "LOCAL_ALL": 
            case "LOCAL_ALL_PRACTITIONER": 
            case "REMOTE_ALL": {
                return All.fromRequester(coding, practitionerRoleExists);
            }
            case "LOCAL_ORGANIZATION": 
            case "LOCAL_ORGANIZATION_PRACTITIONER": 
            case "REMOTE_ORGANIZATION": {
                return Organization.fromRequester(coding, practitionerRoleExists, organizationWithIdentifierExists);
            }
            case "LOCAL_ROLE": 
            case "LOCAL_ROLE_PRACTITIONER": 
            case "REMOTE_ROLE": {
                return Role.fromRequester(coding, practitionerRoleExists, organizationWithIdentifierExists, organizatioRoleExists);
            }
        }
        return Optional.empty();
    }

    private boolean isRecipientsValid(List<Extension> recipients, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizationRoleExists) {
        return recipients.stream().allMatch(r -> this.isRecipientValid((Extension)r, organizationWithIdentifierExists, organizationRoleExists));
    }

    private boolean isRecipientValid(Extension recipient, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizationRoleExists) {
        Type type;
        if (recipient == null || !"recipient".equals(recipient.getUrl())) {
            return false;
        }
        if (recipient.hasValue() && (type = recipient.getValue()) instanceof Coding) {
            Coding value = (Coding)type;
            return this.recipientFrom(value, organizationWithIdentifierExists, organizationRoleExists).isPresent();
        }
        return false;
    }

    private Optional<Recipient> recipientFrom(Coding coding, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> organizationRoleExists) {
        switch (coding.getCode()) {
            case "LOCAL_ALL": {
                return All.fromRecipient(coding);
            }
            case "LOCAL_ORGANIZATION": {
                return Organization.fromRecipient(coding, organizationWithIdentifierExists);
            }
            case "LOCAL_ROLE": {
                return Role.fromRecipient(coding, organizationWithIdentifierExists, organizationRoleExists);
            }
        }
        return Optional.empty();
    }

    @Override
    public Stream<Requester> getRequesters(ActivityDefinition activityDefinition, String processUrl, String processVersion, String messageName, Collection<String> taskProfiles) {
        Optional<Extension> authorizationExtension = this.getAuthorizationExtension(activityDefinition, processUrl, processVersion, messageName, taskProfiles);
        if (authorizationExtension.isEmpty()) {
            return Stream.empty();
        }
        return authorizationExtension.get().getExtension().stream().filter(Extension::hasUrl).filter(e -> "requester".equals(e.getUrl())).filter(Extension::hasValue).filter(e -> e.getValue() instanceof Coding).map(e -> (Coding)e.getValue()).flatMap(coding -> this.requesterFrom((Coding)coding, c -> true, i -> true, c -> true).stream());
    }

    @Override
    public Stream<Recipient> getRecipients(ActivityDefinition activityDefinition, String processUrl, String processVersion, String messageName, Collection<String> taskProfiles) {
        Optional<Extension> authorizationExtension = this.getAuthorizationExtension(activityDefinition, processUrl, processVersion, messageName, taskProfiles);
        if (authorizationExtension.isEmpty()) {
            return Stream.empty();
        }
        return authorizationExtension.get().getExtension().stream().filter(Extension::hasUrl).filter(e -> "recipient".equals(e.getUrl())).filter(Extension::hasValue).filter(e -> e.getValue() instanceof Coding).map(e -> (Coding)e.getValue()).flatMap(coding -> this.recipientFrom((Coding)coding, i -> true, c -> true).stream());
    }

    private Optional<Extension> getAuthorizationExtension(ActivityDefinition activityDefinition, String processUrl, String processVersion, String messageName, Collection<String> taskProfiles) {
        if (activityDefinition == null || processUrl == null || processUrl.isBlank() || processVersion == null || processVersion.isBlank() || messageName == null || messageName.isBlank() || taskProfiles == null) {
            return Optional.empty();
        }
        if (!processUrl.equals(activityDefinition.getUrl()) || !processVersion.equals(activityDefinition.getVersion())) {
            return Optional.empty();
        }
        Optional<Extension> authorizationExtension = activityDefinition.getExtension().stream().filter(Extension::hasUrl).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization".equals(e.getUrl())).filter(Element::hasExtension).filter(e -> this.hasMessageName((Extension)e, messageName) && this.hasTaskProfile((Extension)e, taskProfiles)).findFirst();
        return authorizationExtension;
    }

    private boolean hasTaskProfile(Extension processAuthorization, Collection<String> taskProfiles) {
        return taskProfiles.stream().anyMatch(taskProfile -> this.hasTaskProfileNotVersionSpecific(processAuthorization, (String)taskProfile));
    }

    private boolean hasTaskProfileNotVersionSpecific(Extension processAuthorization, String taskProfile) {
        return processAuthorization.getExtension().stream().filter(Extension::hasUrl).filter(e -> "task-profile".equals(e.getUrl())).filter(Extension::hasValue).filter(e -> e.getValue() instanceof CanonicalType).map(e -> (CanonicalType)e.getValue()).anyMatch(c -> taskProfile.equals(c.getValueAsString()) || taskProfile.equals(ProcessAuthorizationHelperImpl.getBase(c.getValueAsString())));
    }

    private static String getBase(String canonicalUrl) {
        if (canonicalUrl.contains("|")) {
            String[] split = canonicalUrl.split("\\|");
            return split[0];
        }
        return canonicalUrl;
    }
}

