/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.read;

import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Type;

public class ReadAccessHelperImpl
implements ReadAccessHelper {
    private static final List<String> READ_ACCESS_TAG_VALUES = Arrays.asList("LOCAL", "ORGANIZATION", "ROLE", "ALL");

    private Predicate<Coding> matchesTagValue(String value) {
        return c -> c != null && "http://dsf.dev/fhir/CodeSystem/read-access-tag".equals(c.getSystem()) && c.hasCode() && c.getCode().equals(value);
    }

    @Override
    public <R extends Resource> R addLocal(R resource) {
        if (resource == null) {
            return null;
        }
        resource.getMeta().getTag().removeIf(this.matchesTagValue("ALL"));
        resource.getMeta().addTag().setSystem("http://dsf.dev/fhir/CodeSystem/read-access-tag").setCode("LOCAL");
        return resource;
    }

    @Override
    public <R extends Resource> R addOrganization(R resource, String organizationIdentifier) {
        if (resource == null) {
            return null;
        }
        Objects.requireNonNull(organizationIdentifier, "organizationIdentifier");
        if (resource.getMeta().getTag().stream().noneMatch(this.matchesTagValue("LOCAL"))) {
            this.addLocal(resource);
        }
        resource.getMeta().addTag().setSystem("http://dsf.dev/fhir/CodeSystem/read-access-tag").setCode("ORGANIZATION").addExtension().setUrl("http://dsf.dev/fhir/StructureDefinition/extension-read-access-organization").setValue((Type)new Identifier().setSystem("http://dsf.dev/sid/organization-identifier").setValue(organizationIdentifier));
        return resource;
    }

    @Override
    public <R extends Resource> R addOrganization(R resource, Organization organization) {
        if (resource == null) {
            return null;
        }
        Objects.requireNonNull(organization, "organization");
        if (!organization.hasIdentifier()) {
            throw new IllegalArgumentException("organization has no identifier");
        }
        Optional<String> identifierValue = organization.getIdentifier().stream().filter(Identifier::hasSystem).filter(i -> "http://dsf.dev/sid/organization-identifier".equals(i.getSystem())).filter(Identifier::hasValue).map(Identifier::getValue).filter(v -> !v.isBlank()).findFirst();
        return this.addOrganization(resource, identifierValue.orElseThrow(() -> new IllegalArgumentException("organization has no non blank identifier value with system http://dsf.dev/sid/organization-identifier")));
    }

    @Override
    public <R extends Resource> R addRole(R resource, String consortiumIdentifier, String roleSystem, String roleCode) {
        if (resource == null) {
            return null;
        }
        Objects.requireNonNull(consortiumIdentifier, "consortiumIdentifier");
        Objects.requireNonNull(roleSystem, "roleSystem");
        Objects.requireNonNull(roleCode, "roleCode");
        if (resource.getMeta().getTag().stream().noneMatch(this.matchesTagValue("LOCAL"))) {
            this.addLocal(resource);
        }
        Extension ex = resource.getMeta().addTag().setSystem("http://dsf.dev/fhir/CodeSystem/read-access-tag").setCode("ROLE").addExtension().setUrl("http://dsf.dev/fhir/StructureDefinition/extension-read-access-consortium-role");
        ex.addExtension().setUrl("consortium").setValue((Type)new Identifier().setSystem("http://dsf.dev/sid/organization-identifier").setValue(consortiumIdentifier));
        ex.addExtension().setUrl("role").setValue((Type)new Coding().setSystem(roleSystem).setCode(roleCode));
        return resource;
    }

    @Override
    public <R extends Resource> R addRole(R resource, OrganizationAffiliation affiliation) {
        if (resource == null) {
            return null;
        }
        Objects.requireNonNull(affiliation, "affiliation");
        if (!affiliation.hasOrganization()) {
            throw new IllegalArgumentException("affiliation has no consortium reference");
        }
        if (!affiliation.getOrganization().hasIdentifier()) {
            throw new IllegalArgumentException("affiliation has no consortium reference with identifier");
        }
        if (!affiliation.getOrganization().getIdentifier().hasSystem() || !"http://dsf.dev/sid/organization-identifier".equals(affiliation.getOrganization().getIdentifier().getSystem())) {
            throw new IllegalArgumentException("affiliation has no consortium reference with identifier system http://dsf.dev/sid/organization-identifier");
        }
        if (!affiliation.getOrganization().getIdentifier().hasValue() || affiliation.getOrganization().getIdentifier().getValue().isBlank()) {
            throw new IllegalArgumentException("affiliation has no consortium reference with non blank identifier value");
        }
        String consortiumIdentifier = affiliation.getOrganization().getIdentifier().getValue();
        if (!(affiliation.hasCode() && affiliation.getCode().size() == 1 && affiliation.getCodeFirstRep().hasCoding() && affiliation.getCodeFirstRep().getCoding().size() == 1 && affiliation.getCodeFirstRep().getCodingFirstRep().hasCode() && affiliation.getCodeFirstRep().getCodingFirstRep().hasSystem())) {
            throw new IllegalArgumentException("affiliation has no single member role with code and system");
        }
        String roleSystem = affiliation.getCodeFirstRep().getCodingFirstRep().getSystem();
        String roleCode = affiliation.getCodeFirstRep().getCodingFirstRep().getCode();
        return this.addRole(resource, consortiumIdentifier, roleSystem, roleCode);
    }

    @Override
    public <R extends Resource> R addAll(R resource) {
        if (resource == null) {
            return null;
        }
        resource.getMeta().getTag().removeIf(this.matchesTagValue("LOCAL").or(this.matchesTagValue("ORGANIZATION")).or(this.matchesTagValue("ROLE")));
        resource.getMeta().addTag().setSystem("http://dsf.dev/fhir/CodeSystem/read-access-tag").setCode("ALL");
        return resource;
    }

    @Override
    public boolean hasLocal(Resource resource) {
        if (resource == null || !resource.hasMeta() || !resource.getMeta().hasTag()) {
            return false;
        }
        return resource.getMeta().getTag("http://dsf.dev/fhir/CodeSystem/read-access-tag", "LOCAL") != null;
    }

    @Override
    public boolean hasOrganization(Resource resource, String organizationIdentifier) {
        if (resource == null || !resource.hasMeta() || !resource.getMeta().hasTag()) {
            return false;
        }
        Stream<Extension> extensions = this.getTagExtensions(resource, "http://dsf.dev/fhir/CodeSystem/read-access-tag", "ORGANIZATION", "http://dsf.dev/fhir/StructureDefinition/extension-read-access-organization");
        return extensions.filter(Extension::hasValue).map(Extension::getValue).filter(v -> v instanceof Identifier).map(v -> (Identifier)v).filter(Identifier::hasValue).anyMatch(i -> Objects.equals(i.getValue(), organizationIdentifier));
    }

    @Override
    public boolean hasOrganization(Resource resource, Organization organization) {
        if (resource == null || organization == null) {
            return false;
        }
        return organization.hasIdentifier() && organization.getIdentifier().stream().filter(Identifier::hasSystem).filter(i -> "http://dsf.dev/sid/organization-identifier".equals(i.getSystem())).filter(Identifier::hasValue).map(Identifier::getValue).anyMatch(identifier -> this.hasOrganization(resource, (String)identifier));
    }

    private Stream<Extension> getTagExtensions(Resource resource, String tagSystem, String tagCode, String extensionUrl) {
        return resource.getMeta().getTag().stream().filter(c -> Objects.equals(c.getSystem(), tagSystem)).filter(c -> Objects.equals(c.getCode(), tagCode)).filter(Element::hasExtension).flatMap(c -> c.getExtension().stream()).filter(e -> Objects.equals(e.getUrl(), extensionUrl));
    }

    @Override
    public boolean hasAnyOrganization(Resource resource) {
        if (resource == null || !resource.hasMeta() || !resource.getMeta().hasTag()) {
            return false;
        }
        return resource.getMeta().getTag("http://dsf.dev/fhir/CodeSystem/read-access-tag", "ORGANIZATION") != null;
    }

    @Override
    public boolean hasRole(Resource resource, String consortiumIdentifier, String roleSystem, String roleCode) {
        if (resource == null || !resource.hasMeta() || !resource.getMeta().hasTag()) {
            return false;
        }
        Stream<Extension> extensions = this.getTagExtensions(resource, "http://dsf.dev/fhir/CodeSystem/read-access-tag", "ROLE", "http://dsf.dev/fhir/StructureDefinition/extension-read-access-consortium-role");
        return extensions.filter(Element::hasExtension).anyMatch(this.matches(consortiumIdentifier, roleSystem, roleCode));
    }

    @Override
    public boolean hasRole(Resource resource, List<OrganizationAffiliation> affiliations) {
        if (affiliations == null || affiliations.isEmpty()) {
            return false;
        }
        return affiliations.stream().anyMatch(affiliation -> this.hasRole(resource, (OrganizationAffiliation)affiliation));
    }

    private Predicate<? super Extension> matches(String consortiumIdentifier, String roleSystem, String roleCode) {
        return extensions -> {
            boolean cor = extensions.getExtension().stream().filter(Extension::hasUrl).filter(e -> Objects.equals(e.getUrl(), "consortium")).filter(Extension::hasValue).map(Extension::getValue).filter(v -> v instanceof Identifier).map(v -> (Identifier)v).filter(Identifier::hasSystem).filter(Identifier::hasValue).anyMatch(i -> "http://dsf.dev/sid/organization-identifier".equals(i.getSystem()) && Objects.equals(i.getValue(), consortiumIdentifier));
            boolean role = extensions.getExtension().stream().filter(Extension::hasUrl).filter(e -> Objects.equals(e.getUrl(), "role")).filter(Extension::hasValue).map(Extension::getValue).filter(v -> v instanceof Coding).map(v -> (Coding)v).anyMatch(c -> Objects.equals(c.getSystem(), roleSystem) && Objects.equals(c.getCode(), roleCode));
            return cor && role;
        };
    }

    @Override
    public boolean hasRole(Resource resource, OrganizationAffiliation affiliation) {
        if (resource == null || affiliation == null || !affiliation.hasOrganization() || !affiliation.hasCode()) {
            return false;
        }
        Reference consortiumRef = affiliation.getOrganization();
        if (!consortiumRef.hasIdentifier()) {
            return false;
        }
        Identifier consortiumId = consortiumRef.getIdentifier();
        if (!consortiumId.hasValue()) {
            return false;
        }
        String consortiumIdentifier = consortiumRef.getIdentifier().getValue();
        return affiliation.getCode().stream().filter(CodeableConcept::hasCoding).flatMap(c -> c.getCoding().stream()).filter(Coding::hasSystem).filter(Coding::hasCode).anyMatch(c -> this.hasRole(resource, consortiumIdentifier, c.getSystem(), c.getCode()));
    }

    @Override
    public boolean hasAnyRole(Resource resource) {
        if (resource == null || !resource.hasMeta() || !resource.getMeta().hasTag()) {
            return false;
        }
        return resource.getMeta().getTag("http://dsf.dev/fhir/CodeSystem/read-access-tag", "ROLE") != null;
    }

    @Override
    public boolean hasAll(Resource resource) {
        if (resource == null || !resource.hasMeta() || !resource.getMeta().hasTag()) {
            return false;
        }
        return resource.getMeta().getTag("http://dsf.dev/fhir/CodeSystem/read-access-tag", "ALL") != null;
    }

    @Override
    public boolean isValid(Resource resource) {
        return this.isValid(resource, organizationIdentifier -> true, role -> true);
    }

    @Override
    public boolean isValid(Resource resource, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> roleExists) {
        if (resource == null || !resource.hasMeta() || !resource.getMeta().hasTag()) {
            return false;
        }
        long tagsCount = resource.getMeta().getTag().stream().filter(Coding::hasSystem).filter(Coding::hasCode).filter(c -> "http://dsf.dev/fhir/CodeSystem/read-access-tag".equals(c.getSystem())).filter(c -> READ_ACCESS_TAG_VALUES.contains(c.getCode())).count();
        boolean local = resource.getMeta().getTag().stream().filter(Coding::hasSystem).filter(Coding::hasCode).filter(c -> "http://dsf.dev/fhir/CodeSystem/read-access-tag".equals(c.getSystem())).filter(c -> "LOCAL".equals(c.getCode())).count() == 1L;
        boolean all = resource.getMeta().getTag().stream().filter(Coding::hasSystem).filter(Coding::hasCode).filter(c -> "http://dsf.dev/fhir/CodeSystem/read-access-tag".equals(c.getSystem())).filter(c -> "ALL".equals(c.getCode())).count() == 1L;
        boolean tagsValid = resource.getMeta().getTag().stream().filter(Coding::hasSystem).filter(Coding::hasCode).filter(c -> "http://dsf.dev/fhir/CodeSystem/read-access-tag".equals(c.getSystem())).filter(c -> READ_ACCESS_TAG_VALUES.contains(c.getCode())).allMatch(this.isValidReadAccessTag(organizationWithIdentifierExists, roleExists));
        return (local && tagsCount >= 1L) ^ (all && tagsCount == 1L) && tagsValid;
    }

    private Predicate<Coding> isValidReadAccessTag(Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> roleExists) {
        return coding -> {
            switch (coding.getCode()) {
                case "LOCAL": {
                    return true;
                }
                case "ORGANIZATION": {
                    return this.isValidOrganizationReadAccessTag((Coding)coding, organizationWithIdentifierExists);
                }
                case "ROLE": {
                    return this.isValidRoleReadAccessTag((Coding)coding, organizationWithIdentifierExists, roleExists);
                }
                case "ALL": {
                    return true;
                }
            }
            return false;
        };
    }

    private boolean isValidOrganizationReadAccessTag(Coding coding, Predicate<Identifier> organizationWithIdentifierExists) {
        List exts = coding.getExtension().stream().filter(e -> e.hasUrl()).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-read-access-organization".equals(e.getUrl())).collect(Collectors.toList());
        return coding.hasExtension() && exts.size() == 1 && this.isValidExtensionReadAccesOrganization((Extension)exts.get(0), organizationWithIdentifierExists);
    }

    private boolean isValidExtensionReadAccesOrganization(Extension extension, Predicate<Identifier> organizationWithIdentifierExists) {
        return extension.hasValue() && extension.getValue() instanceof Identifier && this.isValidOrganizationIdentifier((Identifier)extension.getValue(), organizationWithIdentifierExists);
    }

    private boolean isValidOrganizationIdentifier(Identifier identifier, Predicate<Identifier> organizationWithIdentifierExists) {
        return identifier.hasSystem() && "http://dsf.dev/sid/organization-identifier".equals(identifier.getSystem()) && identifier.hasValue() && organizationWithIdentifierExists.test(identifier);
    }

    private boolean isValidRoleReadAccessTag(Coding coding, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> roleExists) {
        List exts = coding.getExtension().stream().filter(e -> e.hasUrl()).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-read-access-consortium-role".equals(e.getUrl())).collect(Collectors.toList());
        return coding.hasExtension() && exts.size() == 1 && this.isValidExtensionReadAccessConsortiumMemberRole((Extension)exts.get(0), organizationWithIdentifierExists, roleExists);
    }

    private boolean isValidExtensionReadAccessConsortiumMemberRole(Extension extension, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> roleExists) {
        return extension.hasExtension() && extension.getExtension().size() == 2 && extension.getExtension().stream().filter(e -> this.isValidExtensionReadAccessConsortiumMemberRoleConsortium((Extension)e, organizationWithIdentifierExists)).count() == 1L && extension.getExtension().stream().filter(e -> this.isValidExtensionReadAccessConsortiumMemberRoleRole((Extension)e, roleExists)).count() == 1L;
    }

    private boolean isValidExtensionReadAccessConsortiumMemberRoleConsortium(Extension e, Predicate<Identifier> organizationWithIdentifierExists) {
        return e.hasUrl() && "consortium".equals(e.getUrl()) && e.hasValue() && e.getValue() instanceof Identifier && this.isValidOrganizationIdentifier((Identifier)e.getValue(), organizationWithIdentifierExists);
    }

    private boolean isValidExtensionReadAccessConsortiumMemberRoleRole(Extension e, Predicate<Coding> roleExists) {
        return e.hasUrl() && "role".equals(e.getUrl()) && e.hasValue() && e.getValue() instanceof Coding && this.isValidRole((Coding)e.getValue(), roleExists);
    }

    private boolean isValidRole(Coding coding, Predicate<Coding> roleExists) {
        return coding.hasSystem() && coding.hasCode() && roleExists.test(coding);
    }
}

