/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authorization.process.Recipient;
import dev.dsf.fhir.authorization.process.Requester;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;

public class Role
implements Recipient,
Requester {
    private final boolean localIdentity;
    private final String consortiumIdentifier;
    private final String roleSystem;
    private final String roleCode;

    public Role(boolean localIdentity, String consortiumIdentifier, String roleSystem, String roleCode) {
        Objects.requireNonNull(consortiumIdentifier, "consortiumIdentifier");
        if (consortiumIdentifier.isBlank()) {
            throw new IllegalArgumentException("consortiumIdentifier blank");
        }
        Objects.requireNonNull(roleSystem, "roleSystem");
        if (roleSystem.isBlank()) {
            throw new IllegalArgumentException("roleSystem blank");
        }
        Objects.requireNonNull(roleCode, "roleCode");
        if (roleCode.isBlank()) {
            throw new IllegalArgumentException("roleCode blank");
        }
        this.localIdentity = localIdentity;
        this.consortiumIdentifier = consortiumIdentifier;
        this.roleSystem = roleSystem;
        this.roleCode = roleCode;
    }

    @Override
    public boolean isRequesterAuthorized(Identity requesterUser, Stream<OrganizationAffiliation> requesterAffiliations) {
        return this.isAuthorized(requesterUser, requesterAffiliations);
    }

    @Override
    public boolean isRecipientAuthorized(Identity recipientUser, Stream<OrganizationAffiliation> recipientAffiliations) {
        return this.isAuthorized(recipientUser, recipientAffiliations);
    }

    private boolean isAuthorized(Identity identity, Stream<OrganizationAffiliation> affiliations) {
        return identity != null && identity.getOrganization() != null && identity.getOrganization().getActive() && identity.isLocalIdentity() == this.localIdentity && affiliations != null && this.hasConsortiumMemberRole(identity.getOrganization(), affiliations);
    }

    private boolean hasConsortiumMemberRole(Organization recipientOrganization, Stream<OrganizationAffiliation> affiliations) {
        return affiliations.filter(OrganizationAffiliation::getActive).filter(OrganizationAffiliation::hasOrganization).filter(a -> a.getOrganization().hasIdentifier()).filter(a -> a.getOrganization().getIdentifier().hasSystem()).filter(a -> a.getOrganization().getIdentifier().hasValue()).filter(a -> "http://dsf.dev/sid/organization-identifier".equals(a.getOrganization().getIdentifier().getSystem())).filter(a -> this.consortiumIdentifier.equals(a.getOrganization().getIdentifier().getValue())).filter(OrganizationAffiliation::hasParticipatingOrganization).filter(a -> a.getParticipatingOrganization().hasIdentifier()).filter(a -> a.getParticipatingOrganization().getIdentifier().hasSystem()).filter(a -> a.getParticipatingOrganization().getIdentifier().hasValue()).filter(a -> {
            Identifier memberIdentifier = a.getParticipatingOrganization().getIdentifier();
            return recipientOrganization.getIdentifier().stream().filter(Identifier::hasSystem).filter(Identifier::hasValue).anyMatch(i -> i.getSystem().equals(memberIdentifier.getSystem()) && i.getValue().equals(memberIdentifier.getValue()));
        }).filter(OrganizationAffiliation::hasCode).flatMap(a -> a.getCode().stream()).filter(CodeableConcept::hasCoding).flatMap(c -> c.getCoding().stream()).filter(Coding::hasSystem).filter(Coding::hasCode).anyMatch(c -> c.getSystem().equals(this.roleSystem) && c.getCode().equals(this.roleCode));
    }

    @Override
    public Extension toRecipientExtension() {
        return new Extension().setUrl("recipient").setValue((Type)this.toCoding());
    }

    @Override
    public Extension toRequesterExtension() {
        return new Extension().setUrl("requester").setValue((Type)this.toCoding());
    }

    private Coding toCoding() {
        Identifier consortium = new Reference().getIdentifier().setSystem("http://dsf.dev/sid/organization-identifier").setValue(this.consortiumIdentifier);
        Extension consortiumExt = new Extension("consortium").setValue((Type)consortium);
        Coding role = new Coding(this.roleSystem, this.roleCode, null);
        Extension roleExt = new Extension("role").setValue((Type)role);
        Coding coding = this.getProcessAuthorizationCode();
        coding.addExtension().setUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-consortium-role").addExtension(consortiumExt).addExtension(roleExt);
        return coding;
    }

    @Override
    public boolean requesterMatches(Extension requesterExtension) {
        return requesterExtension != null && "requester".equals(requesterExtension.getUrl()) && requesterExtension.hasValue() && requesterExtension.getValue() instanceof Coding && this.matches((Coding)requesterExtension.getValue()) && requesterExtension.getValue().hasExtension() && this.hasMatchingConsortiumRoleExtension(requesterExtension.getValue().getExtension());
    }

    @Override
    public boolean recipientMatches(Extension recipientExtension) {
        return recipientExtension != null && "recipient".equals(recipientExtension.getUrl()) && recipientExtension.hasValue() && recipientExtension.getValue() instanceof Coding && this.matches((Coding)recipientExtension.getValue()) && recipientExtension.getValue().hasExtension() && this.hasMatchingConsortiumRoleExtension(recipientExtension.getValue().getExtension());
    }

    private boolean hasMatchingConsortiumRoleExtension(List<Extension> extension) {
        return extension.stream().anyMatch(this::consortiumRoleExtensionMatches);
    }

    private boolean consortiumRoleExtensionMatches(Extension extension) {
        return "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-consortium-role".equals(extension.getUrl()) && extension.hasExtension() && this.hasMatchingConsortiumExtension(extension.getExtension()) && this.hasMatchingRoleExtension(extension.getExtension());
    }

    private boolean hasMatchingConsortiumExtension(List<Extension> extension) {
        return extension.stream().anyMatch(this::consortiumExtensionMatches);
    }

    private boolean consortiumExtensionMatches(Extension extension) {
        return "consortium".equals(extension.getUrl()) && extension.hasValue() && extension.getValue() instanceof Identifier && this.consortiumIdentifierMatches((Identifier)extension.getValue());
    }

    private boolean consortiumIdentifierMatches(Identifier identifier) {
        return identifier != null && identifier.hasSystem() && identifier.hasValue() && "http://dsf.dev/sid/organization-identifier".equals(identifier.getSystem()) && this.consortiumIdentifier.equals(identifier.getValue());
    }

    private boolean hasMatchingRoleExtension(List<Extension> extension) {
        return extension.stream().anyMatch(this::roleExtensionMatches);
    }

    private boolean roleExtensionMatches(Extension extension) {
        return "role".equals(extension.getUrl()) && extension.hasValue() && extension.getValue() instanceof Coding && this.roleMatches((Coding)extension.getValue());
    }

    private boolean roleMatches(Coding coding) {
        return coding != null && coding.hasSystem() && coding.hasCode() && this.roleSystem.equals(coding.getSystem()) && this.roleCode.equals(coding.getCode());
    }

    @Override
    public Coding getProcessAuthorizationCode() {
        if (this.localIdentity) {
            return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "LOCAL_ROLE", null);
        }
        return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "REMOTE_ROLE", null);
    }

    @Override
    public boolean matches(Coding processAuthorizationCode) {
        if (this.localIdentity) {
            return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "LOCAL_ROLE".equals(processAuthorizationCode.getCode());
        }
        return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "REMOTE_ROLE".equals(processAuthorizationCode.getCode());
    }

    public static Optional<Requester> fromRequester(Coding coding, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> roleExists) {
        return Role.from(coding, organizationWithIdentifierExists, roleExists);
    }

    public static Optional<Recipient> fromRecipient(Coding coding, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> roleExists) {
        return Role.from(coding, organizationWithIdentifierExists, roleExists);
    }

    private static Optional<? super Role> from(Coding coding, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> roleExists) {
        if (coding != null && coding.hasSystem() && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(coding.getSystem()) && coding.hasCode()) {
            if ("LOCAL_ROLE".equals(coding.getCode())) {
                return Role.from(true, coding, organizationWithIdentifierExists, roleExists);
            }
            if ("REMOTE_ROLE".equals(coding.getCode())) {
                return Role.from(false, coding, organizationWithIdentifierExists, roleExists);
            }
        }
        return Optional.empty();
    }

    private static Optional<? super Role> from(boolean localIdentity, Coding coding, Predicate<Identifier> organizationWithIdentifierExists, Predicate<Coding> roleExists) {
        List consortiumRoles;
        if (coding != null && coding.hasExtension() && (consortiumRoles = coding.getExtension().stream().filter(Extension::hasUrl).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-consortium-role".equals(e.getUrl())).collect(Collectors.toList())).size() == 1) {
            Extension consortiumRole = (Extension)consortiumRoles.get(0);
            List consortiums = consortiumRole.getExtension().stream().filter(Extension::hasUrl).filter(e -> "consortium".equals(e.getUrl())).collect(Collectors.toList());
            List roles = consortiumRole.getExtension().stream().filter(Extension::hasUrl).filter(e -> "role".equals(e.getUrl())).collect(Collectors.toList());
            if (consortiums.size() == 1 && roles.size() == 1) {
                Extension consortium = (Extension)consortiums.get(0);
                Extension role = (Extension)roles.get(0);
                if (consortium.hasValue() && consortium.getValue() instanceof Identifier && role.hasValue() && role.getValue() instanceof Coding) {
                    Identifier consortiumIdentifier = (Identifier)consortium.getValue();
                    Coding roleCoding = (Coding)role.getValue();
                    if ("http://dsf.dev/sid/organization-identifier".equals(consortiumIdentifier.getSystem()) && organizationWithIdentifierExists.test(consortiumIdentifier) && roleExists.test(roleCoding)) {
                        return Optional.of(new Role(localIdentity, consortiumIdentifier.getValue(), roleCoding.getSystem(), roleCoding.getCode()));
                    }
                }
            }
        }
        return Optional.empty();
    }
}

