/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authorization.process.All;
import dev.dsf.fhir.authorization.process.Organization;
import dev.dsf.fhir.authorization.process.Role;
import dev.dsf.fhir.authorization.process.WithAuthorization;
import java.util.Collection;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Type;

public interface Requester
extends WithAuthorization {
    public static Requester localAll() {
        return Requester.all(true);
    }

    public static Requester remoteAll() {
        return Requester.all(false);
    }

    public static Requester all(boolean localIdentity) {
        return new All(localIdentity);
    }

    public static Requester localOrganization(String organizationIdentifier) {
        return Requester.organization(true, organizationIdentifier);
    }

    public static Requester remoteOrganization(String organizationIdentifier) {
        return Requester.organization(false, organizationIdentifier);
    }

    public static Requester organization(boolean localIdentity, String organizationIdentifier) {
        return new Organization(localIdentity, organizationIdentifier);
    }

    public static Requester localRole(String consortiumIdentifier, String roleSystem, String roleCode) {
        return Requester.role(true, consortiumIdentifier, roleSystem, roleCode);
    }

    public static Requester remoteRole(String consortiumIdentifier, String roleSystem, String roleCode) {
        return Requester.role(false, consortiumIdentifier, roleSystem, roleCode);
    }

    public static Requester role(boolean localIdentity, String consortiumIdentifier, String roleSystem, String roleCode) {
        return new Role(localIdentity, consortiumIdentifier, roleSystem, roleCode);
    }

    public boolean requesterMatches(Extension var1);

    public boolean isRequesterAuthorized(Identity var1, Stream<OrganizationAffiliation> var2);

    default public boolean isRequesterAuthorized(Identity requesterUser, Collection<OrganizationAffiliation> requesterAffiliations) {
        return this.isRequesterAuthorized(requesterUser, requesterAffiliations == null ? null : requesterAffiliations.stream());
    }

    default public Extension toRequesterExtension() {
        return new Extension().setUrl("requester").setValue((Type)this.getProcessAuthorizationCode());
    }
}

