/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authorization.process.All;
import dev.dsf.fhir.authorization.process.Organization;
import dev.dsf.fhir.authorization.process.Role;
import dev.dsf.fhir.authorization.process.WithAuthorization;
import java.util.Collection;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Type;

public interface Recipient
extends WithAuthorization {
    public static Recipient localAll() {
        return new All(true);
    }

    public static Recipient localOrganization(String organizationIdentifier) {
        return new Organization(true, organizationIdentifier);
    }

    public static Recipient localRole(String consortiumIdentifier, String roleSystem, String roleCode) {
        return new Role(true, consortiumIdentifier, roleSystem, roleCode);
    }

    public boolean recipientMatches(Extension var1);

    public boolean isRecipientAuthorized(Identity var1, Stream<OrganizationAffiliation> var2);

    default public boolean isRecipientAuthorized(Identity recipientUser, Collection<OrganizationAffiliation> recipientAffiliations) {
        return this.isRecipientAuthorized(recipientUser, recipientAffiliations == null ? null : recipientAffiliations.stream());
    }

    default public Extension toRecipientExtension() {
        return new Extension().setUrl("recipient").setValue((Type)this.getProcessAuthorizationCode());
    }
}

