/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authorization.process.Recipient;
import dev.dsf.fhir.authorization.process.Requester;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;

public class Organization
implements Recipient,
Requester {
    private final String organizationIdentifier;
    private final boolean localIdentity;

    public Organization(boolean localIdentity, String organizationIdentifier) {
        Objects.requireNonNull(organizationIdentifier, "organizationIdentifier");
        if (organizationIdentifier.isBlank()) {
            throw new IllegalArgumentException("organizationIdentifier blank");
        }
        this.localIdentity = localIdentity;
        this.organizationIdentifier = organizationIdentifier;
    }

    @Override
    public boolean isRequesterAuthorized(Identity requesterUser, Stream<OrganizationAffiliation> requesterAffiliations) {
        return this.isAuthorized(requesterUser);
    }

    @Override
    public boolean isRecipientAuthorized(Identity recipientUser, Stream<OrganizationAffiliation> recipientAffiliations) {
        return this.isAuthorized(recipientUser);
    }

    private boolean isAuthorized(Identity identity) {
        return identity != null && identity.getOrganization() != null && identity.getOrganization().getActive() && identity.isLocalIdentity() == this.localIdentity && this.hasOrganizationIdentifier(identity.getOrganization());
    }

    private boolean hasOrganizationIdentifier(org.hl7.fhir.r4.model.Organization organization) {
        return organization.getIdentifier().stream().filter(Identifier::hasSystem).filter(Identifier::hasValue).filter(i -> "http://dsf.dev/sid/organization-identifier".equals(i.getSystem())).anyMatch(i -> this.organizationIdentifier.equals(i.getValue()));
    }

    @Override
    public Extension toRecipientExtension() {
        return new Extension().setUrl("recipient").setValue((Type)this.toCoding());
    }

    @Override
    public Extension toRequesterExtension() {
        return new Extension().setUrl("requester").setValue((Type)this.toCoding());
    }

    private Coding toCoding() {
        Identifier organization = new Reference().getIdentifier().setSystem("http://dsf.dev/sid/organization-identifier").setValue(this.organizationIdentifier);
        Coding coding = this.getProcessAuthorizationCode();
        coding.addExtension().setUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization").setValue((Type)organization);
        return coding;
    }

    @Override
    public boolean requesterMatches(Extension requesterExtension) {
        return this.matches(requesterExtension, "requester");
    }

    @Override
    public boolean recipientMatches(Extension recipientExtension) {
        return this.matches(recipientExtension, "recipient");
    }

    private boolean matches(Extension recipientExtension, String url) {
        return recipientExtension != null && url.equals(recipientExtension.getUrl()) && recipientExtension.hasValue() && recipientExtension.getValue() instanceof Coding && this.matches((Coding)recipientExtension.getValue()) && recipientExtension.getValue().hasExtension() && this.hasMatchingOrganizationExtension(recipientExtension.getValue().getExtension());
    }

    private boolean hasMatchingOrganizationExtension(List<Extension> extensions) {
        return extensions.stream().anyMatch(this::organizationExtensionMatches);
    }

    private boolean organizationExtensionMatches(Extension extension) {
        return "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization".equals(extension.getUrl()) && extension.hasValue() && extension.getValue() instanceof Identifier && this.organizationIdentifierMatches((Identifier)extension.getValue());
    }

    private boolean organizationIdentifierMatches(Identifier identifier) {
        return identifier != null && identifier.hasSystem() && identifier.hasValue() && "http://dsf.dev/sid/organization-identifier".equals(identifier.getSystem()) && this.organizationIdentifier.equals(identifier.getValue());
    }

    @Override
    public Coding getProcessAuthorizationCode() {
        if (this.localIdentity) {
            return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "LOCAL_ORGANIZATION", null);
        }
        return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "REMOTE_ORGANIZATION", null);
    }

    @Override
    public boolean matches(Coding processAuthorizationCode) {
        if (this.localIdentity) {
            return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "LOCAL_ORGANIZATION".equals(processAuthorizationCode.getCode());
        }
        return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "REMOTE_ORGANIZATION".equals(processAuthorizationCode.getCode());
    }

    public static Optional<Requester> fromRequester(Coding coding, Predicate<Identifier> organizationWithIdentifierExists) {
        return Organization.from(coding, organizationWithIdentifierExists);
    }

    public static Optional<Recipient> fromRecipient(Coding coding, Predicate<Identifier> organizationWithIdentifierExists) {
        return Organization.from(coding, organizationWithIdentifierExists);
    }

    private static Optional<? super Organization> from(Coding coding, Predicate<Identifier> organizationWithIdentifierExists) {
        if (coding != null && coding.hasSystem() && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(coding.getSystem()) && coding.hasCode()) {
            if ("LOCAL_ORGANIZATION".equals(coding.getCode())) {
                return Organization.from(true, coding, organizationWithIdentifierExists);
            }
            if ("REMOTE_ORGANIZATION".equals(coding.getCode())) {
                return Organization.from(false, coding, organizationWithIdentifierExists);
            }
        }
        return Optional.empty();
    }

    private static Optional<? super Organization> from(boolean localIdentity, Coding coding, Predicate<Identifier> organizationWithIdentifierExists) {
        Identifier identifier;
        Extension organization;
        List organizations;
        if (coding != null && coding.hasExtension() && (organizations = coding.getExtension().stream().filter(Extension::hasUrl).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization".equals(e.getUrl())).collect(Collectors.toList())).size() == 1 && (organization = (Extension)organizations.get(0)).hasValue() && organization.getValue() instanceof Identifier && "http://dsf.dev/sid/organization-identifier".equals((identifier = (Identifier)organization.getValue()).getSystem()) && organizationWithIdentifierExists.test(identifier)) {
            return Optional.of(new Organization(localIdentity, identifier.getValue()));
        }
        return Optional.empty();
    }
}

