/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authorization.process.Recipient;
import dev.dsf.fhir.authorization.process.Requester;
import java.util.Optional;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.OrganizationAffiliation;

public class All
implements Recipient,
Requester {
    private final boolean localIdentity;

    public All(boolean localIdentity) {
        this.localIdentity = localIdentity;
    }

    @Override
    public boolean isRequesterAuthorized(Identity requesterUser, Stream<OrganizationAffiliation> requesterAffiliations) {
        return this.isAuthorized(requesterUser);
    }

    @Override
    public boolean isRecipientAuthorized(Identity recipientUser, Stream<OrganizationAffiliation> recipientAffiliations) {
        return this.isAuthorized(recipientUser);
    }

    private boolean isAuthorized(Identity identity) {
        return identity != null && identity.getOrganization() != null && identity.getOrganization().getActive() && identity.isLocalIdentity() == this.localIdentity;
    }

    @Override
    public boolean requesterMatches(Extension requesterExtension) {
        return this.matches(requesterExtension, "requester");
    }

    @Override
    public boolean recipientMatches(Extension recipientExtension) {
        return this.matches(recipientExtension, "recipient");
    }

    private boolean matches(Extension recipientExtension, String url) {
        return recipientExtension != null && url.equals(recipientExtension.getUrl()) && recipientExtension.hasValue() && recipientExtension.getValue() instanceof Coding && this.matches((Coding)recipientExtension.getValue());
    }

    @Override
    public Coding getProcessAuthorizationCode() {
        if (this.localIdentity) {
            return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "LOCAL_ALL", null);
        }
        return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "REMOTE_ALL", null);
    }

    @Override
    public boolean matches(Coding processAuthorizationCode) {
        if (this.localIdentity) {
            return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "LOCAL_ALL".equals(processAuthorizationCode.getCode());
        }
        return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "REMOTE_ALL".equals(processAuthorizationCode.getCode());
    }

    public static Optional<Requester> fromRequester(Coding coding) {
        if (coding != null && coding.hasSystem() && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(coding.getSystem()) && coding.hasCode()) {
            if ("LOCAL_ALL".equals(coding.getCode())) {
                return Optional.of(new All(true));
            }
            if ("REMOTE_ALL".equals(coding.getCode())) {
                return Optional.of(new All(false));
            }
        }
        return Optional.empty();
    }

    public static Optional<Recipient> fromRecipient(Coding coding) {
        if (coding != null && coding.hasSystem() && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(coding.getSystem()) && coding.hasCode() && "LOCAL_ALL".equals(coding.getCode())) {
            return Optional.of(new All(true));
        }
        return Optional.empty();
    }
}

