/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.jetty;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;

public final class Log4jInitializer {
    public static final String LOG4J_CONFIG = "dev.dsf.log4j.config";
    public static final String LOG4J_CONFIG_DEFAULT = "conf/log4j2.xml";

    private Log4jInitializer() {
    }

    private static Path readlog4jConfigPath() {
        String log4jConfig = System.getenv(LOG4J_CONFIG.replace(".", "_"));
        if (log4jConfig == null) {
            log4jConfig = Log4jInitializer.jettyProperties().getProperty(LOG4J_CONFIG, LOG4J_CONFIG_DEFAULT);
        }
        return Paths.get(log4jConfig, new String[0]);
    }

    private static Properties jettyProperties() {
        Properties properties = new Properties();
        Path propertiesFile = Paths.get("conf/jetty.properties", new String[0]);
        if (Files.isReadable(propertiesFile)) {
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(propertiesFile, new OpenOption[0]), StandardCharsets.UTF_8);){
                properties.load(reader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    public static LoggerContext initializeLog4j() {
        try {
            Path configPath = Log4jInitializer.readlog4jConfigPath();
            if (Files.isReadable(configPath)) {
                ConfigurationSource configuration = new ConfigurationSource(Files.newInputStream(configPath, new OpenOption[0]), configPath);
                return Configurator.initialize(null, (ConfigurationSource)configuration);
            }
            LoggerContext context = Configurator.initialize((Configuration)new DefaultConfiguration());
            context.getRootLogger().log(Level.ERROR, "Log4j config at " + configPath.toString() + " not readable, using default logging configuration");
            return context;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

