/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.UserPrincipal;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;

public class StatusPortAuthenticator
implements Authenticator {
    private static final String STATUS_PATH = "/status";
    private final Supplier<Integer> statusPortSupplier;

    public StatusPortAuthenticator(Supplier<Integer> statusPortSupplier) {
        Objects.requireNonNull(statusPortSupplier, "statusPortSupplier");
        this.statusPortSupplier = statusPortSupplier;
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
    }

    public String getAuthMethod() {
        return "STATUS_PORT_AUTHENTICATOR";
    }

    public boolean isStatusPortRequest(ServletRequest req) {
        HttpServletRequest request = (HttpServletRequest)req;
        return this.statusPortSupplier.get() != null && this.statusPortSupplier.get().intValue() == request.getLocalPort();
    }

    private boolean isStatusPortAndPathGetRequest(ServletRequest req) {
        HttpServletRequest request = (HttpServletRequest)req;
        return HttpMethod.GET.is(request.getMethod()) && STATUS_PATH.equals(request.getPathInfo()) && this.statusPortSupplier.get() != null && this.statusPortSupplier.get().intValue() == request.getLocalPort();
    }

    public void prepareRequest(ServletRequest request) {
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        if (this.isStatusPortAndPathGetRequest(request)) {
            return new UserAuthentication(this.getAuthMethod(), (UserIdentity)new DefaultUserIdentity(null, (Principal)new UserPrincipal("STATUS_PORT_USER", null), new String[]{"STATUS_PORT_ROLE"}));
        }
        return Authentication.UNAUTHENTICATED;
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

