/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth;

import com.auth0.jwt.interfaces.RSAKeyProvider;
import dev.dsf.common.auth.jwk.Jwks;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsfOpenIdConfiguration
extends OpenIdConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DsfOpenIdConfiguration.class);
    private final boolean backChannelLogoutEnabled;
    private final boolean bearerTokenEnabled;
    private RSAKeyProvider rsaKeyProvider;

    public DsfOpenIdConfiguration(String issuer, String clientId, String clientSecret, HttpClient httpClient, boolean backChannelLogoutEnabled, boolean bearerTokenEnabled) {
        super(issuer, null, null, clientId, clientSecret, httpClient);
        this.backChannelLogoutEnabled = backChannelLogoutEnabled;
        this.bearerTokenEnabled = bearerTokenEnabled;
    }

    protected void processMetadata(Map<String, Object> discoveryDocument) {
        super.processMetadata(discoveryDocument);
        if (this.backChannelLogoutEnabled || this.bearerTokenEnabled) {
            String jwksUri = (String)discoveryDocument.get("jwks_uri");
            if (jwksUri == null) {
                throw new IllegalStateException("jwks_uri");
            }
            this.rsaKeyProvider = this.createRsaKeyProvider(jwksUri);
        }
    }

    public boolean isBackChannelLogoutEnabled() {
        return this.backChannelLogoutEnabled;
    }

    public RSAKeyProvider getRsaKeyProvider() {
        return this.rsaKeyProvider;
    }

    private RSAKeyProvider createRsaKeyProvider(String jwksUri) {
        try {
            final Jwks jwks = Jwks.from(this.getHttpClient().GET(jwksUri).getContentAsString());
            return new RSAKeyProvider(){

                public RSAPublicKey getPublicKeyById(String kid) {
                    Optional<RSAPublicKey> key = jwks.getKey(kid).getPublicKey();
                    if (key.isPresent()) {
                        return key.get();
                    }
                    logger.warn("Unable to retrieve key with id {}", (Object)kid);
                    return null;
                }

                public RSAPrivateKey getPrivateKey() {
                    return null;
                }

                public String getPrivateKeyId() {
                    return null;
                }
            };
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.debug("Unable to retrieve keys from {}", (Object)jwksUri, (Object)e);
            logger.warn("Unable to retrieve keys from {}: {} - {}", new Object[]{jwksUri, e.getClass().getName(), e.getMessage()});
            throw new RuntimeException(e);
        }
    }
}

