/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth;

import dev.dsf.common.auth.DsfOpenIdCredentials;
import dev.dsf.common.auth.DsfOpenIdCredentialsImpl;
import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.IdentityProvider;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.openid.OpenIdCredentials;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DsfLoginService
implements LoginService {
    private final AtomicReference<IdentityProvider> identityProvider = new AtomicReference<Object>(null);
    private final ContextHandler contextHandler;

    public DsfLoginService(ContextHandler contextHandler) {
        this.contextHandler = Objects.requireNonNull(contextHandler, "contextHandler");
    }

    public String getName() {
        return "DsfLoginService";
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        if (credentials == null) {
            return null;
        }
        IdentityProvider identityProvider = this.getIdentityProvider();
        if (identityProvider == null) {
            return null;
        }
        Identity identity = null;
        if (credentials instanceof X509Certificate[]) {
            X509Certificate[] c = (X509Certificate[])credentials;
            identity = identityProvider.getIdentity(c);
        } else if (credentials instanceof OpenIdCredentials) {
            OpenIdCredentials o = (OpenIdCredentials)credentials;
            identity = identityProvider.getIdentity((DsfOpenIdCredentials)new DsfOpenIdCredentialsImpl(o));
        } else if (credentials instanceof String) {
            String s = (String)credentials;
            identity = identityProvider.getIdentity((DsfOpenIdCredentials)new DsfOpenIdCredentialsImpl(s));
        }
        if (identity == null) {
            return null;
        }
        return new UserIdentityImpl((Principal)identity, this.toRoles(identity));
    }

    private Set<String> toRoles(Identity identity) {
        return identity.getDsfRoles().stream().map(DsfRole::name).collect(Collectors.toSet());
    }

    protected IdentityProvider getIdentityProvider() {
        IdentityProvider ip = this.identityProvider.get();
        if (ip == null) {
            ip = (IdentityProvider)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.contextHandler.getServletContext()).getBean(IdentityProvider.class);
            if (this.identityProvider.compareAndSet(null, ip)) {
                return ip;
            }
            return this.identityProvider.get();
        }
        return ip;
    }

    public boolean validate(UserIdentity user) {
        return true;
    }

    public IdentityService getIdentityService() {
        return null;
    }

    public void setIdentityService(IdentityService identityService) {
    }

    public void logout(UserIdentity user) {
    }

    private static final class UserIdentityImpl
    implements UserIdentity {
        private final Principal principal;
        private final Set<String> roles = new HashSet<String>();

        private UserIdentityImpl(Principal principal, Set<String> roles) {
            this.principal = principal;
            if (roles != null) {
                this.roles.addAll(roles);
            }
        }

        public Subject getSubject() {
            return null;
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role, UserIdentity.Scope scope) {
            return this.roles.contains(role);
        }
    }
}

