/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import dev.dsf.common.auth.DsfOpenIdConfiguration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.server.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackChannelLogoutAuthenticator
implements Authenticator,
HttpSessionListener,
HttpSessionAttributeListener {
    private static final Logger logger = LoggerFactory.getLogger(BackChannelLogoutAuthenticator.class);
    private final DsfOpenIdConfiguration openIdConfiguration;
    private final String ssoLogoutPath;
    private final ConcurrentMap<String, HttpSession> sessionsBySub = new ConcurrentHashMap<String, HttpSession>();
    private final ConcurrentMap<String, HttpSession> sessionsBySid = new ConcurrentHashMap<String, HttpSession>();

    public BackChannelLogoutAuthenticator(DsfOpenIdConfiguration openIdConfiguration, String ssoLogoutPath) {
        Objects.requireNonNull(openIdConfiguration, "openIdConfiguration");
        this.openIdConfiguration = openIdConfiguration;
        Objects.requireNonNull(ssoLogoutPath, "ssoLogoutPath");
        this.ssoLogoutPath = !ssoLogoutPath.startsWith("/") ? "/" + ssoLogoutPath : ssoLogoutPath;
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
    }

    public String getAuthMethod() {
        return "BACK_CHANNEL_LOGOUT";
    }

    public boolean isBackChannelLogoutRequest(ServletRequest request) {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        return HttpMethod.POST.is(servletRequest.getMethod()) && this.ssoLogoutPath.equals(servletRequest.getPathInfo()) && MimeTypes.Type.FORM_ENCODED.is(servletRequest.getContentType());
    }

    public void prepareRequest(ServletRequest request) {
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        try {
            String[] logoutTokens = request.getParameterValues("logout_token");
            if (logoutTokens == null || logoutTokens.length != 1) {
                servletResponse.sendError(403);
                return Authentication.SEND_FAILURE;
            }
            Algorithm algorithm = Algorithm.RSA256((RSAKeyProvider)this.openIdConfiguration.getRsaKeyProvider());
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(this.openIdConfiguration.getIssuer()).withAudience(new String[]{this.openIdConfiguration.getClientId()}).acceptLeeway(1L).withClaim("events", (claim, jwt) -> claim.asMap().containsKey("http://schemas.openid.net/event/backchannel-logout")).build();
            try {
                HttpSession sessionBySid;
                DecodedJWT jwt2 = verifier.verify(logoutTokens[0]);
                if (!jwt2.getClaims().containsKey("sub") && !jwt2.getClaims().containsKey("sid")) {
                    logger.warn("Logout Token has no sub and no sid claim");
                    servletResponse.sendError(400);
                    return Authentication.SEND_FAILURE;
                }
                logger.debug("logout token claims: {}", (Object)jwt2.getClaims());
                String sub = jwt2.getClaim("sub").asString();
                String sid = jwt2.getClaim("sid").asString();
                logger.debug("Invalidating session for sub/sid {}/{}", (Object)sub, (Object)sid);
                HttpSession sessionBySub = (HttpSession)this.sessionsBySub.get(sub);
                if (sessionBySub != null) {
                    sessionBySub.invalidate();
                }
                if ((sessionBySid = (HttpSession)this.sessionsBySid.get(sid)) != null) {
                    sessionBySid.invalidate();
                }
                return Authentication.SEND_SUCCESS;
            }
            catch (JWTVerificationException e) {
                servletResponse.sendError(400);
                return Authentication.SEND_FAILURE;
            }
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (this.openIdConfiguration.isBackChannelLogoutEnabled()) {
            logger.debug("Session created, id: {}", (Object)event.getSession().getId());
            logger.debug("Session created, claims: {}", event.getSession().getAttribute("org.eclipse.jetty.security.openid.claims"));
            Object claimsAttribute = event.getSession().getAttribute("org.eclipse.jetty.security.openid.claims");
            if (claimsAttribute != null) {
                String sid;
                Map claims = (Map)claimsAttribute;
                String sub = (String)claims.get("sub");
                if (sub != null) {
                    this.sessionsBySub.put(sub, event.getSession());
                }
                if ((sid = (String)claims.get("sid")) != null) {
                    this.sessionsBySid.put(sid, event.getSession());
                }
            }
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (this.openIdConfiguration.isBackChannelLogoutEnabled()) {
            logger.debug("Session destroyed, id: {}", (Object)event.getSession().getId());
            logger.debug("Session destroyed, claims: {}", event.getSession().getAttribute("org.eclipse.jetty.security.openid.claims"));
            Object claimsAttribute = event.getSession().getAttribute("org.eclipse.jetty.security.openid.claims");
            if (claimsAttribute != null) {
                String sid;
                Map claims = (Map)claimsAttribute;
                String sub = (String)claims.get("sub");
                if (sub != null) {
                    this.sessionsBySub.remove(sub, event.getSession());
                }
                if ((sid = (String)claims.get("sid")) != null) {
                    this.sessionsBySid.remove(sid, event.getSession());
                }
            }
        }
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (this.openIdConfiguration.isBackChannelLogoutEnabled() && "org.eclipse.jetty.security.openid.claims".equals(event.getName())) {
            String sid;
            logger.debug("Attribute added, Session id: {}", (Object)event.getSession().getId());
            logger.debug("Attribute added, claims: {}", event.getValue());
            Map claims = (Map)event.getValue();
            String sub = (String)claims.get("sub");
            if (sub != null) {
                this.sessionsBySub.put(sub, event.getSession());
            }
            if ((sid = (String)claims.get("sid")) != null) {
                this.sessionsBySid.put(sid, event.getSession());
            }
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (this.openIdConfiguration.isBackChannelLogoutEnabled() && "org.eclipse.jetty.security.openid.claims".equals(event.getName())) {
            String sid;
            logger.debug("Attribute removed, Session id: {}", (Object)event.getSession().getId());
            logger.debug("Attribute removed, claims: {}", event.getValue());
            Map claims = (Map)event.getValue();
            String sub = (String)claims.get("sub");
            if (sub != null) {
                this.sessionsBySub.remove(sub, event.getSession());
            }
            if ((sid = (String)claims.get("sid")) != null) {
                this.sessionsBySid.remove(sid, event.getSession());
            }
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        if (this.openIdConfiguration.isBackChannelLogoutEnabled() && "org.eclipse.jetty.security.openid.claims".equals(event.getName())) {
            String sid;
            logger.debug("Attribute replaced, Session id: {}", (Object)event.getSession().getId());
            logger.debug("Attribute replaced, claims: {}", event.getValue());
            Map claims = (Map)event.getValue();
            String sub = (String)claims.get("sub");
            if (sub != null) {
                this.sessionsBySub.put(sub, event.getSession());
            }
            if ((sid = (String)claims.get("sid")) != null) {
                this.sessionsBySid.put(sid, event.getSession());
            }
        }
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return request.isSecure();
    }
}

