/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth.jwk;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Jwk {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final String id;
    private final String type;
    private final RSAPublicKey publicKey;

    public Jwk(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        this.id = (String)attributes.get("kid");
        this.type = (String)attributes.get("kty");
        this.publicKey = Jwk.publicKeyFrom(this.type, attributes);
    }

    private static RSAPublicKey publicKeyFrom(String type, Map<String, Object> attributes) {
        if ("RSA".equals(type)) {
            try {
                KeyFactory factory = KeyFactory.getInstance("RSA");
                BigInteger modulus = new BigInteger(1, Base64.getUrlDecoder().decode((String)attributes.get("n")));
                BigInteger exponent = new BigInteger(1, Base64.getUrlDecoder().decode((String)attributes.get("e")));
                return (RSAPublicKey)factory.generatePublic(new RSAPublicKeySpec(modulus, exponent));
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Optional<RSAPublicKey> getPublicKey() {
        return Optional.ofNullable(this.publicKey);
    }
}

