/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.server.Authentication;

public class StatusPortAuthenticator
implements Authenticator {
    private static final String STATUS_PATH = "/status";
    private final int statusPort;

    public StatusPortAuthenticator(int statusPort) {
        this.statusPort = statusPort;
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
    }

    public String getAuthMethod() {
        return "STATUS_PORT_AUTHENTICATOR";
    }

    public boolean isStatusPortRequest(ServletRequest req) {
        HttpServletRequest request = (HttpServletRequest)req;
        return HttpMethod.GET.is(request.getMethod()) && STATUS_PATH.equals(request.getPathInfo()) && this.statusPort == request.getLocalPort();
    }

    public void prepareRequest(ServletRequest request) {
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        if (this.isStatusPortRequest(request)) {
            return new UserAuthentication(this.getAuthMethod(), null);
        }
        return Authentication.UNAUTHENTICATED;
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

