/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth;

import dev.dsf.common.auth.DsfOpenIdCredentials;
import dev.dsf.common.auth.DsfOpenIdCredentialsImpl;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.IdentityProvider;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.openid.OpenIdCredentials;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DsfLoginService
implements LoginService {
    private final AtomicReference<IdentityProvider> identityProvider = new AtomicReference<Object>(null);
    private final ContextHandler contextHandler;

    public DsfLoginService(ContextHandler contextHandler) {
        this.contextHandler = Objects.requireNonNull(contextHandler, "contextHandler");
    }

    public String getName() {
        return "DsfLoginService";
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        if (credentials == null) {
            return null;
        }
        IdentityProvider identityProvider = this.getIdentityProvider();
        if (identityProvider == null) {
            return null;
        }
        Identity principal = null;
        if (credentials instanceof X509Certificate[]) {
            principal = identityProvider.getIdentity((X509Certificate[])credentials);
        } else if (credentials instanceof OpenIdCredentials) {
            principal = identityProvider.getIdentity((DsfOpenIdCredentials)new DsfOpenIdCredentialsImpl((OpenIdCredentials)credentials));
        } else if (credentials instanceof String) {
            principal = identityProvider.getIdentity((DsfOpenIdCredentials)new DsfOpenIdCredentialsImpl((String)credentials));
        }
        if (principal == null) {
            return null;
        }
        return new UserIdentityImpl((Principal)principal);
    }

    protected IdentityProvider getIdentityProvider() {
        IdentityProvider ip = this.identityProvider.get();
        if (ip == null) {
            ip = (IdentityProvider)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.contextHandler.getServletContext()).getBean(IdentityProvider.class);
            if (this.identityProvider.compareAndSet(null, ip)) {
                return ip;
            }
            return this.identityProvider.get();
        }
        return ip;
    }

    public boolean validate(UserIdentity user) {
        return true;
    }

    public IdentityService getIdentityService() {
        return null;
    }

    public void setIdentityService(IdentityService identityService) {
    }

    public void logout(UserIdentity user) {
    }

    private final class UserIdentityImpl
    implements UserIdentity {
        private final Principal principal;

        private UserIdentityImpl(Principal principal) {
            this.principal = principal;
        }

        public Subject getSubject() {
            return null;
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role, UserIdentity.Scope scope) {
            return false;
        }
    }
}

