/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.jetty;

import de.rwh.utils.crypto.CertificateHelper;
import dev.dsf.common.jetty.ForwardedSecureRequestCustomizer;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JettyServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);
    private final Server server = new Server((ThreadPool)this.threadPool());
    private final WebAppContext webAppContext;

    private static HttpConnectionFactory httpConnectionFactory(HttpConfiguration.Customizer ... customizers) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendXPoweredBy(false);
        httpConfiguration.setSendDateHeader(false);
        Arrays.stream(customizers).forEach(arg_0 -> ((HttpConfiguration)httpConfiguration).addCustomizer(arg_0));
        return new HttpConnectionFactory(httpConfiguration);
    }

    public static Function<Server, Connector> statusConnector(String host, int port) {
        return server -> {
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{JettyServer.httpConnectionFactory(new HttpConfiguration.Customizer[0])});
            connector.setHost(host);
            connector.setPort(port);
            return connector;
        };
    }

    public static final Function<Server, Connector> httpConnector(String host, int port, String clientCertificateHeaderName) {
        return server -> {
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{JettyServer.httpConnectionFactory(new HttpConfiguration.Customizer[]{new ForwardedRequestCustomizer(), new ForwardedSecureRequestCustomizer(clientCertificateHeaderName)})});
            connector.setHost(host);
            connector.setPort(port);
            return connector;
        };
    }

    public static Function<Server, Connector> httpsConnector(String host, int port, KeyStore clientCertificateTrustStore, KeyStore serverCertificateKeyStore, char[] keyStorePassword, boolean needClientAuth) {
        return server -> {
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{JettyServer.sslConnectionFactory(clientCertificateTrustStore, serverCertificateKeyStore, keyStorePassword, needClientAuth), JettyServer.httpConnectionFactory(new HttpConfiguration.Customizer[]{new SecureRequestCustomizer()})});
            connector.setHost(host);
            connector.setPort(port);
            return connector;
        };
    }

    private static SslConnectionFactory sslConnectionFactory(KeyStore clientCertificateTrustStore, KeyStore keyStore, char[] keyStorePassword, boolean needClientAuth) {
        JettyServer.logCertificateConfig(clientCertificateTrustStore, keyStore);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server(){

            protected KeyStore loadTrustStore(Resource resource) throws Exception {
                return this.getTrustStore();
            }
        };
        sslContextFactory.setKeyStore(keyStore);
        sslContextFactory.setKeyStorePassword(String.valueOf(keyStorePassword));
        sslContextFactory.setTrustStore(clientCertificateTrustStore);
        if (needClientAuth) {
            sslContextFactory.setNeedClientAuth(true);
        } else {
            sslContextFactory.setWantClientAuth(true);
        }
        return new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
    }

    private static void logCertificateConfig(KeyStore trustStore, KeyStore keyStore) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        try {
            if (trustStore != null) {
                logger.debug("Using trust store for https connector with: {}", (Object)CertificateHelper.listCertificateSubjectNames((KeyStore)trustStore));
            }
            if (keyStore != null) {
                logger.debug("Using key store for https connector with: {}", (Object)CertificateHelper.listCertificateSubjectNames((KeyStore)keyStore));
            }
        }
        catch (KeyStoreException e) {
            logger.warn("Error while printing trust store / key store config", (Throwable)e);
        }
    }

    public JettyServer(Function<Server, Connector> apiConnector, Function<Server, Connector> statusConnector, String mavenServerModuleName, String contextPath, List<Class<? extends ServletContainerInitializer>> servletContainerInitializers, Map<String, String> initParameters, KeyStore clientTrustStore, Consumer<WebAppContext> securityHandlerConfigurer) {
        this.server.addConnector(apiConnector.apply(this.server));
        this.server.addConnector(statusConnector.apply(this.server));
        this.webAppContext = this.webAppContext(mavenServerModuleName, contextPath, servletContainerInitializers, initParameters);
        securityHandlerConfigurer.accept(this.webAppContext);
        this.server.setHandler((Handler)this.webAppContext);
        this.server.setErrorHandler(this.statusCodeOnlyErrorHandler());
    }

    private QueuedThreadPool threadPool() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("jetty-server");
        return threadPool;
    }

    private WebAppContext webAppContext(String serverMavenModuleName, String contextPath, List<Class<? extends ServletContainerInitializer>> initializers, Map<String, String> initParameters) {
        Object[] classPath = this.classPath();
        WebAppContext context = new WebAppContext();
        initParameters.forEach((arg_0, arg_1) -> ((WebAppContext)context).setInitParameter(arg_0, arg_1));
        context.getServerClassMatcher().exclude((String[])initializers.stream().map(Class::getName).toArray(String[]::new));
        context.setContextPath(contextPath);
        context.setLogUrlOnStart(true);
        context.setThrowUnavailableOnStartupException(true);
        context.setConfigurations(new Configuration[]{new AnnotationConfiguration()});
        context.getMetaData().setWebInfClassesResources(Stream.of(classPath).filter(e -> e.contains(serverMavenModuleName)).map(x$0 -> Paths.get(x$0, new String[0])).map(Resource::newResource).toList());
        context.setErrorHandler(this.statusCodeOnlyErrorHandler());
        logger.debug("Java classpath: {}", (Object)Arrays.toString(classPath));
        logger.debug("Resources for jetty: {}", (Object)context.getMetaData().getWebInfClassesResources());
        logger.debug("Init parameters: {}", (Object)this.clean(context.getInitParams()));
        return context;
    }

    private String clean(Map<String, String> initParams) {
        return initParams.entrySet().stream().map(e -> e.getKey() != null && e.getValue() != null && (((String)e.getKey()).toLowerCase(Locale.ENGLISH).endsWith("password") || ((String)e.getKey()).toLowerCase(Locale.ENGLISH).endsWith("secret")) ? (String)e.getKey() + ": ***" : (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    private String[] classPath() {
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    private ErrorHandler statusCodeOnlyErrorHandler() {
        return new ErrorHandler(){

            protected void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
                logger.warn("Error {}: {}", (Object)code, (Object)message);
            }
        };
    }

    public final void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        try {
            logger.info("Starting jetty server ...");
            this.server.start();
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final void stop() {
        logger.info("Stopping jetty server ...");
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final ServletContext getServletContext() {
        return this.webAppContext == null ? null : this.webAppContext.getServletContext();
    }
}

