/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.jetty;

import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.api.ContentResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientWithGetRetry
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientWithGetRetry.class);
    private final int maxRetries;

    public HttpClientWithGetRetry(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public HttpClientWithGetRetry(HttpClientTransport transport, int maxRetries) {
        super(transport);
        this.maxRetries = maxRetries;
    }

    public ContentResponse GET(URI uri) throws InterruptedException, ExecutionException, TimeoutException {
        return this.GETWithRetryOnConnectException(this.maxRetries, uri);
    }

    public ContentResponse GETWithRetryOnConnectException(int times, URI uri) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return super.GET(uri);
        }
        catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException e) {
            Throwable cause = e;
            while (!(cause instanceof ConnectException) && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof ConnectException && times > 1) {
                logger.warn("Error while accessing {}: {}", (Object)(uri == null ? "null" : uri.toString()), (Object)e.getMessage());
                logger.warn("ConnectException: trying again in 5s");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.GETWithRetryOnConnectException(--times, uri);
            }
            if (cause instanceof UnknownHostException && times > 1) {
                logger.warn("Error while accessing {}: {}", (Object)(uri == null ? "null" : uri.toString()), (Object)e.getMessage());
                logger.warn("UnknownHostException: trying again in 10s");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.GETWithRetryOnConnectException(--times, uri);
            }
            logger.error("Error while accessing {}: {}", (Object)(uri == null ? "null" : uri.toString()), (Object)e.getMessage());
            throw e;
        }
    }
}

