/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.jetty;

import de.rwh.utils.crypto.io.PemIo;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardedSecureRequestCustomizer
implements HttpConfiguration.Customizer {
    private static final String URL_ENCODED_CERT_BEGIN = "-----BEGIN%20CERTIFICATE-----%0A";
    private static final String URL_ENCODED_CERT_END = "%0A-----END%20CERTIFICATE-----%0A";
    private static final String CERT_BEGIN = "-----BEGIN CERTIFICATE-----";
    private static final String CERT_END = "-----END CERTIFICATE-----";
    private static final Logger logger = LoggerFactory.getLogger(ForwardedSecureRequestCustomizer.class);
    private final String clientCertHeaderName;

    public ForwardedSecureRequestCustomizer(String clientCertHeaderName) {
        this.clientCertHeaderName = Objects.requireNonNull(clientCertHeaderName, "clientCertHeaderName");
    }

    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        X509Certificate clientCert = this.getClientCert(request);
        if (clientCert != null) {
            request.setAttribute("jakarta.servlet.request.X509Certificate", (Object)new X509Certificate[]{clientCert});
        }
    }

    private X509Certificate getClientCert(Request request) {
        Object clientCertString = request.getHeader(this.clientCertHeaderName);
        if (clientCertString == null) {
            logger.debug("No {} header found", (Object)this.clientCertHeaderName);
            return null;
        }
        if (((String)clientCertString).isEmpty()) {
            logger.debug("{} header empty", (Object)this.clientCertHeaderName);
            return null;
        }
        if (!((String)clientCertString).startsWith(CERT_BEGIN) && !((String)clientCertString).startsWith(URL_ENCODED_CERT_BEGIN)) {
            logger.warn("{} header does not start with {} or {}", new Object[]{this.clientCertHeaderName, CERT_BEGIN, URL_ENCODED_CERT_BEGIN});
            return null;
        }
        if (!((String)clientCertString).endsWith(CERT_END) && !((String)clientCertString).endsWith(URL_ENCODED_CERT_END)) {
            logger.warn("{} header does not end with {} or {}", new Object[]{this.clientCertHeaderName, CERT_END, URL_ENCODED_CERT_END});
            return null;
        }
        clientCertString = ((String)clientCertString).startsWith(CERT_BEGIN) ? CERT_BEGIN + ((String)clientCertString).replace(CERT_BEGIN, "").replace(CERT_END, "").replaceAll(" ", "\n") + CERT_END : URLDecoder.decode((String)clientCertString, StandardCharsets.UTF_8).trim();
        try {
            return PemIo.readX509CertificateFromPem((String)clientCertString);
        }
        catch (IOException | CertificateException e) {
            return null;
        }
    }
}

