/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth.jwk;

import dev.dsf.common.auth.jwk.Jwk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.ajax.JSON;

public class Jwks {
    private final Map<String, Jwk> jwks;

    public Jwks(Map<String, Object> json) {
        Object[] keys = (Object[])json.get("keys");
        this.jwks = Arrays.stream(keys).filter(o -> o instanceof Map).map(o -> (Map)o).map(Jwk::new).collect(Collectors.toMap(Jwk::getId, Function.identity(), (v1, v2) -> {
            throw new IllegalStateException("duplicate key id " + v1.getId());
        }, LinkedHashMap::new));
    }

    public static Jwks from(String json) {
        Object jwksJson = new JSON().parse((JSON.Source)new JSON.StringSource(json));
        if (jwksJson instanceof Map) {
            return new Jwks((Map)jwksJson);
        }
        return new Jwks(Collections.emptyMap());
    }

    public Jwk getKey(String id) {
        return this.jwks.get(id);
    }

    public List<Jwk> getAllKeys() {
        return new ArrayList<Jwk>(this.jwks.values());
    }
}

