/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth;

import dev.dsf.common.auth.DsfOpenIdCredentials;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jetty.security.openid.JwtDecoder;
import org.eclipse.jetty.security.openid.OpenIdCredentials;

public class DsfOpenIdCredentialsImpl
implements DsfOpenIdCredentials {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String ID_TOKEN = "id_token";
    private final Map<String, Object> idToken;
    private final Map<String, Object> accessToken;

    public DsfOpenIdCredentialsImpl(OpenIdCredentials credentials) {
        this.idToken = JwtDecoder.decode((String)((String)credentials.getResponse().get(ID_TOKEN)));
        this.accessToken = JwtDecoder.decode((String)((String)credentials.getResponse().get(ACCESS_TOKEN)));
    }

    public DsfOpenIdCredentialsImpl(String accessToken) {
        this.idToken = Collections.emptyMap();
        this.accessToken = JwtDecoder.decode((String)accessToken);
    }

    public String getUserId() {
        return (String)this.accessToken.get("sub");
    }

    public Map<String, Object> getIdToken() {
        return Collections.unmodifiableMap(this.idToken);
    }

    public Map<String, Object> getAccessToken() {
        return Collections.unmodifiableMap(this.accessToken);
    }

    public Long getLongClaim(String key) {
        Object o = this.getAccessToken().get(key);
        return o instanceof Long ? (Long)o : null;
    }

    public String getStringClaimOrDefault(String key, String defaultValue) {
        Object o = this.getAccessToken().getOrDefault(key, defaultValue);
        return o instanceof String ? (String)o : defaultValue;
    }
}

