/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth;

import dev.dsf.common.auth.BackChannelLogoutAuthenticator;
import dev.dsf.common.auth.BearerTokenAuthenticator;
import dev.dsf.common.auth.ClientCertificateAuthenticator;
import dev.dsf.common.auth.StatusPortAuthenticator;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.WrappedAuthConfiguration;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.openid.OpenIdAuthenticator;
import org.eclipse.jetty.security.openid.OpenIdLoginService;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.session.SessionHandler;

public class DelegatingAuthenticator
extends LoginAuthenticator
implements Authenticator {
    private final SessionHandler sessionHandler;
    private final StatusPortAuthenticator statusPortAuthenticator;
    private final ClientCertificateAuthenticator clientCertificateAuthenticator;
    private final BearerTokenAuthenticator bearerTokenAuthenticator;
    private final OpenIdAuthenticator openIdAuthenticator;
    private final OpenIdLoginService openIdLoginService;
    private final BackChannelLogoutAuthenticator backChannelLogoutAuthenticator;

    public DelegatingAuthenticator(SessionHandler sessionHandler, StatusPortAuthenticator statusPortAuthenticator, ClientCertificateAuthenticator clientCertificateAuthenticator, BearerTokenAuthenticator bearerTokenAuthenticator, OpenIdAuthenticator openIdAuthenticator, OpenIdLoginService openIdLoginService, BackChannelLogoutAuthenticator backChannelLogoutAuthenticator) {
        Objects.requireNonNull(sessionHandler, "sessionHandler");
        this.sessionHandler = sessionHandler;
        Objects.requireNonNull(statusPortAuthenticator, "statusPortAuthenticator");
        this.statusPortAuthenticator = statusPortAuthenticator;
        Objects.requireNonNull(clientCertificateAuthenticator, "clientCertificateAuthenticator");
        this.clientCertificateAuthenticator = clientCertificateAuthenticator;
        this.bearerTokenAuthenticator = bearerTokenAuthenticator;
        this.openIdAuthenticator = openIdAuthenticator;
        this.openIdLoginService = openIdLoginService;
        this.backChannelLogoutAuthenticator = backChannelLogoutAuthenticator;
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this.clientCertificateAuthenticator.setConfiguration(configuration);
        if (this.bearerTokenAuthenticator != null) {
            this.bearerTokenAuthenticator.setConfiguration(configuration);
        }
        if (this.openIdAuthenticator != null) {
            WrappedAuthConfiguration openIdConfig = new WrappedAuthConfiguration(configuration){

                public LoginService getLoginService() {
                    return DelegatingAuthenticator.this.openIdLoginService;
                }
            };
            this.openIdAuthenticator.setConfiguration((Authenticator.AuthConfiguration)openIdConfig);
        }
    }

    public String getAuthMethod() {
        return "DELEGATING_AUTHENTICATOR";
    }

    private boolean requestHasCertificate(ServletRequest request) {
        X509Certificate[] certificates = (X509Certificate[])request.getAttribute("jakarta.servlet.request.X509Certificate");
        return certificates != null && certificates.length > 0;
    }

    private boolean isFrontendRequest(ServletRequest request) {
        boolean sessionCookieSet;
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        boolean bl = sessionCookieSet = servletRequest.getCookies() != null && Arrays.stream(servletRequest.getCookies()).anyMatch(c -> this.sessionHandler.getSessionCookie().equals(c.getName()) && c.getValue() != null);
        if (sessionCookieSet) {
            return true;
        }
        return servletRequest.getHeader(HttpHeader.ACCEPT.asString()) != null && servletRequest.getHeader(HttpHeader.ACCEPT.asString()).contains(MimeTypes.Type.TEXT_HTML.asString());
    }

    public void prepareRequest(ServletRequest request) {
        if (this.statusPortAuthenticator.isStatusPortRequest(request)) {
            this.statusPortAuthenticator.prepareRequest(request);
        } else if (this.backChannelLogoutAuthenticator != null && this.backChannelLogoutAuthenticator.isBackChannelLogoutRequest(request)) {
            this.backChannelLogoutAuthenticator.prepareRequest(request);
        } else if (this.requestHasCertificate(request)) {
            this.clientCertificateAuthenticator.prepareRequest(request);
        } else if (this.openIdAuthenticator != null && this.isFrontendRequest(request)) {
            this.openIdAuthenticator.prepareRequest(request);
        } else if (this.bearerTokenAuthenticator != null) {
            this.bearerTokenAuthenticator.prepareRequest(request);
        }
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        if (this.statusPortAuthenticator.isStatusPortRequest(request)) {
            return this.statusPortAuthenticator.validateRequest(request, response, mandatory);
        }
        if (this.backChannelLogoutAuthenticator != null && this.backChannelLogoutAuthenticator.isBackChannelLogoutRequest(request)) {
            return this.backChannelLogoutAuthenticator.validateRequest(request, response, mandatory);
        }
        if (this.requestHasCertificate(request)) {
            return this.clientCertificateAuthenticator.validateRequest(request, response, mandatory);
        }
        if (this.openIdAuthenticator != null && this.isFrontendRequest(request)) {
            return this.openIdAuthenticator.validateRequest(request, response, mandatory);
        }
        if (this.bearerTokenAuthenticator != null) {
            return this.bearerTokenAuthenticator.validateRequest(request, response, mandatory);
        }
        return Authentication.UNAUTHENTICATED;
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        if (this.statusPortAuthenticator.isStatusPortRequest(request)) {
            return this.statusPortAuthenticator.secureResponse(request, response, mandatory, validatedUser);
        }
        if (this.backChannelLogoutAuthenticator != null && this.backChannelLogoutAuthenticator.isBackChannelLogoutRequest(request)) {
            return this.backChannelLogoutAuthenticator.secureResponse(request, response, mandatory, validatedUser);
        }
        if (this.requestHasCertificate(request)) {
            return this.clientCertificateAuthenticator.secureResponse(request, response, mandatory, validatedUser);
        }
        if (this.openIdAuthenticator != null && this.isFrontendRequest(request)) {
            return this.openIdAuthenticator.secureResponse(request, response, mandatory, validatedUser);
        }
        if (this.bearerTokenAuthenticator != null) {
            return this.bearerTokenAuthenticator.secureResponse(request, response, mandatory, validatedUser);
        }
        return false;
    }

    public void logout(ServletRequest request) {
        Request baseRequest = Request.getBaseRequest((ServletRequest)request);
        if (this.openIdAuthenticator != null && this.openIdAuthenticator.getAuthMethod().equals(baseRequest.getAuthType())) {
            this.openIdAuthenticator.logout(request);
        } else {
            super.logout(request);
        }
    }
}

