/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import dev.dsf.common.auth.DsfOpenIdConfiguration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BearerTokenAuthenticator
extends LoginAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(BearerTokenAuthenticator.class);
    private final DsfOpenIdConfiguration openIdConfiguration;

    public BearerTokenAuthenticator(DsfOpenIdConfiguration openIdConfiguration) {
        Objects.requireNonNull(openIdConfiguration, "openIdConfiguration");
        this.openIdConfiguration = openIdConfiguration;
    }

    public String getAuthMethod() {
        return "BEARER_TOKEN";
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        try {
            String authorizationHeader = servletRequest.getHeader(HttpHeader.AUTHORIZATION.asString());
            if (authorizationHeader == null || !authorizationHeader.startsWith("Bearer ")) {
                servletResponse.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), "Bearer");
                servletResponse.sendError(401);
                return Authentication.SEND_FAILURE;
            }
            Algorithm algorithm = Algorithm.RSA256((RSAKeyProvider)this.openIdConfiguration.getRsaKeyProvider());
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(this.openIdConfiguration.getIssuer()).acceptLeeway(1L).build();
            String accessToken = authorizationHeader.substring(7, authorizationHeader.length());
            try {
                DecodedJWT jwt = verifier.verify(accessToken);
                if (!jwt.getClaims().containsKey("sub") && !jwt.getClaims().containsKey("sid")) {
                    logger.warn("Access token has no sub and no sid claim");
                    servletResponse.sendError(400);
                    return Authentication.SEND_FAILURE;
                }
                logger.debug("Access token claims: {}", (Object)jwt.getClaims());
                UserIdentity user = this.login(null, accessToken, request);
                if (user == null) {
                    servletResponse.sendError(403);
                    return Authentication.SEND_FAILURE;
                }
                return new UserAuthentication(this.getAuthMethod(), user);
            }
            catch (TokenExpiredException e) {
                servletResponse.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), "Bearer error=\"invalid_token\", error_description=\"The access token expired\"");
                servletResponse.sendError(401);
                return Authentication.SEND_FAILURE;
            }
            catch (JWTVerificationException e) {
                servletResponse.sendError(400);
                return Authentication.SEND_FAILURE;
            }
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

