/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth.logging;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.OrganizationIdentity;
import dev.dsf.common.auth.conf.PractitionerIdentity;
import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.security.Principal;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConstrainedTo(value=RuntimeType.SERVER)
@PreMatching
@Priority(value=-2147483648)
public class CurrentUserLogger
implements ContainerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(CurrentUserLogger.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Identity identity = this.getCurrentIdentity(requestContext.getSecurityContext());
        if (identity instanceof OrganizationIdentity) {
            logger.debug("Current organization identity '{}', dsf-roles {}", (Object)identity.getName(), identity.getDsfRoles());
        } else if (identity instanceof PractitionerIdentity) {
            PractitionerIdentity practitioner = (PractitionerIdentity)identity;
            logger.debug("Current practitioner identity '{}', dsf-roles {}, practitioner-roles {}", new Object[]{identity.getName(), identity.getDsfRoles(), practitioner.getPractionerRoles().stream().map(c -> c.getSystem() + "|" + c.getCode()).collect(Collectors.joining(", ", "[", "]"))});
        }
    }

    private Identity getCurrentIdentity(SecurityContext context) {
        Principal principal = context.getUserPrincipal();
        if (principal != null) {
            if (principal instanceof Identity) {
                Identity identity = (Identity)principal;
                return identity;
            }
            logger.warn("Unknown current user principal of type {}", (Object)principal.getClass().getName());
            return null;
        }
        return null;
    }
}

